/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAOutputStream;

public class FileArchiveWriter
implements IDocArchiveWriter {
    private String fileName;
    private String tempFolderName;
    private FolderArchiveWriter folderWriter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileArchiveWriter(String fileName) throws IOException {
        if (fileName == null || fileName.length() == 0) {
            throw new IOException("The file name is null or empty string.");
        }
        File fd = new File(fileName);
        this.fileName = fileName = fd.getCanonicalPath();
        this.tempFolderName = fileName + ".tmpfolder";
        File parentFile = new File(fileName).getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        RandomAccessFile rf = new RandomAccessFile(fileName, "rw");
        try {
            rf.setLength(0L);
        }
        finally {
            rf.close();
        }
        File archiveRootFolder = new File(this.tempFolderName);
        if (archiveRootFolder.exists()) {
            ArchiveUtil.DeleteAllFiles(archiveRootFolder);
        }
        if (archiveRootFolder.exists()) {
            throw new IOException("archive root folder can't be removed");
        }
        archiveRootFolder.mkdirs();
        this.folderWriter = new FolderArchiveWriter(this.tempFolderName);
    }

    public void initialize() {
        if (this.folderWriter != null) {
            this.folderWriter.initialize();
        }
    }

    public RAOutputStream createRandomAccessStream(String relativePath) throws IOException {
        if (this.folderWriter != null) {
            return this.folderWriter.createRandomAccessStream(relativePath);
        }
        throw new IOException("the wrapped folder writer is null");
    }

    public boolean dropStream(String relativePath) {
        if (this.folderWriter != null) {
            return this.folderWriter.dropStream(relativePath);
        }
        return false;
    }

    public String getName() {
        return this.fileName;
    }

    public boolean exists(String relativePath) {
        if (this.folderWriter != null) {
            return this.folderWriter.exists(relativePath);
        }
        return false;
    }

    public void setStreamSorter(IStreamSorter streamSorter) {
        if (this.folderWriter != null) {
            this.folderWriter.setStreamSorter(streamSorter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        if (this.folderWriter != null) {
            RandomAccessFile rf = new RandomAccessFile(this.fileName, "rw");
            try {
                this.folderWriter.finish();
                this.folderWriter.toFileArchive(rf);
                this.folderWriter = null;
            }
            finally {
                rf.close();
            }
            ArchiveUtil.DeleteAllFiles(new File(this.tempFolderName));
        }
    }

    public void flush() throws IOException {
        if (this.folderWriter != null) {
            this.folderWriter.flush();
        }
    }

    public Object lock(String stream) throws IOException {
        return stream.toString();
    }

    public void unlock(Object lock) {
    }
}

