/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Formatter;
import com.ibm.log.Level;
import com.ibm.log.LogEvent;
import com.ibm.log.util.CBEGlobalInstanceID;
import com.ibm.log.util.CBEMsgID;
import com.ibm.log.util.ISO8601DateFormat;
import com.ibm.log.util.XMLUtil;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class CBE101Formatter
extends Formatter {
    private static final int CBE_1024_CHUNK_SIZE = 1024;
    private final ISO8601DateFormat iso8601DateFormat = new ISO8601DateFormat();
    private boolean forceAsMessage = false;
    private boolean forceAsTrace = false;

    public CBE101Formatter() {
    }

    public CBE101Formatter(String string) {
        super(string);
    }

    public String format(LogEvent logEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        if (logEvent != null) {
            Iterator iterator;
            Object object;
            boolean bl = this.treatAsMessage(logEvent);
            int n = 0;
            int n2 = 0;
            String string = null;
            String string2 = null;
            String[] stringArray = XMLUtil.escapeXMLChunks(this.getMessage(logEvent), 1024);
            if (bl && stringArray != null && stringArray.length > 0) {
                n = CBEMsgID.getTypeIndex(stringArray[0]);
                n2 = CBEMsgID.getIdLen(n);
                string = CBEMsgID.getIdType(n);
                if (n2 != 0) {
                    string2 = stringArray[0].substring(0, n2);
                }
            }
            String string3 = XMLUtil.escapeXMLString(logEvent.getCorrelationId());
            String string4 = XMLUtil.escapeXMLString(logEvent.getLoggingClass());
            String string5 = XMLUtil.escapeXMLString(logEvent.getLoggingMethod());
            String string6 = XMLUtil.escapeXMLString(logEvent.getClient());
            stringBuffer.append("<CommonBaseEvent");
            this.appendCBECreationTime(logEvent, stringBuffer);
            if (bl) {
                stringBuffer.append(" extensionName=\"ibmcbe:Message-LogXML\"");
            } else {
                stringBuffer.append(" extensionName=\"ibmcbe:Trace-LogXML\"");
            }
            stringBuffer.append(" globalInstanceId=\"");
            CBEGlobalInstanceID.appendCBE101GUID(stringBuffer);
            stringBuffer.append("\"");
            if (stringArray.length > 0) {
                stringBuffer.append(" msg=\"");
                stringBuffer.append(stringArray[0]);
                stringBuffer.append("\"");
            }
            this.appendCBESeverity(bl, string2, stringBuffer);
            stringBuffer.append(" version=\"1.0.1\">");
            if (stringArray.length > 1) {
                int n3 = 1;
                while (n3 < stringArray.length) {
                    object = "message_" + Integer.toString(n3 - 1);
                    this.appendCBEExtendedDataElements((String)object, stringArray[n3], stringBuffer);
                    ++n3;
                }
            }
            if (CBE101Formatter.stringHasValue(string3)) {
                this.appendCBEExtendedDataElements("LogXML:CorrelationId", string3, stringBuffer);
            }
            if (CBE101Formatter.stringHasValue(string4)) {
                this.appendCBEExtendedDataElements("LogXML:FileName", string4, stringBuffer);
            }
            if (CBE101Formatter.stringHasValue(string5)) {
                this.appendCBEExtendedDataElements("LogXML:Method", string5, stringBuffer);
            }
            if (CBE101Formatter.stringHasValue(string6)) {
                this.appendCBEExtendedDataElements("LogXML:Principal", string6, stringBuffer);
            }
            if (!bl && (object = logEvent.getLevel()) != null) {
                this.appendCBEExtendedDataElements("LogXML:Level", ((Level)object).getName(), stringBuffer);
            }
            if (!bl && CBE101Formatter.stringHasValue((String)(object = logEvent.getStackTrace()))) {
                String[] stringArray2 = XMLUtil.escapeXMLChunks((String)object, 1024);
                this.appendCBEExtendedDataElements("LogXML:Exception", stringArray2, stringBuffer);
            }
            if ((iterator = logEvent.getKeysAndValues()) != null) {
                while (iterator.hasNext()) {
                    object = (Map.Entry)iterator.next();
                    String string7 = XMLUtil.escapeXMLString((String)object.getKey());
                    String string8 = XMLUtil.escapeXMLString((String)object.getValue());
                    this.appendCBEExtendedDataElements("LogXML:LogAttribs:" + string7, string8, stringBuffer);
                }
            }
            this.appendSourceComponentId(logEvent, bl, stringBuffer);
            if (bl) {
                this.appendMsgDataElement(logEvent, string2, string, stringBuffer);
            }
            this.appendSituation(bl, stringBuffer);
            stringBuffer.append("</CommonBaseEvent>");
        }
        return stringBuffer.toString();
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("forceAsMessage", new Boolean(this.forceAsMessage).toString());
        properties.put("forceAsTrace", new Boolean(this.forceAsTrace).toString());
        return properties;
    }

    public void setConfig(Properties properties) {
        if (properties != null) {
            super.setConfig(properties);
            String string = properties.getProperty("forceAsMessage");
            if (string != null) {
                this.setForceAsMessage(new Boolean(string));
            }
            if ((string = properties.getProperty("forceAsTrace")) != null) {
                this.setForceAsTrace(new Boolean(string));
            }
        }
    }

    public boolean isForceAsMessage() {
        return this.forceAsMessage;
    }

    public void setForceAsMessage(boolean bl) {
        this.forceAsMessage = bl;
    }

    public boolean isForceAsTrace() {
        return this.forceAsTrace;
    }

    public void setForceAsTrace(boolean bl) {
        this.forceAsTrace = bl;
    }

    private boolean treatAsMessage(LogEvent logEvent) {
        boolean bl = this.forceAsMessage == this.forceAsTrace ? logEvent != null && logEvent.getMessageFile() != null : this.forceAsMessage;
        return bl;
    }

    private void appendCBECreationTime(LogEvent logEvent, StringBuffer stringBuffer) {
        if (logEvent != null && stringBuffer != null) {
            Date date = new Date(logEvent.getTimeStamp());
            stringBuffer.append(" creationTime=\"");
            this.iso8601DateFormat.format(date, stringBuffer, new FieldPosition(0));
            stringBuffer.append("\"");
        }
    }

    private void appendCBESeverity(boolean bl, String string, StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            String string2 = null;
            if (bl && CBE101Formatter.stringHasValue(string)) {
                if (string.endsWith("I")) {
                    string2 = "10";
                } else if (string.endsWith("W")) {
                    string2 = "30";
                } else if (string.endsWith("E")) {
                    string2 = "50";
                }
            } else {
                string2 = "10";
            }
            if (string2 != null) {
                stringBuffer.append(" severity=\"");
                stringBuffer.append(string2);
                stringBuffer.append("\"");
            }
        }
    }

    private void appendCBEExtendedDataElements(String string, String string2, StringBuffer stringBuffer) {
        if (stringBuffer != null && CBE101Formatter.stringHasValue(string2)) {
            stringBuffer.append("<extendedDataElements name=\"");
            stringBuffer.append(string);
            stringBuffer.append("\" type=\"string\"><values>");
            stringBuffer.append(string2);
            stringBuffer.append("</values></extendedDataElements>");
        }
    }

    private void appendCBEExtendedDataElements(String string, String[] stringArray, StringBuffer stringBuffer) {
        if (stringBuffer != null && stringArray != null) {
            stringBuffer.append("<extendedDataElements name=\"");
            stringBuffer.append(string);
            stringBuffer.append("\" type=\"string\">");
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append("<values>");
                stringBuffer.append(stringArray[n]);
                stringBuffer.append("</values>");
                ++n;
            }
            stringBuffer.append("</extendedDataElements>");
        }
    }

    private void appendSourceComponentId(LogEvent logEvent, boolean bl, StringBuffer stringBuffer) {
        if (stringBuffer != null && logEvent != null) {
            String string;
            String string2 = XMLUtil.escapeXMLString(logEvent.getProduct());
            String string3 = XMLUtil.escapeXMLString(logEvent.getComponent());
            String string4 = XMLUtil.escapeXMLString(logEvent.getProductInstance());
            String string5 = XMLUtil.escapeXMLString(logEvent.getServer());
            String string6 = logEvent.getServerFormat();
            String string7 = !CBE101Formatter.stringHasValue(string6) || string6.equalsIgnoreCase("OTHER") ? "Unknown" : (string6.equalsIgnoreCase("IP") ? "IPV4" : string6);
            stringBuffer.append("<sourceComponentId");
            stringBuffer.append(" component=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\" componentIdType=\"Unknown\" instanceId=\"");
            stringBuffer.append(string4);
            stringBuffer.append("\" location=\"");
            stringBuffer.append(string5);
            stringBuffer.append("\" locationType=\"");
            stringBuffer.append(string7);
            stringBuffer.append("\" subComponent=\"");
            stringBuffer.append(string3);
            if (!bl && CBE101Formatter.stringHasValue(string = XMLUtil.escapeXMLString(logEvent.getThreadName()))) {
                stringBuffer.append("\" threadId=\"");
                stringBuffer.append(string);
            }
            stringBuffer.append("\" componentType=\"");
            stringBuffer.append("http://www.ibm.com/namespaces/autonomic/Tivoli_componentTypes");
            stringBuffer.append("\"/>");
        }
    }

    private void appendSituation(boolean bl, StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            stringBuffer.append("<situation categoryName=\"ReportSituation\">");
            stringBuffer.append("<situationType");
            stringBuffer.append(" xsi:type=\"ReportSituation\"");
            stringBuffer.append(" reasoningScope=\"INTERNAL\"");
            if (bl) {
                stringBuffer.append(" reportCategory=\"LOG\"");
            } else {
                stringBuffer.append(" reportCategory=\"TRACE\"");
            }
            stringBuffer.append("/></situation>");
        }
    }

    private void appendMsgDataElement(LogEvent logEvent, String string, String string2, StringBuffer stringBuffer) {
        if (stringBuffer != null && logEvent != null) {
            String string3 = XMLUtil.escapeXMLString(logEvent.getMessageFile());
            String string4 = XMLUtil.escapeXMLString(logEvent.getMessageKey());
            Object[] objectArray = logEvent.getInserts();
            stringBuffer.append("<msgDataElement>");
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    String string5 = null;
                    if (objectArray[n] != null) {
                        string5 = objectArray[n].toString();
                    }
                    stringBuffer.append("<msgCatalogTokens value=\"");
                    stringBuffer.append(XMLUtil.escapeXMLString(string5));
                    stringBuffer.append("\"/>");
                    ++n;
                }
            }
            if (CBE101Formatter.stringHasValue(string) && CBE101Formatter.stringHasValue(string2)) {
                stringBuffer.append("<msgId>");
                stringBuffer.append(string);
                stringBuffer.append("</msgId>");
                stringBuffer.append("<msgIdType>");
                stringBuffer.append(string2);
                stringBuffer.append("</msgIdType>");
            }
            if (CBE101Formatter.stringHasValue(string4)) {
                stringBuffer.append("<msgCatalogId>");
                stringBuffer.append(string4);
                stringBuffer.append("</msgCatalogId>");
            }
            if (CBE101Formatter.stringHasValue(string3)) {
                stringBuffer.append("<msgCatalogType>JAVA</msgCatalogType>");
                stringBuffer.append("<msgCatalog>");
                stringBuffer.append(string3);
                stringBuffer.append("</msgCatalog>");
            }
            stringBuffer.append("</msgDataElement>");
        }
    }

    private static boolean stringHasValue(String string) {
        return string != null && string.length() > 0;
    }
}

