/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Level;
import com.ibm.log.LevelFilter;
import com.ibm.log.Logger;
import com.ibm.log.util.LogUtil;
import java.util.Properties;

public abstract class LevelLoggerSupport
extends Logger {
    private LevelFilter levelFilter = new LevelFilter("", Level.INFO);

    public LevelLoggerSupport() {
    }

    public LevelLoggerSupport(String string) {
        super(string);
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("level", this.getLevel().getName());
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("level");
        if (string != null) {
            Level level = Level.getLevel(string);
            if (level == null) {
                String[] stringArray = new String[]{string};
                String string2 = LogUtil.getLogMsg("ERR_BAD_LEVEL", stringArray, String.valueOf(this.getClass().getName()) + ".setConfig");
                LogUtil.errorMsg(string2);
                level = Level.INFO;
            }
            this.setLevel(level);
        }
    }

    public Level getLevel() {
        return this.levelFilter.getLevel();
    }

    public void setLevel(Level level) {
        if (level != null) {
            this.levelFilter.setLevel(level);
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setLevel");
            LogUtil.errorMsg(string);
        }
    }

    public boolean isLoggable(Level level) {
        return this.isLogging() && this.levelFilter.isLoggable(level);
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string) + ", " + this.getLevel().toString();
    }
}

