/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Handler;
import com.ibm.log.LogEvent;
import com.ibm.log.util.LogUtil;
import java.awt.Font;
import java.awt.TextArea;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class TextAreaHandler
extends Handler {
    static final long serialVersionUID = -2142392853659685433L;
    private transient TextArea textArea;

    public TextAreaHandler() throws AccessControlException {
        this.createTextArea();
        this.textArea.setFont(new Font("Monospaced", 0, 12));
    }

    public TextAreaHandler(String string) throws AccessControlException {
        super(string);
        this.createTextArea();
        this.textArea.setFont(new Font("Monospaced", 0, 12));
    }

    public TextAreaHandler(String string, TextArea textArea) {
        super(string);
        this.setTextArea(textArea);
    }

    private void createTextArea() throws AccessControlException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            this.textArea = new TextArea();
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    TextAreaHandler.this.textArea = new TextArea();
                    return null;
                }
            });
        }
    }

    public TextArea getTextArea() {
        return this.textArea;
    }

    public void setTextArea(TextArea textArea) {
        if (textArea != null) {
            this.textArea = textArea;
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setTextArea");
            LogUtil.errorMsg(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                this.open = true;
                this.writeHeader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.open) {
                try {
                    this.writeTrailer();
                }
                catch (Exception exception) {}
            }
            this.open = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(LogEvent logEvent) throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                this.open();
            }
            String string = this.getFormatter().format(logEvent);
            this.textArea.append(String.valueOf(string) + "\n");
        }
    }

    protected void writeHeader() throws Exception {
        String string = this.getFormatter().getHeader();
        if (string != null) {
            this.textArea.append(string);
        }
    }

    protected void writeTrailer() throws Exception {
        String string = this.getFormatter().getTrailer();
        if (string != null) {
            this.textArea.append(string);
        }
    }
}

