/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.util.DataBoundColumnUtil;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class DataColumnNameValidator
extends AbstractElementValidator {
    private static DataColumnNameValidator instance = new DataColumnNameValidator();

    public static DataColumnNameValidator getInstance() {
        return instance;
    }

    public List validate(Module module, DesignElement element) {
        if (!(element instanceof DataItem)) {
            return Collections.EMPTY_LIST;
        }
        return this.doValidate(module, (DataItem)element);
    }

    private List doValidate(Module module, DataItem toValidate) {
        ArrayList<SemanticError> list = new ArrayList<SemanticError>();
        String columnName = (String)toValidate.getLocalProperty(module, "resultSetColumn");
        if (columnName == null) {
            return list;
        }
        if (!DataColumnNameValidator.hasCorrespondingColumnBinding(module, toValidate, columnName)) {
            list.add(new SemanticError((DesignElement)toValidate, new String[]{columnName}, "Error.SemanticError.MISSING_COLUMN_BINDING"));
        }
        return list;
    }

    private static boolean hasCorrespondingColumnBinding(Module module, DesignElement target, String columnBindingName) {
        List columns;
        DesignElement tmpElement = DataBoundColumnUtil.findTargetOfBoundColumns(target, module);
        return tmpElement instanceof GroupElement ? DataColumnNameValidator.exists(columns = (List)(tmpElement = tmpElement.getContainer()).getProperty(module, "boundDataColumns"), columnBindingName) : DataColumnNameValidator.exists(columns = (List)tmpElement.getProperty(module, "boundDataColumns"), columnBindingName);
    }

    private static boolean exists(List columns, String columnName) {
        return DataColumnNameValidator.getColumn(columns, columnName) != null;
    }

    public static ComputedColumn getColumn(List columns, String name) {
        if (columns == null || columns.size() == 0 || name == null) {
            return null;
        }
        for (int i = 0; i < columns.size(); ++i) {
            ComputedColumn column = (ComputedColumn)columns.get(i);
            if (!name.equals(column.getName())) continue;
            return column;
        }
        return null;
    }
}

