/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;

public class CachedMemberRef
extends MemberRef {
    private static final int UNKNOWN = 1;
    private static final int LOCAL = 2;
    private static final int INHERITED = 3;
    private final Structure[] structures = new Structure[2];
    private boolean cached = false;
    private int cachedFrom = 1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CachedMemberRef(MemberRef ref) {
        super(ref);
        this.structures[0] = ((CachedMemberRef)ref).structures[0];
        this.structures[1] = ((CachedMemberRef)ref).structures[1];
        this.cached = ((CachedMemberRef)ref).cached;
        this.cachedFrom = ((CachedMemberRef)ref).cachedFrom;
    }

    public CachedMemberRef(ElementPropertyDefn prop) {
        super(prop);
    }

    public CachedMemberRef(ElementPropertyDefn prop, int n) {
        super(prop, n);
    }

    public CachedMemberRef(ElementPropertyDefn prop, int n, String memberName) {
        super(prop, n, memberName);
    }

    public CachedMemberRef(ElementPropertyDefn prop, int n, StructPropertyDefn memberDef) {
        super(prop, n, memberDef);
    }

    public CachedMemberRef(ElementPropertyDefn prop, String memberName) {
        super(prop, memberName);
    }

    public CachedMemberRef(ElementPropertyDefn prop, StructPropertyDefn memberDef) {
        super(prop, memberDef);
    }

    public CachedMemberRef(MemberRef ref, int n) {
        super(ref, n);
        if (ref instanceof CachedMemberRef) {
            this.structures[0] = ((CachedMemberRef)ref).structures[0];
            this.structures[1] = ((CachedMemberRef)ref).structures[1];
        }
    }

    public CachedMemberRef(MemberRef ref, int n, StructPropertyDefn memberDefn) {
        super(ref, n, memberDefn);
        if (ref instanceof CachedMemberRef) {
            this.structures[0] = ((CachedMemberRef)ref).structures[0];
            this.structures[1] = ((CachedMemberRef)ref).structures[1];
        }
    }

    public CachedMemberRef(MemberRef ref, String memberName) {
        super(ref, memberName);
        if (ref instanceof CachedMemberRef) {
            this.structures[0] = ((CachedMemberRef)ref).structures[0];
            this.structures[1] = ((CachedMemberRef)ref).structures[1];
            this.cached = ((CachedMemberRef)ref).cached;
            this.cachedFrom = ((CachedMemberRef)ref).cachedFrom;
        }
    }

    public CachedMemberRef(MemberRef ref, StructPropertyDefn memberDefn) {
        super(ref, memberDefn);
        if (ref instanceof CachedMemberRef) {
            this.structures[0] = ((CachedMemberRef)ref).structures[0];
            this.structures[1] = ((CachedMemberRef)ref).structures[1];
            this.cached = ((CachedMemberRef)ref).cached;
            this.cachedFrom = ((CachedMemberRef)ref).cachedFrom;
        }
    }

    public boolean checkOrCacheStructure(Module module, DesignElement element) {
        if (this.cached) {
            return this.checkCachedStructure(module, element);
        }
        this.doCacheStructure(module, element);
        if (!$assertionsDisabled && this.cachedFrom == 1) {
            throw new AssertionError();
        }
        return true;
    }

    private void doCacheStructure(Module module, DesignElement element) {
        this.cached = true;
        Object localValue = element.getLocalProperty(module, this.propDefn);
        int n = this.cachedFrom = localValue != null ? 2 : 3;
        if (this.propDefn.isList()) {
            List list = super.getList(module, element);
            if (list == null) {
                return;
            }
            if (this.depth == 1) {
                this.structures[0] = super.getStructure(list, 0);
            } else if (this.depth == 2) {
                if (!$assertionsDisabled && !(localValue instanceof List)) {
                    throw new AssertionError();
                }
                this.structures[0] = super.getStructure((List)localValue, 0);
                this.structures[1] = super.getStructure(list, 1);
            }
        } else {
            Structure struct = (Structure)element.getProperty(module, this.propDefn);
            if (struct == null) {
                return;
            }
            if (this.index[0] >= 0) {
                if (!$assertionsDisabled && !this.member[0].isList()) {
                    throw new AssertionError();
                }
                ArrayList list = (ArrayList)struct.getProperty(module, this.member[0]);
                this.structures[0] = super.getStructure(list, 0);
            }
        }
    }

    private boolean checkCachedStructure(Module module, DesignElement element) {
        if (!$assertionsDisabled && !this.cached) {
            throw new AssertionError();
        }
        Object localValue = element.getLocalProperty(module, this.propDefn);
        if (this.cachedFrom == 2 && localValue == null || this.cachedFrom == 3 && localValue != null) {
            this.structures[0] = null;
            this.structures[1] = null;
            this.doCacheStructure(module, element);
            return true;
        }
        if (this.propDefn.isList()) {
            List list = super.getList(module, element);
            if (list == null) {
                return this.structures[0] == null;
            }
            if (this.depth == 1 ? (0 > this.index[0] || this.index[0] >= list.size() || this.structures[0] != list.get(this.index[0])) && this.structures[0] != null && !list.contains(this.structures[0]) : this.depth == 2 && (0 > this.index[1] || this.index[1] >= list.size() || this.structures[1] != list.get(this.index[1])) && this.structures[1] != null && !list.contains(this.structures[1])) {
                return false;
            }
        }
        return true;
    }

    public List getList(Module module, DesignElement element) {
        if (!this.checkOrCacheStructure(module, element)) {
            return null;
        }
        return super.getList(module, element);
    }

    public Object getLocalValue(Module module, DesignElement element) {
        if (!this.checkOrCacheStructure(module, element)) {
            return null;
        }
        return super.getLocalValue(module, element);
    }

    public Structure getStructure(Module module, DesignElement element) {
        if (!this.checkOrCacheStructure(module, element)) {
            return null;
        }
        return super.getStructure(module, element);
    }

    public Object getValue(Module module, DesignElement element) {
        if (!this.checkOrCacheStructure(module, element)) {
            return null;
        }
        return super.getValue(module, element);
    }

    Structure getStructure(List list, int level) {
        return this.structures[level];
    }

    static {
        $assertionsDisabled = !CachedMemberRef.class.desiredAssertionStatus();
    }
}

