/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.DataColumnNameValidator;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ListGroup;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ReportItemState;
import org.eclipse.birt.report.model.util.LevelContentIterator;
import org.xml.sax.SAXException;

public abstract class ListingItemState
extends ReportItemState {
    protected ListingElement element;

    public ListingItemState(ModuleParserHandler handler, DesignElement theContainer, int slot) {
        super(handler, theContainer, slot);
    }

    public DesignElement getElement() {
        return this.element;
    }

    public void end() throws SAXException {
        this.makeTestExpressionCompatible();
        Set elements = this.handler.tempValue.keySet();
        ContainerSlot groups = this.element.getSlot(1);
        for (int i = 0; i < groups.getCount(); ++i) {
            List columns;
            GroupElement group = (GroupElement)groups.getContent(i);
            this.handler.getModule().getNameManager().makeUniqueName(group);
            String groupName = (String)group.getLocalProperty(this.handler.getModule(), "groupName");
            if (!elements.contains(group) || this.handler.versionNumber >= 3020200 || (columns = (List)this.handler.tempValue.get(group)) == null || columns.isEmpty()) continue;
            ArrayList tmpList = (ArrayList)this.element.getLocalProperty(this.handler.module, "boundDataColumns");
            if (tmpList == null) {
                tmpList = new ArrayList();
                this.element.setProperty("boundDataColumns", tmpList);
            }
            if (this.handler.versionNumber <= 3000000) {
                this.addCachedListWithAggregateOnToListing(columns, tmpList, group, groupName);
                continue;
            }
            this.addCachedListToListing(columns, tmpList, group, groupName);
        }
        super.end();
    }

    private ComputedColumn checkMatchedBoundColumnForGroup(List columns, String expression, String aggregateOn, boolean mustMatchAggregateOn) {
        if (columns == null || columns.size() == 0 || expression == null) {
            return null;
        }
        for (int i = 0; i < columns.size(); ++i) {
            ComputedColumn column = (ComputedColumn)columns.get(i);
            if (!expression.equals(column.getExpression())) continue;
            String tmpAggregateOn = column.getAggregateOn();
            if (mustMatchAggregateOn) {
                if (aggregateOn == null && tmpAggregateOn == null) {
                    return column;
                }
                if (aggregateOn == null || !aggregateOn.equals(tmpAggregateOn)) continue;
                return column;
            }
            if (tmpAggregateOn != null && !tmpAggregateOn.equals(aggregateOn)) continue;
            return column;
        }
        return null;
    }

    private String getUniqueBoundColumnNameForGroup(List columns, ComputedColumn checkColumn) {
        ComputedColumn column;
        String oldName;
        String tmpName = oldName = checkColumn.getName();
        int index = 0;
        while ((column = DataColumnNameValidator.getColumn(columns, tmpName)) != null) {
            tmpName = oldName + "_" + ++index;
        }
        return tmpName;
    }

    private void reCheckResultSetColumnName(GroupElement group, List columns) {
        int level = -1;
        if (group instanceof TableGroup) {
            level = 3;
        }
        if (group instanceof ListGroup) {
            level = 1;
        }
        LevelContentIterator contentIter = new LevelContentIterator(group, level);
        while (contentIter.hasNext()) {
            String resultSetColumn;
            DesignElement item = (DesignElement)contentIter.next();
            if (!(item instanceof DataItem) || StringUtil.isBlank(resultSetColumn = (String)item.getLocalProperty(this.handler.module, "resultSetColumn"))) continue;
            ComputedColumn foundColumn = DataColumnNameValidator.getColumn(columns, resultSetColumn);
            foundColumn = this.checkMatchedBoundColumnForGroup(columns, foundColumn.getExpression(), (String)group.getLocalProperty(this.handler.module, "groupName"), ExpressionUtil.hasAggregation((String)foundColumn.getExpression()));
            item.setProperty("resultSetColumn", (Object)foundColumn.getName());
        }
    }

    public void addCachedListWithAggregateOnToListing(List columns, List tmpList, GroupElement group, String groupName) {
        for (int j = 0; j < columns.size(); ++j) {
            ComputedColumn foundColumn;
            ComputedColumn column = (ComputedColumn)columns.get(j);
            if (ExpressionUtil.hasAggregation((String)column.getExpression())) {
                column.setAggregateOn(groupName);
            }
            if ((foundColumn = this.checkMatchedBoundColumnForGroup(tmpList, column.getExpression(), column.getAggregateOn(), true)) != null && foundColumn.getName().equals(column.getName())) continue;
            String newName = this.getUniqueBoundColumnNameForGroup(tmpList, column);
            column.setName(newName);
            tmpList.add(column);
        }
        this.reCheckResultSetColumnName(group, tmpList);
    }

    public void addCachedListToListing(List columns, List tmpList, GroupElement group, String groupName) {
        for (int j = 0; j < columns.size(); ++j) {
            ComputedColumn column = (ComputedColumn)columns.get(j);
            if (tmpList.contains(column)) continue;
            if (ExpressionUtil.hasAggregation((String)column.getExpression())) {
                column.setAggregateOn(groupName);
            }
            tmpList.add(column);
        }
    }
}

