/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.parser.DesignParseState;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.AnyElementState;
import org.eclipse.birt.report.model.util.ElementStructureUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;

class OverriddenValuesState
extends AbstractParseState {
    private ModuleParserHandler handler;
    private Map baseIdMap = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    OverriddenValuesState(ModuleParserHandler handler, DesignElement element) {
        this.handler = handler;
        if (!$assertionsDisabled && element.getExtendsElement() == null) {
            throw new AssertionError();
        }
        this.baseIdMap = ElementStructureUtil.getIdMap(element);
    }

    public XMLParserHandler getHandler() {
        return this.handler;
    }

    public AbstractParseState startElement(String tagName) {
        if ("ref-entry".equalsIgnoreCase(tagName)) {
            return new RefEntryState(this.handler);
        }
        return super.startElement(tagName);
    }

    static {
        $assertionsDisabled = !OverriddenValuesState.class.desiredAssertionStatus();
    }

    class RefEntryState
    extends DesignParseState {
        private long baseId;
        private boolean isBaseValid;

        RefEntryState(ModuleParserHandler handler) {
            super(handler);
            this.baseId = 0L;
            this.isBaseValid = true;
        }

        public XMLParserHandler getHandler() {
            return this.handler;
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            String baseIdStr = attrs.getValue("baseId");
            if (baseIdStr == null) {
                return;
            }
            try {
                this.baseId = Long.parseLong(baseIdStr);
            }
            catch (NumberFormatException e) {
                DesignParserException ex = new DesignParserException(new String[]{baseIdStr}, "Error.DesignParserException.INVALID_ELEMENT_ID");
                this.handler.getErrorHandler().semanticError((Exception)((Object)ex));
                this.isBaseValid = false;
                return;
            }
            DesignElement virtualChild = this.getElement();
            if (virtualChild == null) {
                this.isBaseValid = false;
                DesignParserException ex = new DesignParserException(new String[]{baseIdStr}, "Error.DesignParserException.VIRTUAL_PARENT_NOT_FOUND");
                this.handler.getErrorHandler().semanticWarning((Exception)((Object)ex));
                return;
            }
            String name = attrs.getValue("name");
            if (!StringUtil.isBlank(name)) {
                virtualChild.setName(name);
            }
        }

        public DesignElement getElement() {
            Object obj = OverriddenValuesState.this.baseIdMap.get(new Long(this.baseId));
            return (DesignElement)obj;
        }

        public AbstractParseState startElement(String tagName) {
            if (!this.isBaseValid) {
                return new AnyElementState(this.getHandler());
            }
            return super.startElement(tagName);
        }
    }
}

