/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.OdaDesignerState;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ListGroup;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.AbstractPropertyState;
import org.eclipse.birt.report.model.parser.Base64PropertyState;
import org.eclipse.birt.report.model.parser.CompatibleColumnDataTypeState;
import org.eclipse.birt.report.model.parser.CompatibleFormatPropertyState;
import org.eclipse.birt.report.model.parser.CompatibleIgnorePropertyState;
import org.eclipse.birt.report.model.parser.CompatibleMiscExpressionState;
import org.eclipse.birt.report.model.parser.CompatibleOnRowPropertyState;
import org.eclipse.birt.report.model.parser.CompatibleOperatorState;
import org.eclipse.birt.report.model.parser.CompatiblePageBreakPropState;
import org.eclipse.birt.report.model.parser.CompatiblePropertyTypeState;
import org.eclipse.birt.report.model.parser.CompatibleRenamedPropertyState;
import org.eclipse.birt.report.model.parser.CompatibleVerticalAlignState;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.RecoverableError;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.xml.sax.SAXException;

class PropertyState
extends AbstractPropertyState {
    protected PropertyDefn propDefn = null;

    PropertyState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
    }

    PropertyState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, IStructure struct) {
        super(theHandler, element);
        this.propDefn = propDefn;
        this.struct = struct;
    }

    protected void setName(String name) {
        super.setName(name);
        this.propDefn = this.struct != null ? (PropertyDefn)this.struct.getDefn().getMember(name) : this.element.getPropertyDefn(name);
    }

    public void end() throws SAXException {
        String value = this.text.toString();
        this.doEnd(value);
    }

    protected void doEnd(String value) {
        if (this.struct != null) {
            this.setMember(this.struct, this.propDefn.getName(), this.name, value);
            return;
        }
        if ("style".equalsIgnoreCase(this.name)) {
            if (!this.element.getDefn().hasStyle()) {
                DesignParserException e = new DesignParserException(new String[]{this.name}, "Error.DesignParserException.UNDEFINED_PROPERTY");
                RecoverableError.dealUndefinedProperty(this.handler, e);
                return;
            }
            ((StyledElement)this.element).setStyleName(value);
        } else {
            this.setProperty(this.name, value);
        }
    }

    protected AbstractParseState generalJumpTo() {
        IPropertyDefn jmpDefn = null;
        jmpDefn = this.struct != null ? this.struct.getDefn().getMember(this.name) : this.element.getPropertyDefn(this.name);
        if (this.element instanceof ListGroup && "groupStart".equalsIgnoreCase(this.name)) {
            CompatibleRenamedPropertyState state = new CompatibleRenamedPropertyState(this.handler, this.element, "groupStart");
            state.setName("intervalBase");
            return state;
        }
        if (this.element instanceof ReportDesign && "cheetSheet".equalsIgnoreCase(this.name)) {
            CompatibleRenamedPropertyState state = new CompatibleRenamedPropertyState(this.handler, this.element, "cheetSheet");
            state.setName("cheatSheet");
            return state;
        }
        if (jmpDefn != null && ("operator".equalsIgnoreCase(jmpDefn.getName()) || "operator".equalsIgnoreCase(jmpDefn.getName()))) {
            CompatibleOperatorState state = new CompatibleOperatorState(this.handler, this.element, this.propDefn, this.struct);
            state.setName(this.name);
            return state;
        }
        if (jmpDefn != null && jmpDefn.getStructDefn() != null && ("DateTimeFormatValue".equalsIgnoreCase(jmpDefn.getStructDefn().getName()) || "NumberFormatValue".equalsIgnoreCase(jmpDefn.getStructDefn().getName()) || "StringFormatValue".equalsIgnoreCase(jmpDefn.getStructDefn().getName()) || "ParameterFormatValue".equalsIgnoreCase(jmpDefn.getStructDefn().getName()))) {
            CompatibleFormatPropertyState state = new CompatibleFormatPropertyState(this.handler, this.element, this.propDefn, this.struct);
            state.setName(this.name);
            state.createStructure();
            return state;
        }
        if ("GraphicMasterPage".equalsIgnoreCase(this.element.getDefn().getName()) && (this.name.equalsIgnoreCase("headerHeight") || this.name.equalsIgnoreCase("footerHeight"))) {
            return new CompatibleIgnorePropertyState(this.handler, this.element);
        }
        if (this.element instanceof ListingElement || this.element instanceof GroupElement) {
            if ("pageBreakInterval".equalsIgnoreCase(this.name) && this.element instanceof GroupElement) {
                return new CompatibleIgnorePropertyState(this.handler, this.element);
            }
            if (this.name.equalsIgnoreCase("onStart") || this.name.equalsIgnoreCase("onFinish")) {
                return new CompatibleIgnorePropertyState(this.handler, this.element);
            }
            if ("onRow".equalsIgnoreCase(this.name) && !(this.element instanceof TableItem)) {
                return new CompatibleIgnorePropertyState(this.handler, this.element);
            }
            if ("onRow".equalsIgnoreCase(this.name)) {
                return new CompatibleOnRowPropertyState(this.handler, this.element);
            }
        }
        if (this.element instanceof GroupElement && ("onCreate".equalsIgnoreCase(this.name) || "onRender".equalsIgnoreCase(this.name))) {
            return new CompatibleIgnorePropertyState(this.handler, this.element);
        }
        if ("pageBreakBefore".equalsIgnoreCase(this.name) || "pageBreakAfter".equalsIgnoreCase(this.name) || "pageBreakInside".equalsIgnoreCase(this.name)) {
            CompatiblePageBreakPropState state = new CompatiblePageBreakPropState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        if (this.element instanceof ReportDesign && "thumbnail".equalsIgnoreCase(this.name)) {
            Base64PropertyState state = new Base64PropertyState(this.handler, this.element, "8859_1");
            state.setName(this.name);
            return state;
        }
        if (this.struct instanceof EmbeddedImage && "data".equalsIgnoreCase(this.name)) {
            Base64PropertyState state = new Base64PropertyState(this.handler, this.element, this.propDefn, this.struct, "8859_1");
            state.setName(this.name);
            return state;
        }
        if (this.struct instanceof OdaDesignerState && "stateContentAsBlob".equalsIgnoreCase(this.name)) {
            Base64PropertyState state = new Base64PropertyState(this.handler, this.element, this.propDefn, this.struct, "8859_1");
            state.setName(this.name);
            return state;
        }
        if ("onCreate".equalsIgnoreCase(this.name) || "onCreate".equalsIgnoreCase(this.name)) {
            CompatibleMiscExpressionState state = new CompatibleMiscExpressionState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        return super.generalJumpTo();
    }

    protected AbstractParseState versionConditionalJumpTo() {
        if (this.handler.versionNumber < 3020200 && "verticalAlign".equals(this.name)) {
            CompatibleVerticalAlignState state = new CompatibleVerticalAlignState(this.handler, this.element);
            state.setName("verticalAlign");
            return state;
        }
        if (this.handler.versionNumber < 3020400 && this.element instanceof ScalarParameter && "defaultValue".equalsIgnoreCase(this.name)) {
            CompatiblePropertyTypeState state = new CompatiblePropertyTypeState(this.handler, this.element);
            state.setName("defaultValue");
            return state;
        }
        if (this.handler.versionNumber <= 3020000 && this.struct instanceof DataSetParameter && "isNullable".equals(this.name)) {
            CompatibleRenamedPropertyState state = new CompatibleRenamedPropertyState(this.handler, this.element, this.propDefn, this.struct, "isNullable");
            state.setName("allowNull");
            return state;
        }
        if ("onCreate".equalsIgnoreCase(this.name) && this.handler.versionNumber < 3020000) {
            CompatibleMiscExpressionState state = new CompatibleMiscExpressionState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        if (this.struct instanceof ComputedColumn && "aggregrateOn".equalsIgnoreCase(this.name) && (this.element instanceof ScalarParameter || this.element instanceof ReportItem) & this.handler.versionNumber <= 3020200) {
            CompatibleRenamedPropertyState state = new CompatibleRenamedPropertyState(this.handler, this.element, this.propDefn, this.struct, "aggregrateOn");
            state.setName("aggregateOn");
            return state;
        }
        if (this.handler.versionNumber < 3020600 && (this.struct instanceof DataSetParameter || this.struct instanceof OdaDataSetParameter) && "dataType".equalsIgnoreCase(this.name)) {
            CompatibleColumnDataTypeState state = new CompatibleColumnDataTypeState(this.handler, this.element, this.propDefn, this.struct);
            state.setName("dataType");
            return state;
        }
        return super.versionConditionalJumpTo();
    }
}

