/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPScanner;
import org.eclipse.aperi.discovery.snmp.scanner.data.Entity;
import org.eclipse.aperi.discovery.snmp.scanner.data.Parameter;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.MissingUniqueIdException;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.Response;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.snmp.SnmpSocketException;

public class TopologyScanner
extends SNMPScanner {
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    public static final String MSG_FILE = "org.eclipse.aperi.sanmgmt.sanmgr.resources.MibQueryEngineTMS";
    public static final int NORMALREQ = 0;
    public static final int ZONEREQ = 1;
    public String scanId = null;
    static final String className;
    private final String SCANNERNAME = "Topology";
    private final int WWNSIZE = 32;
    private final String OUTBAND_TOPOLOGY_SCANNER = "OutbandTopologyScanner:";
    private Vector ePortList = new Vector();
    private String result = new String();
    private Vector sanList = new Vector();
    private Vector sysURL = new Vector();
    private Vector ieList = new Vector();
    private Vector icList = new Vector();
    private Vector portList = new Vector();
    private Vector atpList = new Vector();
    private Vector nodeList = new Vector();
    private Vector sanPortList = new Vector();
    private Vector attachedPort_NxType = new Vector();

    static {
        Class<?> clazz;
        msgLogger = SNMPScanner.msgLogger;
        traceLogger = SNMPScanner.traceLogger;
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.snmp.scanner.TopologyScanner");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        msgLogger.setMessageFile(MSG_FILE);
    }

    private void setPortTypeValue(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                if (parameter.getName().equals("Type")) {
                    String string = parameter.getValue();
                    if (string.equals("1")) {
                        parameter.setValue("Unknown");
                    } else if (string.equals("2")) {
                        parameter.setValue("Other");
                    } else if (string.equals("3")) {
                        parameter.setValue("Unknown");
                    } else if (string.equals("4")) {
                        parameter.setValue("E_Port");
                    } else if (string.equals("5")) {
                        parameter.setValue("N_Port");
                    } else if (string.equals("6")) {
                        parameter.setValue("L_Port");
                    } else if (string.equals("7")) {
                        parameter.setValue("FL_Port");
                    } else if (string.equals("8")) {
                        parameter.setValue("F_Port");
                    } else if (string.equals("9")) {
                        parameter.setValue("E_Port");
                    } else if (string.equals("10")) {
                        parameter.setValue("G_Port");
                    } else if (string.equals("11")) {
                        parameter.setValue("Domain_Ctl");
                    } else if (string.equals("12")) {
                        parameter.setValue("Hub_Controller");
                    } else if (string.equals("13")) {
                        parameter.setValue("Scsi");
                    } else if (string.equals("14")) {
                        parameter.setValue("Escon");
                    } else if (string.equals("15")) {
                        parameter.setValue("Lan");
                    } else if (string.equals("16")) {
                        parameter.setValue("Wan");
                    }
                }
                if (parameter.getName().equals("State")) {
                    if (parameter.getValue().equals("1")) {
                        parameter.setValue("Unknown");
                    } else if (parameter.getValue().equals("2")) {
                        parameter.setValue("Online");
                    } else if (parameter.getValue().equals("3")) {
                        parameter.setValue("Offline");
                    } else if (parameter.getValue().equals("4")) {
                        parameter.setValue("Bypassed");
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    private String xrefsHelper(Entity entity, String string) {
        String string2 = "xrefsHelper";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, (Object)("Input Parameter=" + entity + " and " + string));
        }
        String string3 = new String();
        int n = 0;
        while (n < entity.getParameterList().size()) {
            if (entity.getParamNameAt(n).startsWith(string) || entity.getParamNameAt(n).equals(string)) {
                string3 = entity.getParamValueAt(n);
                entity.getParameterList().removeElementAt(n);
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return string3;
    }

    private void setIeContainsPortXrefs(Vector vector, Vector vector2) {
        String string;
        block8: {
            string = "setIeContainsPortXrefs";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)("Input Parameter=" + vector + " and " + vector2));
            }
            try {
                int n = 0;
                while (n < vector.size()) {
                    this.iEntity = (Entity)vector.elementAt(n);
                    String string2 = this.iEntity.getUniqueId();
                    String string3 = null;
                    int n2 = 0;
                    while (n2 < vector2.size()) {
                        string3 = this.xrefsHelper((Entity)vector2.elementAt(n2), this.CONNUNITPORTNODEWWN);
                        if (string3.equals("")) {
                            string3 = this.xrefsHelper((Entity)vector2.elementAt(n2), this.CONNUNITPORTUNITID_OLD);
                        }
                        if (string2.equals(string3)) {
                            this.iEntity.addXrefs(this.iEntity.getUniqueId(), ((Entity)vector2.elementAt(n2)).getUniqueId());
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "AdvancedTopologyScanner_setIeContainsPortXrefsFailed");
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                if (traceLogger == null || !traceLogger.isLogging()) break block8;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void setIeIpAddressValue(Vector vector, String string) {
        String string2 = "setIeIpAddressValue";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, (Object)("Input Parameter=" + vector + " and " + string));
        }
        int n = 0;
        while (n < vector.size()) {
            this.iEntity = (Entity)vector.elementAt(n);
            this.iEntity.addParameter("IP Address", string);
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    private String getSubstring(String string) {
        String string2 = "getSubString";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, (Object)("Input Parameter= " + string));
        }
        if (string.length() >= 32 && this.isZeroSubstring(string)) {
            String string3 = string.substring(0, 16);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
            return string3;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return string;
    }

    private boolean isZeroSubstring(String string) {
        String string2 = string.substring(16, string.length());
        boolean bl = true;
        int n = 0;
        while (n < string2.length()) {
            if (string2.charAt(n) != '0') {
                bl = false;
                break;
            }
            bl = true;
            ++n;
        }
        return bl;
    }

    private void resetUniqueId(Vector vector) {
        String string = "resetUniqueId";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Entity's Unique ID Value = " + entity.getUniqueId());
            }
            String string2 = this.getSubstring(entity.getUniqueId());
            entity.setUniqueId(string2);
            Vector vector2 = entity.getParameterList();
            int n2 = 0;
            while (n2 < vector2.size()) {
                Parameter parameter = (Parameter)vector2.elementAt(n2);
                String string3 = parameter.getValue();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Parameter Value = " + string3);
                }
                String string4 = this.getSubstring(string3);
                parameter.setValue(string4);
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private Vector setNodeContainsPortXrefs(Vector vector, Vector vector2) throws Exception {
        String string = "setNodeContainsPortXrefs";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        Vector<Entity> vector3 = new Vector<Entity>();
        int n = 0;
        while (n < vector2.size()) {
            Entity entity = (Entity)vector2.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                Entity entity2 = (Entity)vector.elementAt(n2);
                int n3 = 0;
                while (n3 < entity2.getParameterList().size()) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Node Param= " + entity2.getParamValueAt(n3));
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Port Param= " + entity.getUniqueId());
                    }
                    if (entity2.getParamValueAt(n3).equals(entity.getUniqueId())) {
                        entity2.getParameterList().removeElementAt(n3);
                        entity2.addXrefs(entity2.getUniqueId(), entity.getUniqueId());
                        vector3.addElement(entity2);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return vector3;
    }

    private boolean isEPort(String string) {
        int n = 0;
        while (n < this.ePortList.size()) {
            if (this.ePortList.elementAt(n).equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private Vector removeE_Port(Vector vector, Vector vector2) {
        String string = "removeE_Port";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        Vector<Entity> vector3 = new Vector<Entity>();
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            if (!this.isEPort(entity.getUniqueId())) {
                vector3.addElement(entity);
            }
            ++n;
        }
        if (!vector3.isEmpty() && !vector2.isEmpty()) {
            n = 0;
            while (n < vector3.size()) {
                boolean bl = false;
                Entity entity = (Entity)vector3.elementAt(n);
                int n2 = 0;
                while (n2 < vector2.size()) {
                    Entity entity2 = (Entity)vector2.elementAt(n2);
                    if (entity.getUniqueId().equals(entity2.getUniqueId())) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    vector3.removeElementAt(n);
                }
                ++n;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return vector3;
    }

    private Vector mergeMultiPortNodes(Vector vector) throws Exception {
        String string = "mergeMultiPortNodes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        Vector<Entity> vector2 = new Vector<Entity>();
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            if (vector2.contains(entity)) {
                int n2 = 0;
                while (n2 < vector2.size()) {
                    Entity entity2 = (Entity)vector2.elementAt(n2);
                    if (entity.equals(entity2)) {
                        Hashtable hashtable = entity.getXrefs();
                        Vector vector3 = (Vector)hashtable.get(entity.getUniqueId());
                        int n3 = 0;
                        while (n3 < vector3.size()) {
                            entity2.addXrefs(entity2.getUniqueId(), (String)vector3.elementAt(n3));
                            ++n3;
                        }
                        break;
                    }
                    ++n2;
                }
            } else {
                vector2.addElement(entity);
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return vector2;
    }

    private boolean removedUnidentifiedPorts(Vector vector) {
        String string = "removeUnidentifiedPorts";
        boolean bl = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            Entity entity = (Entity)vector.elementAt(n);
            String string2 = entity.getUniqueId();
            if (string2.equals("0000000000000000") || string2.equals("                ") || string2.equals("")) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Removing unidentified port entity from scan data for target " + this.switchIpAddress + "\n" + entity.toString());
                }
                vector.removeElementAt(n);
                bl = true;
            }
            --n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    private void setPortContainsPortXrefs(Vector vector, Vector vector2) throws Exception {
        String string = "setPortContainsPortXrefs";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector2.size()) {
            Entity entity = (Entity)vector2.elementAt(n);
            String string2 = this.xrefsHelper(entity, this.getOidName(this.CONNUNITLINKPORTNUMBERX));
            int n2 = 0;
            while (n2 < vector.size()) {
                Entity entity2 = (Entity)vector.elementAt(n2);
                int n3 = 0;
                while (n3 < entity2.getParameterList().size()) {
                    if (entity2.getParamNameAt(n3).equals(this.getOidName(this.CONNUNITLINKPORTNUMBERX)) && entity2.getParamValueAt(n3).equals(string2)) {
                        entity2.addXrefs(entity2.getUniqueId(), entity.getUniqueId());
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void setConnUnitType(Vector vector) {
        String string = "setConnUnitType";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                String string2;
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                if (parameter.getName().equals("Type")) {
                    string2 = parameter.getValue();
                    if (string2.equals("1")) {
                        parameter.setValue("Unknown");
                    } else if (string2.equals("2")) {
                        parameter.setValue("Other");
                    } else if (string2.equals("3")) {
                        parameter.setValue("Hub");
                    } else if (string2.equals("4")) {
                        parameter.setValue("Switch");
                    } else if (string2.equals("5")) {
                        parameter.setValue("Gateway");
                    } else if (string2.equals("6")) {
                        parameter.setValue("Converter");
                    } else if (string2.equals("7")) {
                        parameter.setValue("HBA");
                    } else if (string2.equals("8")) {
                        parameter.setValue("Proxy-Agent");
                    } else if (string2.equals("9")) {
                        parameter.setValue("Storage-Device");
                    } else if (string2.equals("10")) {
                        parameter.setValue("Host");
                    } else if (string2.equals("11")) {
                        parameter.setValue("Storage-Subsystem");
                    } else if (string2.equals("12")) {
                        parameter.setValue("Module");
                    } else if (string2.equals("13")) {
                        parameter.setValue("Swdriver");
                    }
                } else if (parameter.getName().equals("Domain")) {
                    string2 = parameter.getValue();
                    int n3 = Integer.parseInt(string2, 16);
                    if (!string2.startsWith("0")) {
                        n3 &= 0x3FF;
                    }
                    parameter.setValue(Integer.toString(n3));
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void setInterconnectElementState(Vector vector) {
        String string = "setInterconnectElementState";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                if (parameter.getName().equals("State")) {
                    String string2 = parameter.getValue();
                    if (string2.equals("1")) {
                        parameter.setValue("Online");
                    } else if (string2.equals("2")) {
                        parameter.setValue("Offline");
                    } else if (string2.equals("3")) {
                        parameter.setValue("Testing");
                    } else if (string2.equals("4")) {
                        parameter.setValue("Faulty");
                    }
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void hardcodeValue(Vector vector, String string, String string2) {
        int n = 0;
        while (n < vector.size()) {
            ((Entity)vector.elementAt(n)).addParameter(string, string2);
            ++n;
        }
    }

    private void setAttachedPortType(Vector vector) {
        String string = "setAttachedPortType";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            String string2;
            Parameter parameter;
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = entity.getParameterList().size() - 1;
            while (n2 >= 0) {
                parameter = (Parameter)entity.getParameterList().elementAt(n2);
                if (parameter.getName().equals("Type") && !(string2 = parameter.getValue()).equals("4") && !string2.equals("3") && !string2.equals("1")) {
                    entity.getParameterList().removeElementAt(n2);
                }
                --n2;
            }
            n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                parameter = (Parameter)entity.getParameterList().elementAt(n2);
                if (parameter.getName().equals("Type")) {
                    string2 = parameter.getValue();
                    if (string2.equals("4")) {
                        parameter.setValue("E_Port");
                        this.ePortList.addElement(entity.getUniqueId());
                    } else if (string2.equals("3")) {
                        parameter.setValue("E_Port");
                        this.ePortList.addElement(entity.getUniqueId());
                    } else if (string2.equals("1")) {
                        parameter.setValue("Unknown");
                    }
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public String getMgmtServerHeader(String string, String string2, String string3) {
        String string4 = "getMgmtServerHeader";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string4);
        }
        String string5 = new String();
        Entity entity = new Entity();
        this.scanId = "OutbandTopologyScanner:" + string3;
        string5 = string5.concat(entity.setDocType("Topology"));
        string5 = string5.concat(entity.setXmlHeader(string, string2, this.scanId, "5.0.0"));
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
        return string5;
    }

    public org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response invoke(String string, String[] stringArray) throws SnmpSocketException, UnknownHostException, Exception, MissingUniqueIdException {
        String string2 = "invoke";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        this.switchIpAddress = stringArray[0];
        String[] stringArray2 = new String[]{this.FCFEFABRICNAME};
        String[] stringArray3 = new String[]{this.FCFABRICNAME_OLD};
        (new String[1])[0] = this.FCFXPORTNXPORTNAME;
        (new String[1])[0] = this.FCFXPORTNXPORTNAME_OLD;
        String[] stringArray4 = new String[]{this.SYSTEMURL_OLD};
        String[] stringArray5 = new String[]{this.CONNUNITGLOBALID_OLD, this.CONNUNITDOMAINID_OLD, this.CONNUNITNAME_OLD, this.CONNUNITTYPE_OLD, this.CONNUNITLOCATION_OLD, this.CONNUNITPRODUCT_OLD, this.CONNURL_OLD, this.CONNUNITSN_OLD};
        String[] stringArray6 = new String[]{this.CONNUNITGLOBALID_OLD, this.CONNUNITDOMAINID_OLD, this.CONNUNITNAME_OLD, this.CONNUNITTYPE_OLD, this.CONNUNITLOCATION_OLD, this.CONNUNITREVSREVID_OLD, this.CONNURL_OLD, this.CONNUNITSN_OLD};
        String[] stringArray7 = new String[]{this.CONNUNITLINKPORTWWNY_OLD, this.CONNUNITLINKUNITTYPEY_OLD, this.CONNUNITLINKPORTNUMBERX_OLD};
        String[] stringArray8 = new String[]{this.CONNUNITPORTWWN_OLD, this.CONNUNITPORTUNITID_OLD, this.CONNUNITPORTTYPE_OLD, this.CONNUNITPORTPHYSICALNUMBER_OLD, this.CONNUNITPORTSTATE_OLD};
        String[] stringArray9 = new String[]{this.CONNUNITLINKNODEIDY_OLD, this.CONNUNITLINKPORTWWNY_OLD};
        String[] stringArray10 = new String[]{this.CONNUNITGLOBALID, this.CONNUNITDOMAINID, this.CONNUNITNAME, this.CONNUNITTYPE, this.CONNUNITLOCATION, this.CONNUNITPRODUCT, this.CONNURL, this.CONNUNITSN};
        String[] stringArray11 = new String[]{this.CONNUNITLINKPORTWWNY, this.CONNUNITLINKUNITTYPEY, this.CONNUNITLINKPORTNUMBERX};
        String[] stringArray12 = new String[]{this.CONNUNITPORTWWN, this.CONNUNITPORTNODEWWN, this.CONNUNITPORTTYPE, this.CONNUNITPORTPHYSICALNUMBER, this.CONNUNITPORTSTATE};
        String[] stringArray13 = new String[]{this.CONNUNITLINKNODEIDY, this.CONNUNITLINKPORTWWNY};
        String[] stringArray14 = new String[]{this.FCFEELEMENTNAME, this.SYSDESCR, this.SYSOBJECTID, this.SYSCONTACT, this.SYSLOCATION, this.SYSNAME, this.FCFEMODULEOPERSTATUS};
        String[] stringArray15 = new String[]{this.FCELEMENTNAME_OLD, this.SYSDESCR, this.SYSOBJECTID, this.SYSCONTACT, this.SYSLOCATION, this.SYSNAME, this.FCFEMODULEOPERSTATUS_OLD};
        boolean bl = true;
        boolean bl2 = false;
        if (this.isBrocadeSwitch(this.switchIpAddress) == 1) {
            stringArray5 = stringArray6;
        }
        InetAddress inetAddress = InetAddress.getByName(this.switchIpAddress);
        String string3 = inetAddress.getHostAddress();
        this.result = this.getMgmtServerHeader(this.switchIpAddress, string, string3);
        this.setScanType(1);
        this.sanList = this.runProcess(this.switchIpAddress, stringArray2);
        if (this.sanList.isEmpty()) {
            bl2 = true;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "The target device " + this.switchIpAddress + " supports old FE MIB");
            }
            this.sanList = this.runProcess(this.switchIpAddress, stringArray3);
        }
        if (this.sanList.isEmpty()) {
            bl = false;
            this.sanList = this.getSANNameFromFCMgmtMIB(this.switchIpAddress);
        }
        if (this.sanList.isEmpty()) {
            throw new MissingUniqueIdException();
        }
        this.sysURL = this.runProcess(this.switchIpAddress, stringArray4);
        this.ieList = this.runProcess(this.switchIpAddress, stringArray10);
        if (!this.ieList.isEmpty()) {
            if (bl) {
                this.icList = bl2 ? this.runProcess(this.switchIpAddress, stringArray15) : this.runProcess(this.switchIpAddress, stringArray14);
            }
            this.portList = this.runProcess(this.switchIpAddress, stringArray12);
            this.atpList = this.runProcess(this.switchIpAddress, stringArray11);
            this.nodeList = this.runProcess(this.switchIpAddress, stringArray13);
        } else {
            this.ieList = this.runProcess(this.switchIpAddress, stringArray5);
            if (bl) {
                this.icList = bl2 ? this.runProcess(this.switchIpAddress, stringArray15) : this.runProcess(this.switchIpAddress, stringArray14);
            }
            this.portList = this.runProcess(this.switchIpAddress, stringArray8);
            this.atpList = this.runProcess(this.switchIpAddress, stringArray7);
            this.nodeList = this.runProcess(this.switchIpAddress, stringArray9);
        }
        if (this.ieList.size() > 0) {
            int n = 0;
            while (n < this.icList.size()) {
                Entity entity = (Entity)this.icList.elementAt(n);
                Vector vector = entity.getParameterList();
                Entity entity2 = (Entity)this.ieList.elementAt(n);
                int n2 = 0;
                while (n2 < vector.size()) {
                    boolean bl3 = false;
                    Parameter parameter = (Parameter)vector.elementAt(n2);
                    String string4 = parameter.getName();
                    Vector vector2 = entity2.getParameterList();
                    int n3 = 0;
                    while (n3 < vector2.size()) {
                        Parameter parameter2 = (Parameter)vector2.elementAt(n3);
                        if (string4.equals(parameter2.getName())) {
                            bl3 = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!bl3) {
                        entity2.addParameter(parameter.getName(), parameter.getValue());
                    }
                    ++n2;
                }
                ++n;
            }
        } else {
            this.ieList = this.icList;
        }
        this.setIeIpAddressValue(this.ieList, string3);
        if (this.isZeroSAN(this.sanList) || this.isZeroSAN(this.ieList)) {
            this.result = this.result.concat(this.iEntity.endResultXml("Topology"));
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "found Zero SAN");
            }
        } else {
            this.result.concat(this.topologyXmlGenerator());
        }
        new Vector();
        this.sanList = null;
        this.sysURL = null;
        this.ieList = null;
        this.icList = null;
        this.portList = null;
        this.atpList = null;
        this.nodeList = null;
        this.sanPortList = null;
        this.attachedPort_NxType = null;
        org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response response = this.processXMLDeltaScan(this.scanId, this.result, Response.RETURN_CODE_OK, "MibQueryEngine");
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return response;
    }

    public Vector getSANNameFromFCMgmtMIB(String string) throws SnmpSocketException, UnknownHostException, Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Vector vector;
        String string2;
        block37: {
            string2 = "getSANNameFromFCMgmtMIB";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
            }
            vector = new Vector();
            String[] stringArray = new String[]{this.CONNUNITFABRICID};
            vector = this.runProcess(string, stringArray);
            if (vector.isEmpty()) {
                Entity entity;
                String string3;
                Object object5;
                Object object6;
                Entity entity2;
                Object object7;
                String[] stringArray2;
                String[] stringArray3;
                object4 = new Vector();
                object3 = new Vector();
                object2 = new Vector();
                object = new String[]{this.CONNUNITPRINCIPAL};
                String[] stringArray4 = new String[]{this.CONNUNITGLOBALID};
                String[] stringArray5 = new String[]{this.CONNUNITLINKUNITTYPEY};
                String[] stringArray6 = new String[]{this.CONNUNITLINKAGENTADDRESSY};
                object4 = this.runProcess(string, (String[])object);
                if (!((Vector)object4).isEmpty()) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Getting the SAN Name from the temp FC Mgmt MIB");
                    }
                    if ((stringArray3 = (stringArray2 = (String[])((Vector)object4).elementAt(0)).getParamValueAt(0)).equals("3")) {
                        vector = this.runProcess(string, stringArray4);
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "This is the principal switch so we are getting the SAN Name from " + string);
                        }
                    } else {
                        object3 = this.runProcess(string, stringArray5);
                        this.setConnUnitType((Vector)object3);
                        object2 = this.runProcess(string, stringArray6);
                        int n = 0;
                        object7 = ((Vector)object3).elements();
                        while (object7.hasMoreElements()) {
                            entity2 = (Entity)object7.nextElement();
                            if (entity2.getParamValueAt(0).equals("Switch")) {
                                object6 = (Entity)((Vector)object2).elementAt(n);
                                String string4 = TopologyScanner.convertHexStringToAscii(((Entity)object6).getParamValueAt(0));
                                boolean bl = true;
                                try {
                                    object5 = InetAddress.getByName(string4);
                                    string4 = ((InetAddress)object5).getHostAddress();
                                }
                                catch (Exception exception) {
                                    bl = false;
                                }
                                if (bl && (string3 = (entity = (Entity)((Vector)(object5 = this.runProcess(string4, (String[])object))).elementAt(0)).getParamValueAt(0)).equals("3")) {
                                    vector = this.runProcess(string4, stringArray4);
                                    if (traceLogger != null && traceLogger.isLogging()) {
                                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "This is not the principal switch so we are getting the SAN Name from " + string4);
                                    }
                                    break;
                                }
                            }
                            ++n;
                        }
                    }
                } else {
                    stringArray2 = new String[]{this.CONNUNITPRINCIPAL_OLD};
                    stringArray3 = new String[]{this.CONNUNITGLOBALID_OLD};
                    String[] stringArray7 = new String[]{this.CONNUNITLINKUNITTYPEY_OLD};
                    object7 = new String[]{this.CONNUNITLINKAGENTADDRESSY_OLD};
                    object4 = this.runProcess(string, stringArray2);
                    if (!((Vector)object4).isEmpty()) {
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Getting the SAN Name from the old FC Mgmt MIB");
                        }
                        if (((String)(object6 = (entity2 = (Entity)((Vector)object4).elementAt(0)).getParamValueAt(0))).equals("3")) {
                            vector = this.runProcess(string, stringArray3);
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "This is the principal switch so we are getting the SAN Name from " + string);
                            }
                        } else {
                            object3 = this.runProcess(string, stringArray7);
                            this.setConnUnitType((Vector)object3);
                            object2 = this.runProcess(string, (String[])object7);
                            int n = 0;
                            Enumeration enumeration = ((Vector)object3).elements();
                            while (enumeration.hasMoreElements()) {
                                object5 = (Entity)enumeration.nextElement();
                                if (((Entity)object5).getParamValueAt(0).equals("Switch")) {
                                    Entity entity3;
                                    String string5;
                                    Serializable serializable;
                                    entity = (Entity)((Vector)object2).elementAt(n);
                                    string3 = entity.getParamValueAt(0);
                                    if (!this.isIPAddr(string3)) {
                                        string3 = TopologyScanner.convertHexStringToAscii(string3);
                                    }
                                    boolean bl = true;
                                    try {
                                        serializable = InetAddress.getByName(string3);
                                        string3 = ((InetAddress)serializable).getHostAddress();
                                    }
                                    catch (Exception exception) {
                                        bl = false;
                                    }
                                    if (bl && (string5 = (entity3 = (Entity)((Vector)(serializable = this.runProcess(string3, stringArray2))).elementAt(0)).getParamValueAt(0)).equals("3")) {
                                        vector = this.runProcess(string3, stringArray3);
                                        if (traceLogger != null && traceLogger.isLogging()) {
                                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "This is not the principal switch so we are getting the SAN Name from " + string3);
                                        }
                                        break;
                                    }
                                }
                                ++n;
                            }
                        }
                    }
                }
            } else if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "The target device supports FC Mgmt MIB 4");
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Getting the SAN Name from the FC Mgmt MIB 4");
            }
            if (vector.isEmpty()) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "We must use the IP address of the switch for the SAN Name.");
                }
                object4 = string;
                try {
                    object3 = new Entity("San", ((String)object4).toUpperCase());
                    ((Entity)object3).addParameter("Name", ((String)object4).toUpperCase());
                    vector.addElement(object3);
                }
                catch (Exception exception) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string2, "Scanner_unableToCreateEntityException");
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string2, (Throwable)exception);
                    if (traceLogger == null || !traceLogger.isLogging()) break block37;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
                }
            }
        }
        object4 = vector.elements();
        while (object4.hasMoreElements()) {
            object3 = (Entity)object4.nextElement();
            if ("InterconnectElement".equals(((Entity)object3).getName())) {
                ((Entity)object3).setName("San");
            }
            object2 = ((Entity)object3).getParameterList().elements();
            while (object2.hasMoreElements()) {
                object = (Parameter)object2.nextElement();
                if (!"WWN".equals(((Parameter)object).getName())) continue;
                ((Parameter)object).setName("Name");
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return vector;
    }

    public static String convertHexStringToAscii(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        String string3 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '0') break;
            string3 = string.substring(n, n + 2);
            String string4 = "0x";
            string4 = string4.concat(string3);
            Integer n2 = Integer.decode(string4);
            char c2 = (char)n2.intValue();
            string2 = string2.concat(String.valueOf(c2));
            ++n;
            ++n;
        }
        return string2;
    }

    public String topologyXmlGenerator() {
        String string;
        block6: {
            string = "topologyXmlGenerator: targetIP=" + this.switchIpAddress;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
            }
            try {
                this.resetUniqueId(this.sanList);
                this.resetUniqueId(this.nodeList);
                this.resetUniqueId(this.ieList);
                this.resetUniqueId(this.portList);
                this.resetUniqueId(this.atpList);
                boolean bl = this.removedUnidentifiedPorts(this.portList);
                boolean bl2 = this.removedUnidentifiedPorts(this.atpList);
                boolean bl3 = this.removedUnidentifiedPorts(this.sanPortList);
                if (bl2 || bl || bl3) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "AdvancedTopologyScanner_unidentifiedPortRemoved");
                }
                this.setIeContainsPortXrefs(this.ieList, this.portList);
                this.setPortContainsPortXrefs(this.portList, this.atpList);
                this.hardcodeValue(this.sanList, "Type", "Fabric");
                this.setConnUnitType(this.ieList);
                this.setInterconnectElementState(this.ieList);
                this.setPortTypeValue(this.portList);
                this.setAttachedPortType(this.atpList);
                this.attachedPort_NxType = this.removeE_Port(this.atpList, this.sanPortList);
                Vector vector = this.setNodeContainsPortXrefs(this.nodeList, this.attachedPort_NxType);
                Vector vector2 = this.mergeMultiPortNodes(vector);
                int n = 0;
                while (n < this.sanList.size()) {
                    this.iEntity = (Entity)this.sanList.elementAt(n);
                    this.result = this.result.concat(this.iEntity.toXml());
                    this.result = !this.sanPortList.isEmpty() ? this.result.concat(this.iEntity.toIdXml(new Vector[]{this.ieList, this.sanPortList})) : this.result.concat(this.iEntity.toIdXml(new Vector[]{this.ieList, this.attachedPort_NxType}));
                    ++n;
                }
                this.result = this.result.concat(this.iEntity.composeXml(new Vector[]{this.ieList, this.portList, this.atpList, vector2}));
                this.result = this.result.concat(this.iEntity.endResultXml("Topology"));
            }
            catch (Exception exception) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "AdvancedTopolgyScanner_TopolgoyXmlGeneratorError");
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                if (traceLogger == null || !traceLogger.isLogging()) break block6;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return this.result;
    }

    private boolean isZeroSAN(Vector vector) {
        String string = "isZeroSAN";
        String string2 = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            string2 = entity.getUniqueId();
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Entity's Unique ID Value = " + string2);
            }
            if (string2.equals("0000000000000000") || string2.equals("                ") || string2.equals("")) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
                }
                return true;
            }
            Vector vector2 = entity.getParameterList();
            int n2 = 0;
            while (n2 < vector2.size()) {
                Parameter parameter = (Parameter)vector2.elementAt(n2);
                if (parameter.getName().equals("WWN") && ((string2 = parameter.getValue()).equals("0000000000000000") || string2.equals("                ") || string2.equals(""))) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
                    }
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return false;
    }

    private Vector runProcess(String string, String[] stringArray) throws SnmpSocketException, UnknownHostException, Exception {
        String string2 = "runProcess";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        Vector vector = new Vector();
        boolean bl = false;
        int n = this.queryRetryCount + 1;
        int n2 = 0;
        while (n2 < n) {
            vector = this.runSnmpQuery(string, stringArray);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "--------> AdvTop:: runProcess: " + string + " counter =" + n2);
            }
            if (!this.ERROR_FLAG) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            throw new Exception("Unable to contact the host " + string + " after " + n + " attempts!");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return vector;
    }

    public String getScannerHeader(String string, String string2) {
        String string3 = null;
        String string4 = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            string3 = inetAddress.getHostAddress();
            string4 = this.getMgmtServerHeader(string2, string, string3);
            string4 = string4.concat("</TopologyXml>");
        }
        catch (Exception exception) {}
        return string4;
    }

    private boolean isIPAddr(String string) {
        try {
            InetAddress.getByName(string);
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response getScannerHeaderResponse(int n, String string, String string2) {
        InetAddress inetAddress;
        String string3 = null;
        String string4 = null;
        try {
            inetAddress = InetAddress.getByName(string2);
            string3 = inetAddress.getHostAddress();
            string4 = this.getMgmtServerHeader(string2, string, string3);
            string4 = string4.concat("</TopologyXml>");
        }
        catch (Exception exception) {}
        inetAddress = this.processXMLDeltaScan(this.scanId, string4, n, "MibQueryEngine");
        return inetAddress;
    }
}

