/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric.discovery;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.fabric.FabricMsgConsts;
import org.eclipse.aperi.fabric.api.DeviceAgent;
import org.eclipse.aperi.fabric.api.FabricManagerConstants;
import org.eclipse.aperi.fabric.api.FabricScanner;
import org.eclipse.aperi.fabric.api.SNMPAgent;
import org.eclipse.aperi.fabric.discovery.Discover;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.IpTarget;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

class ProbeFabricAgents
extends DiscoverProcess {
    static final String className;
    private static ILogger msgLogger;
    private static ILogger traceLogger;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.fabric.discovery.ProbeFabricAgents");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        msgLogger = null;
        traceLogger = null;
        msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.FabricManager");
        traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.FabricManager");
        msgLogger.setMessageFile(FabricManagerConstants.MSG_FILE);
    }

    public ProbeFabricAgents() {
        Class<?> clazz;
        Class<?> clazz2;
        String[] stringArray = new String[2];
        try {
            clazz2 = Class.forName("java.util.ArrayList");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[0] = clazz2.getName();
        try {
            clazz = Class.forName("java.util.ArrayList");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[1] = clazz.getName();
        super("Probe Fabric Agents", false, new String[]{"AGENTS", "AGENT_TYPES"}, stringArray);
    }

    public Result process(Request request, Map map) throws ParameterException {
        Object object;
        FabricScanner[] fabricScannerArray;
        block40: {
            Class<?> clazz;
            Class<?> clazz2;
            String string = "process";
            Object[] objectArray = new String[2];
            try {
                clazz2 = Class.forName("java.util.ArrayList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            ArrayList arrayList = (ArrayList)ProbeFabricAgents.getParameter((Map)map, (String)"AGENTS", (String)clazz2.getName());
            try {
                clazz = Class.forName("java.util.ArrayList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            ArrayList arrayList2 = (ArrayList)ProbeFabricAgents.getParameter((Map)map, (String)"AGENT_TYPES", (String)clazz.getName());
            if (arrayList2.isEmpty()) {
                arrayList2.add(new Integer(FabricManagerConstants.SNMPType));
                arrayList2.add(new Integer(FabricManagerConstants.deviceServerType));
                arrayList2.add(new Integer(FabricManagerConstants.CIMType));
            }
            fabricScannerArray = arrayList2.iterator();
            while (fabricScannerArray.hasNext()) {
                Object object2;
                Object[] objectArray2;
                int n = (Integer)fabricScannerArray.next();
                if (n == FabricManagerConstants.SNMPType) {
                    object = this.getSNMPAgents();
                    if (object == null) continue;
                    int n2 = 0;
                    while (n2 < ((SNMPAgent[])object).length) {
                        if (arrayList.isEmpty() || arrayList.contains(object[n2].getIpAddress())) {
                            block38: {
                                objectArray2 = null;
                                try {
                                    objectArray2 = this.getScannersForAgent(object[n2].getIpAddress());
                                }
                                catch (Exception exception) {
                                    objectArray[0] = "SNMP scanner";
                                    objectArray[1] = object[n2].getIpAddress();
                                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.SCANNER_NOT_FOUND, objectArray);
                                    if (!traceLogger.isLogging()) break block38;
                                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Error during discover Fabrics getting the Scanners for outband agent with ID = " + object[n2].getIpAddress() + ".");
                                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
                                }
                            }
                            int n3 = 0;
                            while (n3 < objectArray2.length) {
                                if (objectArray2[n3].getEnabled() != 0) {
                                    if (objectArray2[n3].getType().equals("PO2") || objectArray2[n3].getType().equals("PO4")) {
                                        object2 = new Hashtable();
                                        ((Hashtable)object2).put("IPADDRESS", new String[]{object[n2].getIpAddress(), object[n2].getUserName(), object[n2].getPassword()});
                                        ((Hashtable)object2).put("SCANNER", objectArray2[n3].getType());
                                        Router.getRouter().perform(Discover.discoverViaSNMP, (Map)object2, new Integer(request.getId()).toString());
                                    }
                                } else if (objectArray2[n3].getInactiveProcessed() == 0) {
                                    object2 = new Hashtable();
                                    ((Hashtable)object2).put("IPADDRESS", new String[]{object[n2].getIpAddress()});
                                    ((Hashtable)object2).put("SCANNER", objectArray2[n3].getType());
                                    Router.getRouter().perform(Discover.ProcessMissingSNMPAgent, (Map)object2, new Integer(request.getId()).toString());
                                }
                                ++n3;
                            }
                        }
                        ++n2;
                    }
                    continue;
                }
                if (n == FabricManagerConstants.deviceServerType) {
                    try {
                        object = this.getDeviceServerAgents();
                        if (object == null) continue;
                        int n4 = 0;
                        while (n4 < ((Object)object).length) {
                            if (arrayList.isEmpty() || arrayList.contains(object[n4].getUrl()) || arrayList.contains(object[n4].getIpAddress()) || arrayList.contains(object[n4].getGuid())) {
                                block39: {
                                    objectArray2 = null;
                                    try {
                                        objectArray2 = this.getScannersForAgent(object[n4].getGuid());
                                    }
                                    catch (Exception exception) {
                                        objectArray[0] = "Inband Scanner";
                                        objectArray[1] = object[n4].getGuid();
                                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.SCANNER_NOT_FOUND, objectArray);
                                        if (!traceLogger.isLogging()) break block39;
                                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Error during discover Fabrics getting the Scanners for inband agent with ID = " + object[n4].getGuid() + ".");
                                        traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
                                    }
                                }
                                int n5 = 0;
                                while (n5 < objectArray2.length) {
                                    object2 = new Hashtable();
                                    ((Hashtable)object2).put("AGENT", new String[]{String.valueOf(object[n4].getIpAddress()) + ":" + object[n4].getPort(), object[n4].getVersion(), object[n4].getHostId()});
                                    if (objectArray2[n5].getType().equals("PI1")) {
                                        ((Hashtable)object2).put("SCANNER", "Topology");
                                    } else if (objectArray2[n5].getType().equals("PI2")) {
                                        ((Hashtable)object2).put("SCANNER", "AttributePEOnly");
                                    }
                                    if (objectArray2[n5].getEnabled() != 0 && object[n4].getStatus().trim().equals("AC")) {
                                        Router.getRouter().perform(Discover.discoverViaInband, (Map)object2, new Integer(request.getId()).toString());
                                    } else if (objectArray2[n5].getInactiveProcessed() == 0) {
                                        Router.getRouter().perform(Discover.ProcessMissingInbandAgent, (Map)object2, new Integer(request.getId()).toString());
                                    }
                                    ++n5;
                                }
                            }
                            ++n4;
                        }
                    }
                    catch (Exception exception) {
                        objectArray[0] = "DiscoverFabrics";
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.OPERATION_FAILED, objectArray);
                        if (!traceLogger.isLogging()) continue;
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Error during discover Fabrics getting the Device Agents.");
                        traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
                    }
                    continue;
                }
                if (n != FabricManagerConstants.CIMType) continue;
                try {
                    object = this.getSwitchCIMOMs();
                    if (object == null) continue;
                    Iterator iterator = ((ArrayList)object).iterator();
                    while (iterator.hasNext()) {
                        objectArray2 = (String[])iterator.next();
                        Hashtable<String, FabricScanner[]> hashtable = new Hashtable<String, FabricScanner[]>();
                        if (!arrayList.isEmpty() && !arrayList.contains(objectArray2[0])) continue;
                        hashtable.put("CIMOM", (FabricScanner[])objectArray2);
                        object2 = Router.getRouter().perform(Discover.discoverCimomMetadata, hashtable, new Integer(request.getId()).toString());
                        Router.getRouter().waitTilComplete((String[])object2);
                        Router.getRouter().perform(Discover.discoverFabricViaSMIS, hashtable, new Integer(request.getId()).toString());
                    }
                }
                catch (Exception exception) {
                    objectArray[0] = "DiscoverFabrics";
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.OPERATION_FAILED, objectArray);
                    if (!traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Error during discover Fabrics getting the CIMOMs.");
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
                }
            }
            fabricScannerArray = null;
            try {
                fabricScannerArray = this.getScannersWithoutAgent();
            }
            catch (Exception exception) {
                objectArray[0] = "null agent";
                objectArray[1] = "";
                msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.SCANNER_NOT_FOUND, objectArray);
                if (!traceLogger.isLogging()) break block40;
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Error during probe Fabric Agents getting the Scanners without an outband agent");
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
            }
        }
        if (fabricScannerArray != null) {
            int n = 0;
            while (n < fabricScannerArray.length) {
                if (fabricScannerArray[n].getInactiveProcessed() == 0) {
                    object = new Hashtable();
                    ((Hashtable)object).put("IPADDRESS", new String[]{fabricScannerArray[n].getAgentName()});
                    ((Hashtable)object).put("SCANNER", fabricScannerArray[n].getType());
                    Router.getRouter().perform(Discover.ProcessMissingSNMPAgent, (Map)object, new Integer(request.getId()).toString());
                }
                ++n;
            }
        }
        return new Result(0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SNMPAgent[] getSNMPAgents() throws ServerException {
        block15: {
            var1_1 = "getSNMPAgents";
            var2_2 = new ArrayList<SNMPAgent>();
            var3_3 = ServiceUtils.getConnection();
            var4_4 = null;
            try {
                try {
                    var4_4 = IpTarget.getCursor((DBConnection)var3_3, null, null);
                    while (true) {
                        block16: {
                            if (var4_4.next()) break block16;
                            var3_3.commit();
                            break;
                        }
                        var5_5 = var4_4.getObject();
                        var2_2.add(new SNMPAgent(var5_5.getIpAddress(), var5_5.getHostName(), var5_5.getReadCommunityName(), var5_5.getUserId(), var5_5.getPassword()));
                    }
                }
                catch (Exception var5_6) {
                    if (ProbeFabricAgents.traceLogger.isLogging()) {
                        ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)ProbeFabricAgents.className, var1_1, (Throwable)var5_6);
                    }
                    var6_7 = new String[]{var1_1};
                    throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, var6_7));
                }
            }
            catch (Throwable var8_8) {
                block14: {
                    var7_9 = null;
                    if (var4_4 != null) {
                        try {
                            var4_4.close();
                        }
                        catch (Exception var9_11) {
                            if (!ProbeFabricAgents.traceLogger.isLogging()) break block14;
                            ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)ProbeFabricAgents.className, var1_1, (Throwable)var9_11);
                        }
                    }
                }
                if (var3_3 == null) throw var8_8;
                try {
                    var3_3.close();
                    throw var8_8;
                }
                catch (Exception var9_11) {
                    if (ProbeFabricAgents.traceLogger.isLogging() == false) throw var8_8;
                    ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)ProbeFabricAgents.className, var1_1, (Throwable)var9_11);
                }
                throw var8_8;
            }
            {
                var7_10 = null;
                if (var4_4 == null) break block15;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 164->172)] { 
lbl44:
            // 1 sources

            var4_4.close();
            break block15;
lbl46:
            // 1 sources

            catch (Exception var9_12) {
                if (!ProbeFabricAgents.traceLogger.isLogging()) break block15;
                ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)ProbeFabricAgents.className, var1_1, (Throwable)var9_12);
            }
        }
        if (var3_3 == null) return var2_2.toArray(new SNMPAgent[0]);
        try {}
        catch (Exception var9_12) {
            if (ProbeFabricAgents.traceLogger.isLogging() == false) return var2_2.toArray(new SNMPAgent[0]);
            ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)ProbeFabricAgents.className, var1_1, (Throwable)var9_12);
            return var2_2.toArray(new SNMPAgent[0]);
        }
        var3_3.close();
        return var2_2.toArray(new SNMPAgent[0]);
    }

    public DeviceAgent[] getDeviceServerAgents() throws ServerException {
        String string = "getDeviceServerAgents";
        Object[] objectArray = new String[2];
        DeviceAgent[] deviceAgentArray = null;
        try {
            deviceAgentArray = FabricDbAccess.getDeviceAgents();
            if (deviceAgentArray == null) {
                deviceAgentArray = new DeviceAgent[]{};
            }
        }
        catch (Exception exception) {
            objectArray[0] = "dbAccessor.getDeviceAgents";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.OPERATION_FAILED, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Error getting Device Server agents.");
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])objectArray));
        }
        return deviceAgentArray;
    }

    public FabricScanner[] getScannersForAgent(String string) throws ServerException {
        String string2 = "getScannersForAgent";
        Object[] objectArray = new String[2];
        FabricScanner[] fabricScannerArray = null;
        try {
            fabricScannerArray = FabricDbAccess.getScannersForAgent((String)string);
            if (fabricScannerArray == null) {
                fabricScannerArray = new FabricScanner[]{};
            }
        }
        catch (Exception exception) {
            objectArray[0] = "getScannersForAgent";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.OPERATION_FAILED, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string2, "Error getting Scanners for Agent with id = " + string + ".");
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string2, (Throwable)exception);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])objectArray));
        }
        return fabricScannerArray;
    }

    public FabricScanner[] getScannersWithoutAgent() throws ServerException {
        String string = "getScannersWithoutAgent";
        Object[] objectArray = new String[2];
        FabricScanner[] fabricScannerArray = null;
        try {
            fabricScannerArray = FabricDbAccess.getScannersWithoutAgent();
            if (fabricScannerArray == null) {
                fabricScannerArray = new FabricScanner[]{};
            }
        }
        catch (Exception exception) {
            objectArray[0] = "getScannersForAgent";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.OPERATION_FAILED, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Error getting Scanners without Agent.");
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])objectArray));
        }
        return fabricScannerArray;
    }

    /*
     * Exception decompiling
     */
    public ArrayList getSwitchCIMOMs() throws ServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [4 : 488->494)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

