/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import java.util.ArrayList;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.aggregation.Finance;
import org.eclipse.birt.data.engine.aggregation.SummaryAccumulator;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalMirr
implements IAggregation {
    static /* synthetic */ Class class$org$eclipse$birt$data$engine$aggregation$TotalMirr;

    public String getName() {
        return "MIRR";
    }

    public int getType() {
        return 0;
    }

    public boolean[] getParameterDefn() {
        return new boolean[]{true, false, false};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    private class MyAccumulator
    extends SummaryAccumulator {
        private ArrayList list;
        private double frate = 0.0;
        private double rrate = 0.0;
        private Double ret = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        private MyAccumulator() {
        }

        public void start() {
            super.start();
            this.frate = 0.0;
            this.rrate = 0.0;
            this.list = new ArrayList();
            this.ret = null;
        }

        public void onRow(Object[] args) throws DataException {
            if (!$assertionsDisabled && args.length <= 2) {
                throw new AssertionError();
            }
            if (args[0] != null && args[1] != null && args[2] != null) {
                try {
                    double value = DataTypeUtil.toDouble((Object)args[0]);
                    if (this.list.size() == 0) {
                        this.frate = DataTypeUtil.toDouble((Object)args[1]);
                        this.rrate = DataTypeUtil.toDouble((Object)args[2]);
                    }
                    this.list.add(new Double(value));
                }
                catch (BirtException e) {
                    throw new DataException("data.engine.DataConversionError", e);
                }
            }
        }

        public void finish() throws DataException {
            if (this.list.size() > 0) {
                double[] values = new double[this.list.size()];
                for (int i = 0; i < this.list.size(); ++i) {
                    values[i] = (Double)this.list.get(i);
                }
                this.ret = new Double(Finance.mirr(values, this.frate, this.rrate));
            }
            super.finish();
        }

        public Object getSummaryValue() {
            return this.ret;
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$aggregation$TotalMirr == null ? (class$org$eclipse$birt$data$engine$aggregation$TotalMirr = TotalMirr.class$("org.eclipse.birt.data.engine.aggregation.TotalMirr")) : class$org$eclipse$birt$data$engine$aggregation$TotalMirr).desiredAssertionStatus();
        }
    }
}

