/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.group.GroupByDistinctValue;
import org.eclipse.birt.data.engine.executor.transform.group.GroupByNumberRange;
import org.eclipse.birt.data.engine.executor.transform.group.GroupByPositionRange;
import org.eclipse.birt.data.engine.executor.transform.group.GroupByStringRange;
import org.eclipse.birt.data.engine.odi.IQuery;

public abstract class GroupBy {
    private int columnIndex;
    private String columnName;
    private IQuery.GroupSpec groupSpec;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static GroupBy newInstance(IQuery.GroupSpec groupDefn, int columnIndex, String columnName, Class columnType) throws DataException {
        if (!$assertionsDisabled && groupDefn == null) {
            throw new AssertionError();
        }
        GroupBy groupBy = null;
        switch (groupDefn.getInterval()) {
            case 0: {
                groupBy = new GroupByDistinctValue();
                break;
            }
            case 100: {
                if (GroupBy.isString(columnType)) {
                    groupBy = new GroupByStringRange(groupDefn);
                    break;
                }
                throw new DataException("data.engine.group.interval", new Object[]{"string prefix", columnType.getName()});
            }
            default: {
                groupBy = groupDefn.getIntervalRange() == 0.0 ? new GroupByDistinctValue() : new GroupByNumberRange(groupDefn);
            }
        }
        groupBy.groupSpec = groupDefn;
        groupBy.columnIndex = columnIndex;
        groupBy.columnName = columnName;
        return groupBy;
    }

    public static GroupBy newInstanceForRowID(IQuery.GroupSpec groupDefn) throws DataException {
        if (!$assertionsDisabled && groupDefn == null) {
            throw new AssertionError();
        }
        GroupBy groupBy = null;
        switch (groupDefn.getInterval()) {
            case 0: {
                groupBy = new GroupByDistinctValue();
                break;
            }
            case 99: {
                groupBy = new GroupByPositionRange(groupDefn);
                break;
            }
            default: {
                throw new DataException("data.engine.group.interval.Rowid");
            }
        }
        groupBy.groupSpec = groupDefn;
        groupBy.columnIndex = -1;
        return groupBy;
    }

    boolean isInSameGroup(Object currentGroupKey, Object previousGroupKey, Object groupStartValue, int currRowPos) throws DataException {
        return this.isInSameGroup(currentGroupKey, previousGroupKey);
    }

    boolean isInSameGroup(Object currentGroupKey, Object previousGroupKey) throws DataException {
        if (previousGroupKey == currentGroupKey) {
            return true;
        }
        if (previousGroupKey == null || currentGroupKey == null) {
            return false;
        }
        return this.isSameGroup(currentGroupKey, previousGroupKey);
    }

    abstract boolean isSameGroup(Object var1, Object var2) throws DataException;

    boolean needsGroupStartValue() {
        return false;
    }

    int getColumnIndex() {
        return this.columnIndex;
    }

    String getColumnName() {
        return this.columnName;
    }

    IQuery.GroupSpec getGroupSpec() {
        return this.groupSpec;
    }

    private static boolean isString(Class columnType) {
        return String.class.isAssignableFrom(columnType);
    }

    static {
        $assertionsDisabled = !GroupBy.class.desiredAssertionStatus();
    }
}

