/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.cache.CachedList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.FilterUtil;
import org.eclipse.birt.data.engine.executor.transform.OrderingInfo;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBoundaryInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupProcessorManager;
import org.eclipse.birt.data.engine.script.FilterPassController;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;

class GroupInstanceFilter {
    private ResultSetPopulator populator;
    private FilterPassController filterPass = new FilterPassController();
    private GroupProcessorManager groupProcessor;

    GroupInstanceFilter(GroupProcessorManager gp) {
        this.populator = gp.getResultSetPopulator();
        this.groupProcessor = gp;
    }

    public void doGroupFiltering(Context cx) throws DataException {
        ArrayList groupLevels = new ArrayList();
        ArrayList expressionList = new ArrayList();
        this.populateGroupFilteringExpressions(expressionList, groupLevels);
        if (expressionList.size() > 0) {
            this.groupProcessor.calculateExpressionList(expressionList, groupLevels, 3);
            List[] groupBoundaryInfos = this.groupProcessor.getGroupCalculationUtil().getGroupInformationUtil().getGroupBoundaryInfos();
            this.populateFiltersInGroupBoundaryInfoSets(cx, groupBoundaryInfos);
            groupBoundaryInfos = this.groupProcessor.getGroupCalculationUtil().filterGroupBoundaryInfos(groupBoundaryInfos);
            OrderingInfo odInfo = this.groupProcessor.getGroupCalculationUtil().getGroupInformationUtil().getOrderingInfo(groupBoundaryInfos);
            this.populator.reSetSmartCacheUsingOrderingInfo(odInfo);
        }
    }

    private void populateGroupFilteringExpressions(List expressionList, List groupLevels) {
        for (int i = 0; i < this.populator.getQuery().getGrouping().length; ++i) {
            List groupFilters = this.populator.getQuery().getGrouping()[i].getFilters();
            String name = this.populator.getQuery().getGrouping()[i].getName();
            if (groupFilters == null) continue;
            for (int j = 0; j < groupFilters.size(); ++j) {
                IBaseExpression expr = ((IFilterDefinition)groupFilters.get(j)).getExpression();
                expr.setGroupName(name);
                expressionList.add(expr);
                groupLevels.add(new Integer(i + 1));
            }
        }
    }

    private void populateFiltersInGroupBoundaryInfoSets(Context cx, List[] groupBoundaryInfos) throws DataException {
        for (int i = 1; i <= this.populator.getQuery().getGrouping().length; ++i) {
            List filters = this.populator.getQuery().getGrouping()[i - 1].getFilters();
            if (filters == null || filters.size() == 0) continue;
            this.populator.getResultIterator().first(0);
            if (FilterUtil.hasMutipassFilters(filters)) {
                this.populateGroupBoundaryInfoFilterValues(cx, groupBoundaryInfos, i, filters);
            } else {
                this.populateGroupBoundaryInfoFilters(cx, groupBoundaryInfos[i - 1], filters, i, true);
            }
            groupBoundaryInfos = this.groupProcessor.getGroupCalculationUtil().filterGroupBoundaryInfos(groupBoundaryInfos);
            for (int j = 0; j < filters.size(); ++j) {
                IFilterDefinition fd = (IFilterDefinition)filters.get(j);
                if (!FilterUtil.isFilterNeedMultiPass(fd)) continue;
                fd.getExpression().setHandle(null);
            }
        }
    }

    private void populateGroupBoundaryInfoFilterValues(Context cx, List[] groupBoundaryInfos, int i, List groupedFilters) throws DataException {
        if (i > 1) {
            int passedGroups = 0;
            for (int k = 0; k < groupBoundaryInfos[i - 2].size(); ++k) {
                CachedList currentGroupArray = new CachedList(GroupBoundaryInfo.getCreator());
                for (int n = 0; n < groupBoundaryInfos[i - 1].size(); ++n) {
                    if (!((GroupBoundaryInfo)groupBoundaryInfos[i - 2].get(k)).isInBoundary((GroupBoundaryInfo)groupBoundaryInfos[i - 1].get(n))) continue;
                    currentGroupArray.add(groupBoundaryInfos[i - 1].get(n));
                }
                this.makeAGroupFilteringMultiPass(cx, i, groupedFilters, currentGroupArray, passedGroups);
                passedGroups += currentGroupArray.size();
            }
        } else {
            this.makeAGroupFilteringMultiPass(cx, i, groupedFilters, groupBoundaryInfos[i - 1], 0);
        }
    }

    private void makeAGroupFilteringMultiPass(Context cx, int groupLevel, List filters, List currentGroupArray, int startingGroupInstanceIndex) throws DataException {
        this.advanceResultIteratorCursor(groupLevel, startingGroupInstanceIndex);
        this.filterPass.setPassLevel(1);
        this.filterPass.setRowCount(currentGroupArray.size());
        this.populateGroupBoundaryInfoFilters(cx, currentGroupArray, filters, groupLevel, false);
        this.advanceResultIteratorCursor(groupLevel, startingGroupInstanceIndex);
        this.filterPass.setPassLevel(2);
        this.populateGroupBoundaryInfoFilters(cx, currentGroupArray, filters, groupLevel, true);
        this.filterPass.setPassLevel(0);
        this.filterPass.setRowCount(-1);
        this.filterPass.setSecondPassRowCount(0);
    }

    private void advanceResultIteratorCursor(int groupLevel, int startingGroupInstanceIndex) throws DataException {
        this.populator.getResultIterator().first(0);
        for (int i = 0; i < startingGroupInstanceIndex; ++i) {
            this.populator.getResultIterator().last(groupLevel);
            this.populator.getResultIterator().next();
        }
    }

    private void populateGroupBoundaryInfoFilters(Context cx, List currentGroupArray, List filters, int groupLevel, boolean setUpValue) throws DataException {
        for (int m = 0; m < currentGroupArray.size(); ++m) {
            GroupBoundaryInfo currentGBI = (GroupBoundaryInfo)currentGroupArray.get(m);
            this.populator.getResultIterator().last(groupLevel);
            boolean accept = this.evaluateFilters(cx, filters);
            if (setUpValue) {
                currentGBI.setAccepted(currentGBI.isAccpted() && accept);
            }
            this.populator.getResultIterator().next();
        }
    }

    private boolean evaluateFilters(Context cx, List groupFilters) throws DataException {
        for (int j = 0; j < groupFilters.size(); ++j) {
            Object result = this.evaluteFilterExpression(cx, (IFilterDefinition)groupFilters.get(j));
            try {
                if (DataTypeUtil.toBoolean((Object)result).booleanValue()) continue;
                return false;
            }
            catch (BirtException e) {
                DataException e1 = new DataException("data.engine.DataConversionError", e);
                throw e1;
            }
        }
        return true;
    }

    private Object evaluteFilterExpression(Context cx, IFilterDefinition filter) throws DataException {
        IBaseExpression expr = filter.getExpression();
        FilterUtil.prepareFilterExpression(expr, this.filterPass, this.populator.getEventHandler().getExecutorHelper());
        Object result = ScriptEvalUtil.evalExpr(expr, cx, this.groupProcessor.getExpressionProcessor().getScope(), "GroupFilter", 0);
        if (result == null) {
            Object info = null;
            info = expr instanceof IScriptExpression ? ((IScriptExpression)expr).getText() : expr;
            throw new DataException("data.engine.BadFilterExpr", info);
        }
        return result;
    }
}

