/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSourceFactory;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataSetCacheUtil;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.ScriptDataSetRuntime;
import org.eclipse.birt.data.engine.odi.ICandidateQuery;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;

class PreparedScriptDSQuery
extends PreparedDataSourceQuery
implements IPreparedQuery {
    PreparedScriptDSQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn, IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        super(dataEngine, queryDefn, dataSetDesign, appContext);
        logger.logp(Level.FINER, PreparedScriptDSQuery.class.getName(), "PreparedScriptDSQuery", "PreparedScriptDSQuery starts up.");
    }

    public Collection getParameterMetaData() throws DataException {
        DataException e = new DataException("data.engine.NoParamMetaForDataSource");
        logger.logp(Level.FINE, PreparedDataSourceQuery.class.getName(), "getParameterMetaData", "Cannot get parameter metadata for this type of data source.", (Throwable)((Object)e));
        throw e;
    }

    protected QueryExecutor newExecutor() {
        return new ScriptDSQueryExecutor();
    }

    class ScriptDSQueryExecutor
    extends PreparedDataSourceQuery.DSQueryExecutor {
        private ResultClass resultClass;
        private CustomDataSet customDataSet;
        static final /* synthetic */ boolean $assertionsDisabled;

        ScriptDSQueryExecutor() {
        }

        protected IDataSource createOdiDataSource() {
            PreparedScriptDSQuery self = PreparedScriptDSQuery.this;
            return DataSourceFactory.getFactory().getDataSource(null, null, this.dataSource.getDesign(), this.dataSet.getDesign(), self.queryDefn.getInputParamBindings(), DataSetCacheUtil.getCacheOption(self.dataEngine.getContext(), PreparedScriptDSQuery.this.appContext), self.dataEngine.getContext().getCacheCount(), self.dataEngine.getSession());
        }

        protected IQuery createOdiQuery() throws DataException {
            if (!$assertionsDisabled && this.odiDataSource == null) {
                throw new AssertionError();
            }
            ICandidateQuery candidateQuery = this.odiDataSource.newCandidateQuery();
            return candidateQuery;
        }

        protected void populateOdiQuery() throws DataException {
            super.populateOdiQuery();
            ICandidateQuery candidateQuery = (ICandidateQuery)this.odiQuery;
            if (!$assertionsDisabled && candidateQuery == null) {
                throw new AssertionError();
            }
            ScriptDataSetRuntime scriptDataSet = (ScriptDataSetRuntime)this.dataSet;
            List resultHints = this.dataSet.getResultSetHints();
            List computedColumns = this.dataSet.getComputedColumns();
            ArrayList<ResultFieldMetadata> columnsList = new ArrayList<ResultFieldMetadata>();
            this.resolveDataSetParameters(true);
            if (scriptDataSet.describe()) {
                columnsList.addAll(scriptDataSet.getDescribedMetaData());
            } else {
                Iterator it = resultHints.iterator();
                int j = 0;
                while (it.hasNext()) {
                    IColumnDefinition columnDefn = (IColumnDefinition)it.next();
                    ResultFieldMetadata columnMetaData = new ResultFieldMetadata(j + 1, columnDefn.getColumnName(), columnDefn.getColumnName(), DataType.getClass((int)columnDefn.getDataType()), null, true);
                    columnsList.add(columnMetaData);
                    columnMetaData.setAlias(columnDefn.getAlias());
                    ++j;
                }
            }
            int count = columnsList.size();
            Iterator it = computedColumns.iterator();
            int j = resultHints.size();
            while (it.hasNext()) {
                IComputedColumn compColumn = (IComputedColumn)it.next();
                ResultFieldMetadata columnMetaData = new ResultFieldMetadata(++count, compColumn.getName(), compColumn.getName(), DataType.getClass((int)compColumn.getDataType()), null, true);
                columnsList.add(columnMetaData);
                ++j;
            }
            this.resultClass = new ResultClass(columnsList);
        }

        protected void prepareOdiQuery() throws DataException {
            if (!$assertionsDisabled && this.odiQuery == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.resultClass == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !(this.dataSet instanceof ScriptDataSetRuntime)) {
                throw new AssertionError();
            }
            ICandidateQuery candidateQuery = (ICandidateQuery)this.odiQuery;
            this.customDataSet = new CustomDataSet();
            candidateQuery.setCandidates(this.customDataSet);
        }

        protected IResultIterator executeOdiQuery(IEventHandler eventHandler) throws DataException {
            this.customDataSet.open();
            this.dataSet.afterOpen();
            ICandidateQuery candidateQuery = (ICandidateQuery)this.odiQuery;
            return candidateQuery.execute(eventHandler);
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$impl$PreparedScriptDSQuery == null ? (class$org$eclipse$birt$data$engine$impl$PreparedScriptDSQuery = PreparedScriptDSQuery.class$("org.eclipse.birt.data.engine.impl.PreparedScriptDSQuery")) : class$org$eclipse$birt$data$engine$impl$PreparedScriptDSQuery).desiredAssertionStatus();
        }

        private final class CustomDataSet
        implements ICustomDataSet {
            private CustomDataSet() {
            }

            public IResultClass getResultClass() {
                return ScriptDSQueryExecutor.this.resultClass;
            }

            public void open() throws DataException {
                ((ScriptDataSetRuntime)ScriptDSQueryExecutor.this.dataSet).open();
            }

            public IResultObject fetch() throws DataException {
                Object[] fields = new Object[ScriptDSQueryExecutor.this.resultClass.getFieldCount()];
                ResultObject resultObject = new ResultObject(ScriptDSQueryExecutor.this.resultClass, fields);
                ScriptDSQueryExecutor.this.dataSet.setRowObject(resultObject, true);
                boolean evalResult = ((ScriptDataSetRuntime)ScriptDSQueryExecutor.this.dataSet).fetch();
                if (!evalResult) {
                    resultObject = null;
                }
                return resultObject;
            }

            public void close() throws DataException {
                ((ScriptDataSetRuntime)ScriptDSQueryExecutor.this.dataSet).close();
            }
        }
    }
}

