/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.math.BigDecimal;
import java.sql.Blob;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.BindingColumnsEvalUtil;
import org.eclipse.birt.data.engine.impl.IServiceForResultSet;
import org.eclipse.birt.data.engine.impl.LogUtil;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.impl.RowIDUtil;
import org.eclipse.birt.data.engine.impl.document.IDInfo;
import org.eclipse.birt.data.engine.impl.document.IRDSave;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ResultIterator
implements IResultIterator {
    private DataEngineContext context;
    private RDSaveHelper rdSaveHelper;
    private Scriptable scope;
    protected org.eclipse.birt.data.engine.odi.IResultIterator odiResult;
    private IServiceForResultSet resultService;
    private GroupUtil groupUtil;
    protected RowIDUtil rowIDUtil;
    private int lastRowIndex = -1;
    private Map boundColumnValueMap = new HashMap();
    private BindingColumnsEvalUtil bindingColumnsEvalUtil;
    private int state = 0;
    private static final int NOT_STARTED = 0;
    private static final int BEFORE_FIRST_ROW = 1;
    private static final int ON_ROW = 2;
    private static final int AFTER_LAST_ROW = 3;
    private static final int CLOSED = -1;
    private boolean isFirstRowPepared = false;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    ResultIterator(IServiceForResultSet rService, org.eclipse.birt.data.engine.odi.IResultIterator odiResult, Scriptable scope) throws DataException {
        if (!($assertionsDisabled || rService != null && rService.getQueryResults() != null && odiResult != null && scope != null)) {
            throw new AssertionError();
        }
        this.resultService = rService;
        this.odiResult = odiResult;
        this.scope = scope;
        this.context = rService.getContext();
        this.start();
    }

    public Scriptable getScope() {
        return this.scope;
    }

    private void start() throws DataException {
        if (!$assertionsDisabled && this.state != 0) {
            throw new AssertionError();
        }
        this.state = 1;
        this.getRdSaveHelper().doSaveStart();
    }

    private void checkStarted() throws DataException {
        if (this.state == 0 || this.state == -1) {
            DataException e = new DataException("data.engine.ResultClosed");
            logger.logp(Level.FINE, ResultIterator.class.getName(), "checkStarted", "ResultIterator has been closed.", (Throwable)((Object)e));
            throw e;
        }
    }

    public IQueryResults getQueryResults() {
        return this.resultService.getQueryResults();
    }

    public boolean next() throws BirtException {
        this.checkStarted();
        boolean hasNext = false;
        if (this.state == 1) {
            this.state = 2;
            hasNext = this.odiResult.getCurrentResult() != null;
        } else {
            hasNext = this.hasNextRow();
        }
        if (hasNext) {
            this.prepareCurrentRow();
        }
        if (!hasNext) {
            this.state = 3;
        }
        return hasNext;
    }

    protected boolean hasNextRow() throws DataException {
        return this.odiResult.next();
    }

    public int getRowId() throws BirtException {
        this.checkStarted();
        if (this.rowIDUtil == null) {
            this.rowIDUtil = new RowIDUtil();
        }
        if (this.rowIDUtil == null) {
            this.rowIDUtil = new RowIDUtil();
        }
        if (this.rowIDUtil.getMode(this.odiResult) == 1) {
            return this.odiResult.getCurrentResultIndex();
        }
        IResultObject ob = this.odiResult.getCurrentResult();
        if (ob == null) {
            return -1;
        }
        return (Integer)ob.getFieldValue(this.rowIDUtil.getRowIdPos());
    }

    public int getRowIndex() throws BirtException {
        this.checkStarted();
        return this.odiResult.getCurrentResultIndex();
    }

    public void moveTo(int rowIndex) throws BirtException {
        this.checkStarted();
        if (this.state == 1) {
            this.prepareCurrentRow();
            this.state = 2;
        }
        int currRowIndex = this.odiResult.getCurrentResultIndex();
        if (rowIndex < 0 || rowIndex >= this.odiResult.getRowCount()) {
            throw new DataException("data.engine.invalidRowIndex", new Integer(rowIndex));
        }
        if (rowIndex < currRowIndex) {
            throw new DataException("data.engine.backwardSeekError");
        }
        if (rowIndex == currRowIndex) {
            return;
        }
        int gapRows = rowIndex - currRowIndex;
        for (int i = 0; i < gapRows; ++i) {
            this.next();
        }
    }

    private RDSaveHelper getRdSaveHelper() {
        if (this.rdSaveHelper == null) {
            this.rdSaveHelper = new RDSaveHelper(this.context, this.resultService.getQueryDefn(), this.odiResult, new IDInfo(this.resultService.getQueryResults().getID()));
        }
        return this.rdSaveHelper;
    }

    public Object getValue(String exprName) throws BirtException {
        Object exprValue;
        this.checkStarted();
        logger.logp(Level.FINER, ResultIterator.class.getName(), "getValue", "get of value binding column: " + LogUtil.toString(exprName));
        if (this.resultService.getBindingExpr(exprName) == null && this.resultService.getAutoBindingExpr(exprName) == null) {
            throw new DataException("data.engine.InvalidBoundColumnName", exprName);
        }
        if (!this.isFirstRowPepared) {
            this.prepareCurrentRow();
        }
        if ((exprValue = this.boundColumnValueMap.get(exprName)) instanceof BirtException) {
            throw (BirtException)((Object)exprValue);
        }
        return exprValue;
    }

    private void prepareCurrentRow() throws DataException {
        int currRowIndex = this.odiResult.getCurrentResultIndex();
        if (this.lastRowIndex < currRowIndex) {
            if (this.bindingColumnsEvalUtil == null) {
                this.bindingColumnsEvalUtil = new BindingColumnsEvalUtil(this.odiResult, this.scope, this.getRdSaveHelper(), this.resultService.getAllBindingExprs(), this.resultService.getAllAutoBindingExprs());
            }
            this.lastRowIndex = currRowIndex;
            this.boundColumnValueMap = this.bindingColumnsEvalUtil.getColumnsValue();
            this.isFirstRowPepared = true;
        }
    }

    public Boolean getBoolean(String name) throws BirtException {
        return DataTypeUtil.toBoolean((Object)this.getValue(name));
    }

    public Integer getInteger(String name) throws BirtException {
        return DataTypeUtil.toInteger((Object)this.getValue(name));
    }

    public Double getDouble(String name) throws BirtException {
        return DataTypeUtil.toDouble((Object)this.getValue(name));
    }

    public String getString(String name) throws BirtException {
        return DataTypeUtil.toString((Object)this.getValue(name));
    }

    public BigDecimal getBigDecimal(String name) throws BirtException {
        return DataTypeUtil.toBigDecimal((Object)this.getValue(name));
    }

    public Date getDate(String name) throws BirtException {
        return DataTypeUtil.toDate((Object)this.getValue(name));
    }

    public Blob getBlob(String name) throws BirtException {
        return DataTypeUtil.toBlob((Object)this.getValue(name));
    }

    public byte[] getBytes(String name) throws BirtException {
        return DataTypeUtil.toBytes((Object)this.getValue(name));
    }

    public void skipToEnd(int groupLevel) throws BirtException {
        this.checkStarted();
        this.goThroughGapRows(groupLevel);
        logger.logp(Level.FINER, ResultIterator.class.getName(), "skipToEnd", "skipping rows to the last row in the current group");
    }

    protected void goThroughGapRows(int groupLevel) throws DataException, BirtException {
        while (groupLevel < this.odiResult.getEndingGroupLevel() && this.odiResult.getEndingGroupLevel() != 0 && this.odiResult.next()) {
            this.prepareCurrentRow();
        }
    }

    public int getStartingGroupLevel() throws DataException {
        return this.odiResult.getStartingGroupLevel();
    }

    public int getEndingGroupLevel() throws DataException {
        return this.odiResult.getEndingGroupLevel();
    }

    public IResultIterator getSecondaryIterator(String subQueryName, Scriptable subScope) throws DataException {
        IResultIterator resultIt;
        this.checkStarted();
        IQueryResults results = this.resultService.execSubquery(this.odiResult, subQueryName, subScope);
        logger.logp(Level.FINE, ResultIterator.class.getName(), "getSecondaryIterator", "Returns the secondary result specified by a SubQuery");
        try {
            resultIt = results.getResultIterator();
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
        if (resultIt instanceof ResultIterator) {
            this.getRdSaveHelper().processForSubQuery(this.getQueryResults().getID(), (ResultIterator)resultIt, subQueryName);
        }
        return resultIt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultMetaData getResultMetaData() throws DataException {
        ResultMetaData resultMetaData;
        try {
            resultMetaData = new ResultMetaData(this.odiResult.getResultClass());
            Object var3_2 = null;
            logger.logp(Level.FINE, ResultIterator.class.getName(), "getResultMetaData", "Returns the result metadata");
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            logger.logp(Level.FINE, ResultIterator.class.getName(), "getResultMetaData", "Returns the result metadata");
            throw throwable;
        }
        return resultMetaData;
    }

    public void close() throws BirtException {
        if (this.getRdSaveHelper().needsSaveToDoc()) {
            while (this.next()) {
            }
            this.getRdSaveHelper().doSaveFinish();
        }
        if (this.odiResult != null) {
            this.odiResult.close();
        }
        this.odiResult = null;
        this.resultService = null;
        this.state = -1;
        logger.logp(Level.FINE, ResultIterator.class.getName(), "close", "a ResultIterator is closed");
    }

    org.eclipse.birt.data.engine.odi.IResultIterator getOdiResult() {
        return this.odiResult;
    }

    public boolean findGroup(Object[] groupKeyValues) throws BirtException {
        if (this.groupUtil == null) {
            this.groupUtil = new GroupUtil(this.resultService.getQueryDefn(), this);
        }
        return this.groupUtil.findGroup(groupKeyValues);
    }

    static {
        $assertionsDisabled = !ResultIterator.class.desiredAssertionStatus();
        logger = Logger.getLogger(ResultIterator.class.getName());
    }

    class RDSaveHelper {
        private DataEngineContext context;
        private IBaseQueryDefinition queryDefn;
        private org.eclipse.birt.data.engine.odi.IResultIterator odiResult;
        private IDInfo idInfo;
        private IRDSave rdSave;
        private boolean isBasicSaved;

        RDSaveHelper(DataEngineContext context, IBaseQueryDefinition queryDefn, org.eclipse.birt.data.engine.odi.IResultIterator odiResult, IDInfo idInfo) {
            this.context = context;
            this.queryDefn = queryDefn;
            this.odiResult = odiResult;
            this.idInfo = idInfo;
        }

        void doSaveExpr(Map valueMap) throws DataException {
            this.doSave(valueMap, false);
        }

        void doSaveFinish() throws DataException {
            this.doSave(null, true);
        }

        void doSaveStart() throws DataException {
            if (!this.needsSaveToDoc()) {
                return;
            }
            this.getRdSave().saveStart();
        }

        private void doSave(Map valueMap, boolean finish) throws DataException {
            if (!this.needsSaveToDoc()) {
                return;
            }
            if (!this.isBasicSaved) {
                this.isBasicSaved = true;
                this.getRdSave().saveResultIterator(this.odiResult, this.idInfo.getGroupLevel(), this.idInfo.getSubQueryInfo());
            }
            if (!finish) {
                this.rdSave.saveExprValue(this.odiResult.getCurrentResultIndex(), valueMap);
            } else {
                this.rdSave.saveFinish(this.odiResult.getRowCount() - 1);
            }
        }

        private IRDSave getRdSave() throws DataException {
            if (this.rdSave == null) {
                this.rdSave = RDUtil.newSave(this.context, this.queryDefn, this.odiResult.getRowCount(), new QueryResultInfo(this.idInfo.getQueryResultID(), this.idInfo.getsubQueryName(), this.idInfo.getsubQueryIndex()));
            }
            return this.rdSave;
        }

        private boolean needsSaveToDoc() {
            if (ResultIterator.this.state == 0 || ResultIterator.this.state == -1) {
                return false;
            }
            return this.context != null && this.context.getMode() != 3 && this.context.getMode() != 2;
        }

        private void processForSubQuery(String parentQueryID, ResultIterator resultIt, String subQueryName) throws DataException {
            if (!this.needsSaveToDoc()) {
                return;
            }
            QueryResults results = (QueryResults)resultIt.getQueryResults();
            results.setID(this.idInfo.buildSubQueryID(parentQueryID));
            if (((ISubqueryDefinition)resultIt.resultService.getQueryDefn()).applyOnGroup()) {
                resultIt.rdSaveHelper = new RDSaveHelper(resultIt.context, resultIt.resultService.getQueryDefn(), resultIt.odiResult, new IDInfo(resultIt.getQueryResults().getID(), subQueryName, results.getGroupLevel(), this.odiResult.getCurrentGroupIndex(results.getGroupLevel()), this.odiResult.getGroupStartAndEndIndex(results.getGroupLevel())));
            } else {
                resultIt.rdSaveHelper = new RDSaveHelper(resultIt.context, resultIt.resultService.getQueryDefn(), resultIt.odiResult, new IDInfo(resultIt.getQueryResults().getID(), subQueryName, 1, this.odiResult.getCurrentResultIndex(), IDInfo.getSpecialSubQueryInfo(this.odiResult.getRowCount())));
            }
        }
    }

    private class GroupUtil {
        private IBaseQueryDefinition queryDefn;
        private ResultIterator resultIterator;

        private GroupUtil(IBaseQueryDefinition queryDefn, ResultIterator resultIterator) {
            this.queryDefn = queryDefn;
            this.resultIterator = resultIterator;
        }

        public boolean findGroup(Object[] groupKeyValues) throws BirtException {
            int i;
            org.eclipse.birt.data.engine.odi.IResultIterator odiResult = this.resultIterator.getOdiResult();
            List groups = this.queryDefn.getGroups();
            if (groupKeyValues.length > groups.size()) {
                throw new DataException("data.engine.incorrectGroupKeyValues");
            }
            GroupDefinition group = null;
            String[] columnNames = new String[groupKeyValues.length];
            for (i = 0; i < columnNames.length; ++i) {
                group = (GroupDefinition)groups.get(i);
                columnNames[i] = this.getGroupKeyExpression(group);
            }
            odiResult.first(0);
            if (odiResult.getCurrentResult() == null) {
                return false;
            }
            block1: do {
                for (i = 0; i < columnNames.length; ++i) {
                    if (this.groupKeyValuesEqual(odiResult, groupKeyValues, columnNames, i)) {
                        if (i != columnNames.length - 1) continue;
                        return true;
                    }
                    this.resultIterator.skipToEnd(i + 1);
                    continue block1;
                }
            } while (odiResult.next());
            return false;
        }

        private boolean groupKeyValuesEqual(org.eclipse.birt.data.engine.odi.IResultIterator odiResult, Object[] groupKeyValues, String[] columnExprs, int i) throws BirtException {
            Object fieldValue = null;
            Context cx = Context.enter();
            fieldValue = ScriptEvalUtil.evalExpr(new ScriptExpression(columnExprs[i]), cx, ResultIterator.this.scope, "Filter", 0);
            Context.exit();
            boolean retValue = false;
            if (fieldValue == groupKeyValues[i]) {
                retValue = true;
            } else if (fieldValue != null && groupKeyValues[i] != null) {
                if (fieldValue.getClass().equals(groupKeyValues[i].getClass())) {
                    retValue = this.isTwoObjectEqual(fieldValue, groupKeyValues[i]);
                } else {
                    Object convertedOb = DataTypeUtil.convert((Object)groupKeyValues[i], fieldValue.getClass());
                    retValue = this.isTwoObjectEqual(fieldValue, convertedOb);
                }
            }
            return retValue;
        }

        private boolean isTwoObjectEqual(Object value1, Object value2) {
            if (value1 instanceof Date && value2 instanceof Date) {
                return ((Date)value1).getTime() == ((Date)value2).getTime();
            }
            return value1.equals(value2);
        }

        private String getGroupKeyExpression(GroupDefinition group) {
            String columnName = group.getKeyColumn() != null ? ExpressionUtil.createJSRowExpression((String)group.getKeyColumn()) : group.getKeyExpression();
            return columnName;
        }
    }
}

