/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSColumnDefn
extends ScriptableObject {
    private static String INDEX;
    private static String NAME;
    private static String TYPE;
    private static String NATIVE_TYPE;
    private static String LABEL;
    private static String ALIAS;
    private static String INTEGER;
    private static String FLOAT;
    private static String DECIMAL;
    private static String BOOLEAN;
    private static String STRING;
    private static String DATETIME;
    private static String INTEGER_VAL;
    private static String FLOAT_VAL;
    private static String DECIMAL_VAL;
    private static String BOOLEAN_VAL;
    private static String STRING_VAL;
    private static String DATETIME_VAL;
    private static String[] propNames;
    private static HashSet propNameSet;
    private IResultClass resultClass;
    private int fieldIndex;
    private static Logger logger;
    private static final long serialVersionUID = -4456827193707814588L;
    static final /* synthetic */ boolean $assertionsDisabled;

    JSColumnDefn(IResultClass resultClass, int index) {
        logger.entering(JSColumnDefn.class.getName(), "JSColumnDefn");
        if (!$assertionsDisabled && resultClass == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || index > 0 && index <= resultClass.getFieldCount())) {
            throw new AssertionError();
        }
        this.resultClass = resultClass;
        this.fieldIndex = index;
        this.sealObject();
    }

    public Object get(String name, Scriptable start) {
        logger.entering(JSColumnDefn.class.getName(), "get", name);
        if (!propNameSet.contains(name)) {
            logger.exiting(JSColumnDefn.class.getName(), "get", super.get(name, start));
            return super.get(name, start);
        }
        if (name.equals(INTEGER)) {
            logger.exiting(JSColumnDefn.class.getName(), "get", INTEGER_VAL);
            return INTEGER_VAL;
        }
        if (name.equals(FLOAT)) {
            logger.exiting(JSColumnDefn.class.getName(), "get", FLOAT_VAL);
            return FLOAT_VAL;
        }
        if (name.equals(DECIMAL)) {
            logger.exiting(JSColumnDefn.class.getName(), "get", DECIMAL_VAL);
            return DECIMAL_VAL;
        }
        if (name.equals(BOOLEAN)) {
            logger.exiting(JSColumnDefn.class.getName(), "get", BOOLEAN_VAL);
            return BOOLEAN_VAL;
        }
        if (name.equals(STRING)) {
            logger.exiting(JSColumnDefn.class.getName(), "get", STRING_VAL);
            return STRING_VAL;
        }
        if (name.equals(DATETIME)) {
            logger.exiting(JSColumnDefn.class.getName(), "get", DATETIME_VAL);
            return DATETIME_VAL;
        }
        try {
            if (name.equals(INDEX)) {
                logger.exiting(JSColumnDefn.class.getName(), "get", new Integer(this.fieldIndex));
                return new Integer(this.fieldIndex);
            }
            if (name.equals(NAME)) {
                logger.exiting(JSColumnDefn.class.getName(), "get", this.resultClass.getFieldName(this.fieldIndex));
                return this.resultClass.getFieldName(this.fieldIndex);
            }
            if (name.equals(TYPE)) {
                Class c = this.resultClass.getFieldValueClass(this.fieldIndex);
                if (c == Integer.class) {
                    logger.exiting(JSColumnDefn.class.getName(), "get", INTEGER_VAL);
                    return INTEGER_VAL;
                }
                if (c == Double.class) {
                    logger.exiting(JSColumnDefn.class.getName(), "get", FLOAT_VAL);
                    return FLOAT_VAL;
                }
                if (c == String.class) {
                    logger.exiting(JSColumnDefn.class.getName(), "get", STRING_VAL);
                    return STRING_VAL;
                }
                if (c == BigDecimal.class) {
                    logger.exiting(JSColumnDefn.class.getName(), "get", DECIMAL_VAL);
                    return DECIMAL_VAL;
                }
                if (c == Boolean.class) {
                    logger.exiting(JSColumnDefn.class.getName(), "get", BOOLEAN_VAL);
                    return BOOLEAN_VAL;
                }
                if (c == Date.class || c == Time.class || c == Timestamp.class) {
                    logger.exiting(JSColumnDefn.class.getName(), "get", DATETIME_VAL);
                    return DATETIME_VAL;
                }
                logger.exiting(JSColumnDefn.class.getName(), "get", null);
                return null;
            }
            if (name.equals(NATIVE_TYPE)) {
                logger.exiting(JSColumnDefn.class.getName(), "get", null);
                return null;
            }
            if (name.equals(LABEL)) {
                logger.exiting(JSColumnDefn.class.getName(), "get", this.resultClass.getFieldLabel(this.fieldIndex));
                return this.resultClass.getFieldLabel(this.fieldIndex);
            }
            if (name.equals(ALIAS)) {
                logger.exiting(JSColumnDefn.class.getName(), "get", this.resultClass.getFieldAlias(this.fieldIndex));
                return this.resultClass.getFieldAlias(this.fieldIndex);
            }
        }
        catch (DataException e) {
            logger.logp(Level.FINER, JSColumnDefn.class.getName(), "get", e.getMessage(), (Throwable)((Object)e));
            logger.exiting(JSColumnDefn.class.getName(), "get", null);
            return null;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        logger.exiting(JSColumnDefn.class.getName(), "get", null);
        return null;
    }

    public String getClassName() {
        return "ColumnDefn";
    }

    public Object[] getIds() {
        return propNames;
    }

    public boolean has(String name, Scriptable start) {
        logger.entering(JSColumnDefn.class.getName(), "has", name);
        if (propNameSet.contains(name)) {
            logger.exiting(JSColumnDefn.class.getName(), "has", new Boolean(true));
            return true;
        }
        logger.exiting(JSColumnDefn.class.getName(), "has", new Boolean(super.has(name, start)));
        return super.has(name, start);
    }

    static {
        $assertionsDisabled = !JSColumnDefn.class.desiredAssertionStatus();
        INDEX = "index";
        NAME = "name";
        TYPE = "type";
        NATIVE_TYPE = "nativeType";
        LABEL = "label";
        ALIAS = "alias";
        INTEGER = "integer";
        FLOAT = "float";
        DECIMAL = "decimal";
        BOOLEAN = "boolean";
        STRING = "string";
        DATETIME = "dateTime";
        INTEGER_VAL = "integer";
        FLOAT_VAL = "float";
        DECIMAL_VAL = "decimal";
        BOOLEAN_VAL = "boolean";
        STRING_VAL = "string";
        DATETIME_VAL = "dateTime";
        propNames = new String[]{INDEX, NAME, TYPE, NATIVE_TYPE, LABEL, ALIAS, INTEGER, FLOAT, DECIMAL, BOOLEAN, STRING, DATETIME};
        propNameSet = new HashSet<String>(Arrays.asList(propNames));
        logger = Logger.getLogger(JSColumnDefn.class.getName());
    }
}

