/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class ThreshHoldInfo {
    private Map map = new HashMap();
    private int backRefLevel;
    private boolean isSimple;
    private int forwardRefLevel;

    ThreshHoldInfo(int backRefLevel, int forwardRefLevel, boolean isSimple) {
        this.backRefLevel = backRefLevel;
        this.isSimple = isSimple;
        this.forwardRefLevel = forwardRefLevel;
    }

    void addInfo(String path, String value) {
        this.map.put(path, value);
    }

    String getValue(String rootPath) {
        String nestedXMLPath = this.getCorrespondingNestedXMLColumnPath(rootPath);
        if (nestedXMLPath == null) {
            return null;
        }
        return this.map.get(nestedXMLPath).toString();
    }

    private String getCorrespondingNestedXMLColumnPath(String rootPath) {
        Iterator it = this.map.keySet().iterator();
        String nestedXMLPath = null;
        while (it.hasNext()) {
            String temp = it.next().toString();
            if (!this.pathMatch(temp, rootPath)) continue;
            nestedXMLPath = temp;
            break;
        }
        return nestedXMLPath;
    }

    private boolean pathMatch(String path, String currentRootPath) {
        if (path == null) {
            return false;
        }
        String[] paths = path.split("/");
        String[] nestedXMLColumnPaths = currentRootPath.split("/");
        int commonRootLen = nestedXMLColumnPaths.length - this.backRefLevel;
        if (commonRootLen < 0 || paths.length != commonRootLen + this.forwardRefLevel) {
            return false;
        }
        for (int i = 0; i < commonRootLen; ++i) {
            if (paths[i].startsWith(nestedXMLColumnPaths[i])) continue;
            return false;
        }
        return !this.isSimple || paths.length == commonRootLen;
    }
}

