/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.job;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.eclipse.aperi.agent.handler.job.IExecutable;
import org.eclipse.aperi.agent.handler.job.IRestartable;
import org.eclipse.aperi.agent.handler.job.JobExtensionMgr;
import org.eclipse.aperi.agent.handler.job.JobState;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.Link;
import org.eclipse.aperi.agent.worker.IAssignable;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.util.extensions.ExtensionException;
import org.eclipse.aperi.xmsg.MessageLog;

public class JavaJobRestart {
    public static void restart() {
        String[] stringArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobRestart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"restart", (String)"");
        }
        if ((stringArray = JobState.getSavedJobs()) == null || stringArray.length == 0) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobRestart");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"restart");
            }
            return;
        }
        Response response = new Response(0, null);
        int n = 0;
        while (n < stringArray.length) {
            block24: {
                JobState jobState = new JobState(stringArray[n]);
                if (!jobState.restoreState()) {
                    MessageLog.logMessage((String)"AGT0126E", (Object)stringArray[n]);
                    jobState.deleteState();
                } else {
                    Object object;
                    StartedJob startedJob = jobState.job;
                    JobRun jobRun = startedJob.getJobRun();
                    IExecutable iExecutable = null;
                    String string = jobRun.getCommandLine()[0];
                    if (string != null) {
                        object = JobExtensionMgr.getExtensionMgr();
                        try {
                            iExecutable = (IExecutable)object.getExtensionImpl(string);
                        }
                        catch (ExtensionException extensionException) {
                            response.errorMessage = extensionException.getMessage();
                        }
                    }
                    if (iExecutable == null) {
                        MessageLog.logMessage((String)"AGT0127E", (Object)jobRun.getSchedCreator(), (Object)jobRun.getSchedName(), (Object)Integer.toString(jobRun.getSchedRunNumber()));
                        if (response.errorMessage != null) {
                            MessageLog.getThreadLog().println(response.errorMessage);
                        }
                        jobState.deleteState();
                    } else {
                        object = null;
                        try {
                            object = new FileOutputStream(startedJob.getLogFileName(), true);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobRestart");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exception((String)clazz.getName(), (String)"restart", (Throwable)fileNotFoundException);
                            }
                            MessageLog.getMessageWithException((String)"GEN0036E", (Exception)fileNotFoundException);
                            jobState.deleteState();
                            break block24;
                        }
                        PrintWriter printWriter = new PrintWriter((OutputStream)object, true);
                        Link link = Agent.jobManager.jobInit(startedJob);
                        Agent.breadLine.assign(new Executor(iExecutable, jobState, link, printWriter));
                    }
                }
            }
            ++n;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobRestart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"restart");
        }
    }

    private static class Executor
    implements IAssignable {
        private IExecutable toRun;
        private Link link;
        private StartedJob job;
        private PrintWriter output;
        private JobState state;

        public Executor(IExecutable iExecutable, JobState jobState, Link link, PrintWriter printWriter) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobRestart$Executor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"Executor", (String)"toRun, state, link, output");
            }
            this.toRun = iExecutable;
            this.link = link;
            this.state = jobState;
            this.output = printWriter;
            this.job = jobState.job;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobRestart$Executor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"Executor");
            }
        }

        public void execute() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobRestart$Executor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"execute", (String)"");
            }
            PrintWriter printWriter = MessageLog.getThreadLog();
            MessageLog.setThreadLog((PrintWriter)this.output);
            try {
                this.job.setExitCode(((IRestartable)((Object)this.toRun)).restart(this.state));
            }
            catch (Exception exception) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobRestart$Executor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"execute", (Throwable)exception);
                }
                exception.printStackTrace(this.output);
                this.job.setExitCode(-1);
            }
            MessageLog.setThreadLog((PrintWriter)printWriter);
            this.output.close();
            Agent.jobManager.finalizeJob(this.job.getExitCode(), this.link);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobRestart$Executor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"execute");
            }
        }
    }
}

