/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.job;

import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.Link;
import org.eclipse.aperi.agent.util.ListOfLinks;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.request.Request;

public class JobManager {
    private ListOfLinks runningJobs = new ListOfLinks();

    public void waitUntilJobsComplete() {
        this.runningJobs.waitUntilEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRunningJobs(Set set) {
        ListOfLinks listOfLinks = this.runningJobs;
        synchronized (listOfLinks) {
            Iterator iterator = this.runningJobs.iterator();
            while (iterator.hasNext()) {
                set.add(iterator.next());
            }
        }
    }

    public synchronized StartedJob getJobByRunNumber(int n) {
        StartedJob startedJob = null;
        Iterator iterator = this.runningJobs.iterator();
        while (iterator.hasNext()) {
            startedJob = (StartedJob)iterator.next();
            if (startedJob.getJobRun().getRunNumber() == n) continue;
        }
        return startedJob;
    }

    public Link jobInit(StartedJob startedJob) {
        Link link = null;
        if (Agent.state < 2) {
            link = this.addJob(startedJob);
        }
        return link;
    }

    public void jobWait(StartedJob startedJob) {
        startedJob.setJobStatus((byte)87);
        startedJob.setStarted(this.waitToStart(startedJob.getJobRun().getDesiredStartTime()));
    }

    public void jobExec(StartedJob startedJob) {
        startedJob.setJobStatus((byte)69);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeJob(int n, Link link) {
        if (n == -4096) {
            this.removeJob(link);
        } else {
            StartedJob startedJob = (StartedJob)link.datum;
            Date date = new Date();
            startedJob.setFinished(date.getTime());
            if (startedJob.getJobStatus() == 69) {
                startedJob.setJobStatus((byte)67);
            }
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
            request.subType = "org.eclipse.aperi.server.handler.scheduler.ScheduleHandler";
            request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
            request.machineName = Agent.localName;
            request.userName = null;
            request.requestData = startedJob;
            request.flags = (byte)2;
            ListOfLinks listOfLinks = this.runningJobs;
            synchronized (listOfLinks) {
                this.runningJobs.unlink(link);
                Agent.reporter.add(request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Link addJob(StartedJob startedJob) {
        Link link;
        ListOfLinks listOfLinks = this.runningJobs;
        synchronized (listOfLinks) {
            link = this.runningJobs.append(startedJob);
        }
        return link;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeJob(Link link) {
        ListOfLinks listOfLinks = this.runningJobs;
        synchronized (listOfLinks) {
            this.runningJobs.unlink(link);
        }
    }

    private long waitToStart(long l) {
        long l2;
        while ((l2 = System.currentTimeMillis()) < l) {
            try {
                Thread.sleep(l - l2);
            }
            catch (InterruptedException interruptedException) {}
        }
        return l2;
    }
}

