/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.script.unix;

import java.io.File;
import java.io.PrintWriter;
import org.eclipse.aperi.agent.handler.script.AbstractScriptHandler;
import org.eclipse.aperi.agent.handler.script.ScriptContext;
import org.eclipse.aperi.agent.handler.script.ScriptReaper;
import org.eclipse.aperi.agent.handler.script.unix.IPlatformSpecific;
import org.eclipse.aperi.agent.handler.script.unix.Shared;
import org.eclipse.aperi.agent.handler.script.unix.UnixScriptContext;
import org.eclipse.aperi.agent.req.RunScriptReq;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.worker.IAssignable;
import org.eclipse.aperi.backend.JobUtil;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class UnixScriptRunner
implements IAssignable {
    private static IPlatformSpecific platformSpecific = new Starter();
    private String logFile;
    private PrintWriter out;
    private RunScriptReq requestData;
    private boolean purge;

    private static native void makeExecutable(String var0);

    private UnixScriptRunner(RunScriptReq runScriptReq, String string, PrintWriter printWriter, boolean bl) {
        this.requestData = runScriptReq;
        this.logFile = string;
        this.out = printWriter;
        this.purge = bl;
    }

    public static AbstractScriptHandler makeHandler() {
        return new UnixScriptHandler();
    }

    public static IPlatformSpecific getPlatformSpecific() {
        return platformSpecific;
    }

    public void execute() {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.unix.UnixScriptRunner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"execute", (String)"");
        }
        PrintWriter printWriter = MessageLog.getThreadLog();
        MessageLog.setThreadLog((PrintWriter)this.out);
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.requestData.scrArgv[0];
        String string3 = JobUtil.resolveUnixScript((String)string2, (StringBuffer)stringBuffer);
        String string4 = stringBuffer.toString();
        if (string3 == null && Agent.honorSentScripts && this.requestData.scrData != null && this.requestData.scrData[0] != null && (object = AbstractScriptHandler.writeTempFile("SCR", null, this.requestData.scrData[0])) != null) {
            string3 = string = ((File)object).getName();
            stringBuffer.setLength(0);
            stringBuffer.append(JobUtil.scriptsDir);
            stringBuffer.append('/');
            stringBuffer.append(string3);
            UnixScriptRunner.makeExecutable(stringBuffer.toString());
        }
        if (string3 == null) {
            MessageLog.logMessage((String)"AGT0132E", (Object)string4);
            MessageLog.setThreadLog((PrintWriter)printWriter);
            this.out.close();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.script.unix.UnixScriptRunner");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"execute");
            }
            return;
        }
        object = new UnixScriptContext();
        try {
            ((UnixScriptContext)object).tempFiles = AbstractScriptHandler.makeMoreTempFiles(this.requestData, string, this.purge);
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.script.unix.UnixScriptRunner");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"execute", (Throwable)generalException);
            }
            MessageLog.setThreadLog((PrintWriter)printWriter);
            this.out.close();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.script.unix.UnixScriptRunner");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"execute");
            }
            return;
        }
        ((UnixScriptContext)object).logFileName = this.logFile;
        ((UnixScriptContext)object).argv = this.requestData.scrArgv;
        ((UnixScriptContext)object).argv[0] = string3;
        stringBuffer.setLength(0);
        int n = 1;
        while (n < ((UnixScriptContext)object).argv.length) {
            stringBuffer.append(' ');
            if (((UnixScriptContext)object).argv[n] == null) {
                ((UnixScriptContext)object).argv[n] = " ";
            }
            stringBuffer.append(((UnixScriptContext)object).argv[n]);
            ++n;
        }
        MessageLog.logMessage((String)"AGT0133I", (Object)string4, (Object)stringBuffer.toString());
        this.out.println("--------------------- BEGIN OUTPUT ---------------------");
        n = 1;
        try {
            platformSpecific.start((UnixScriptContext)object);
            n = 0;
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.script.unix.UnixScriptRunner");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"execute", (Throwable)localizableException);
            }
            localizableException.print();
        }
        ((UnixScriptContext)object).argv = null;
        MessageLog.setThreadLog((PrintWriter)printWriter);
        this.out.close();
        if (n != 0) {
            ScriptReaper.removeTempFiles((ScriptContext)object);
        } else {
            int n2;
            try {
                n2 = Shared.awaitChild(((UnixScriptContext)object).handle);
            }
            catch (LocalizableException localizableException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.handler.script.unix.UnixScriptRunner");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"execute", (Throwable)localizableException);
                }
                localizableException.print();
                n2 = -1;
            }
            ((ScriptContext)object).scriptExited(n2);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.unix.UnixScriptRunner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"execute");
        }
    }

    /* synthetic */ UnixScriptRunner(RunScriptReq runScriptReq, String string, PrintWriter printWriter, boolean bl, UnixScriptRunner unixScriptRunner) {
        this(runScriptReq, string, printWriter, bl);
    }

    private static class Starter
    implements IPlatformSpecific {
        private Starter() {
        }

        public void start(UnixScriptContext unixScriptContext) throws LocalizableException {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.script.unix.UnixScriptRunner$Starter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"start", (String)"context");
            }
            Shared.fork(unixScriptContext);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.script.unix.UnixScriptRunner$Starter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"start");
            }
        }
    }

    private static class UnixScriptHandler
    extends AbstractScriptHandler {
        private UnixScriptHandler() {
        }

        public IAssignable makeRunner(RunScriptReq runScriptReq, String string, PrintWriter printWriter, boolean bl) {
            return new UnixScriptRunner(runScriptReq, string, printWriter, bl, null);
        }
    }
}

