/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import org.eclipse.birt.core.archive.compound.AllocationTable;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.EntryTable;

public class ArchiveEntry {
    protected int cachId;
    protected ArchiveFile af;
    protected EntryTable.Entry entry;
    protected AllocationTable.Entry index;

    ArchiveEntry(ArchiveFile af, EntryTable.Entry entry) throws IOException {
        this.af = af;
        this.entry = entry;
        this.cachId = entry.getBlock();
        if (this.cachId != -1) {
            this.index = af.allocTbl.loadEntry(this.cachId);
        }
    }

    public long getLength() throws IOException {
        return this.entry.getLength();
    }

    public void setLength(long length) throws IOException {
        this.entry.setLength(length);
    }

    public void flush() throws IOException {
    }

    public void refresh() throws IOException {
    }

    public Object lock() throws IOException {
        return this.af.lockEntry(this);
    }

    public void unlock(Object lock) throws IOException {
        this.af.unlockEntry(lock);
    }

    public int read(long pos, byte[] b, int off, int len) throws IOException {
        int remainSize;
        long length = this.entry.getLength();
        if (pos >= length) {
            return -1;
        }
        if (pos + (long)len > length) {
            len = (int)(length - pos);
        }
        int blockId = (int)(pos / 4096L);
        int blockOff = (int)(pos % 4096L);
        int readSize = 4096 - blockOff;
        if (len < readSize) {
            readSize = len;
        }
        int phyBlockId = this.index.getBlock(blockId);
        this.af.read(phyBlockId, blockOff, b, off, readSize);
        for (remainSize = len - readSize; remainSize >= 4096; remainSize -= 4096) {
            phyBlockId = this.index.getBlock(++blockId);
            this.af.read(phyBlockId, 0, b, off + readSize, 4096);
            readSize += 4096;
        }
        if (remainSize > 0) {
            phyBlockId = this.index.getBlock(++blockId);
            this.af.read(phyBlockId, 0, b, off + readSize, remainSize);
            readSize += remainSize;
        }
        return readSize;
    }

    public void write(long pos, byte[] b, int off, int len) throws IOException {
        long offset;
        long length;
        int remainSize;
        this.ensureSize(pos + (long)len);
        int blockId = (int)(pos / 4096L);
        int phyBlockId = this.index.getBlock(blockId);
        int blockOff = (int)(pos % 4096L);
        int writeSize = 4096 - blockOff;
        if (len < writeSize) {
            writeSize = len;
        }
        this.af.write(phyBlockId, blockOff, b, off, writeSize);
        for (remainSize = len - writeSize; remainSize >= 4096; remainSize -= 4096) {
            phyBlockId = this.index.getBlock(++blockId);
            this.af.write(phyBlockId, 0, b, off + writeSize, 4096);
            writeSize += 4096;
        }
        if (remainSize > 0) {
            phyBlockId = this.index.getBlock(++blockId);
            this.af.write(phyBlockId, 0, b, off + writeSize, remainSize);
        }
        if ((length = this.entry.getLength()) < (offset = pos + (long)len)) {
            this.setLength(offset);
        }
    }

    protected void ensureSize(long newLength) throws IOException {
        int totalBlock;
        int blockCount;
        if (this.index == null) {
            this.index = this.af.allocTbl.createEntry();
            this.entry.setBlock(this.index.getFirstBlock());
        }
        if ((blockCount = (int)((newLength + 4096L - 1L) / 4096L)) > (totalBlock = this.index.getTotalBlocks())) {
            this.index.allocBlocks(blockCount - totalBlock);
        }
    }
}

