/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;

public class ArchiveEntryInputStream
extends RAInputStream {
    protected ArchiveEntry entry;
    private long offset;
    byte[] buffer = new byte[8];

    public ArchiveEntryInputStream(ArchiveEntry entry) {
        this.entry = entry;
        this.offset = 0L;
    }

    public int read() throws IOException {
        this.entry.read(this.offset, this.buffer, 0, 1);
        ++this.offset;
        return this.buffer[0];
    }

    public int available() throws IOException {
        long av = this.entry.getLength() - this.offset;
        if (av > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)av;
    }

    public long getOffset() throws IOException {
        return this.offset;
    }

    public long length() throws IOException {
        return this.entry.getLength();
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.entry.read(this.offset, b, off, len);
        this.offset += (long)len;
    }

    public int readInt() throws IOException {
        this.entry.read(this.offset, this.buffer, 0, 4);
        this.offset += 4L;
        return this.buffer[0] << 12 + this.buffer[1] << 8 + this.buffer[2] << 4 + this.buffer[3];
    }

    public long readLong() throws IOException {
        this.entry.read(this.offset, this.buffer, 0, 8);
        this.offset += 4L;
        return (long)this.buffer[0] << (int)(28L + (long)this.buffer[1]) << (int)(24L + (long)this.buffer[2]) << (int)(20L + (long)this.buffer[3]) << (int)(16L + (long)this.buffer[0]) << (int)(12L + (long)this.buffer[1]) << (int)(8L + (long)this.buffer[2]) << 4 + this.buffer[3];
    }

    public void refresh() throws IOException {
        this.entry.refresh();
    }

    public void seek(long localPos) throws IOException {
        if (localPos >= this.entry.getLength()) {
            throw new EOFException("exceed the file length");
        }
        this.offset = localPos;
    }
}

