/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.rcp.gui;

import java.util.ArrayList;
import javax.swing.UIManager;
import javax.swing.tree.TreeNode;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.rcp.gui.AperiActionFactory;
import org.eclipse.aperi.rcp.gui.GuiMainPanel;
import org.eclipse.aperi.rcp.gui.StatusLineContribution;
import org.eclipse.aperi.rcp.gui.actions.ChangeLookAndFeelAction;
import org.eclipse.aperi.rcp.gui.actions.CloseAllAction;
import org.eclipse.aperi.rcp.gui.actions.ShowDDIAction;
import org.eclipse.aperi.rcp.gui.actions.ShowDashAction;
import org.eclipse.aperi.rcp.gui.extensions.MenuExtensionMgr;
import org.eclipse.aperi.util.extensions.ExtensionException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private static final String FILE_MENU_LABEL = "&File";
    private static final String FILE_MENU_ID = "file";
    private static final String VIEW_MENU_LABEL = "&View";
    private static final String VIEW_MENU_ID = "view";
    private static final String PREFERENCES_MENU_LABEL = "&Preferences";
    private static final String PREFERENCES_MENU_ID = "preferences";
    private static final String LOOKANDFEEL_MENU_LABEL = "&Look and Feel";
    private static final String LOOKANDFEEL_MENU_ID = "look_and_feel";
    private static final String WINDOW_MENU_LABEL = "&Window";
    private static final String WINDOW_MENU_ID = "window";
    private static final String WINDOW_LIST_MENU_LABEL = "&Show Window List";
    private static final String WINDOW_LIST_MENU_ID = "show_window_list";
    private static final String HELP_MENU_LABEL = "&Help";
    private static final String HELP_MENU_ID = "help";
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction loginAction;
    private ActionFactory.IWorkbenchAction cancelAction;
    private ActionFactory.IWorkbenchAction backAction;
    private ActionFactory.IWorkbenchAction forwardAction;
    private ActionFactory.IWorkbenchAction stopAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction showDashAction;
    private ActionFactory.IWorkbenchAction viewTreeAction;
    private ActionFactory.IWorkbenchAction viewTreeCurrentAction;
    private ActionFactory.IWorkbenchAction editPrefAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAsAction;
    private ActionFactory.IWorkbenchAction exportDataAction;
    private ActionFactory.IWorkbenchAction printTreeAction;
    private ActionFactory.IWorkbenchAction refreshAlertsAction;
    private ActionFactory.IWorkbenchAction helpDirAction;
    private ActionFactory.IWorkbenchAction helpCSAction;
    private IWorkbenchWindow window;
    private ArrayList toolbarActions = new ArrayList();
    private static StatusLineContribution statusContribution;
    private IContributionItem perspectiveMenu;

    public ApplicationActionBarAdvisor(IActionBarConfigurer iActionBarConfigurer) {
        super(iActionBarConfigurer);
        this.window = iActionBarConfigurer.getWindowConfigurer().getWindow();
    }

    protected void makeActions(IWorkbenchWindow iWorkbenchWindow) {
        this.exitAction = AperiActionFactory.getAperiActionFactory().getExitAction(iWorkbenchWindow);
        this.register((IAction)this.exitAction);
        this.aboutAction = AperiActionFactory.getAperiActionFactory().getAboutAction(iWorkbenchWindow);
        this.register((IAction)this.aboutAction);
        this.loginAction = AperiActionFactory.getAperiActionFactory().getLoginAction(iWorkbenchWindow);
        this.register((IAction)this.loginAction);
        this.cancelAction = AperiActionFactory.getAperiActionFactory().getCancelAction(iWorkbenchWindow);
        this.register((IAction)this.cancelAction);
        this.backAction = AperiActionFactory.getAperiActionFactory().getBackwardAction(iWorkbenchWindow);
        this.register((IAction)this.backAction);
        this.forwardAction = AperiActionFactory.getAperiActionFactory().getForwardAction(iWorkbenchWindow);
        this.register((IAction)this.forwardAction);
        this.stopAction = AperiActionFactory.getAperiActionFactory().getStopAction(iWorkbenchWindow);
        this.stopAction.setEnabled(false);
        this.register((IAction)this.stopAction);
        this.viewTreeAction = AperiActionFactory.getAperiActionFactory().getViewTreeAction(iWorkbenchWindow);
        this.register((IAction)this.viewTreeAction);
        this.viewTreeCurrentAction = AperiActionFactory.getAperiActionFactory().getViewTreeCurrentAction(iWorkbenchWindow);
        this.register((IAction)this.viewTreeCurrentAction);
        this.editPrefAction = AperiActionFactory.getAperiActionFactory().getEditPrefAction(iWorkbenchWindow);
        this.register((IAction)this.editPrefAction);
        this.showDashAction = AperiActionFactory.getAperiActionFactory().getShowDashAction(iWorkbenchWindow);
        this.register((IAction)this.showDashAction);
        this.closeAllAction = AperiActionFactory.getAperiActionFactory().getCloseAllAction(iWorkbenchWindow);
        this.register((IAction)this.closeAllAction);
        this.saveAction = AperiActionFactory.getAperiActionFactory().getSaveAction(iWorkbenchWindow);
        this.saveAction.setEnabled(false);
        this.register((IAction)this.saveAction);
        this.saveAsAction = AperiActionFactory.getAperiActionFactory().getSaveAsAction(iWorkbenchWindow);
        this.saveAsAction.setEnabled(false);
        this.register((IAction)this.saveAsAction);
        this.exportDataAction = AperiActionFactory.getAperiActionFactory().getExportDataAction(iWorkbenchWindow);
        this.exportDataAction.setEnabled(false);
        this.register((IAction)this.exportDataAction);
        this.printTreeAction = AperiActionFactory.getAperiActionFactory().getPrintTreeAction(iWorkbenchWindow);
        this.register((IAction)this.printTreeAction);
        this.refreshAlertsAction = AperiActionFactory.getAperiActionFactory().getRefreshAlertsAction(iWorkbenchWindow);
        this.register((IAction)this.refreshAlertsAction);
        this.helpDirAction = AperiActionFactory.getAperiActionFactory().getHelpDirAction(iWorkbenchWindow);
        this.register((IAction)this.helpDirAction);
        this.helpCSAction = AperiActionFactory.getAperiActionFactory().getHelpCSAction(iWorkbenchWindow);
        this.register((IAction)this.helpCSAction);
        statusContribution = new StatusLineContribution("statusline_combo");
        this.perspectiveMenu = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(iWorkbenchWindow);
    }

    protected void fillMenuBar(IMenuManager iMenuManager) {
        ChangeLookAndFeelAction changeLookAndFeelAction;
        String string;
        MenuManager menuManager = new MenuManager(FILE_MENU_LABEL, FILE_MENU_ID);
        menuManager.add((IAction)this.loginAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.saveAction);
        menuManager.add((IAction)this.saveAsAction);
        menuManager.add((IAction)this.exportDataAction);
        menuManager.add((IAction)this.printTreeAction);
        menuManager.add((IAction)this.refreshAlertsAction);
        menuManager.add((IAction)this.cancelAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.exitAction);
        MenuManager menuManager2 = new MenuManager(VIEW_MENU_LABEL, VIEW_MENU_ID);
        menuManager2.add((IAction)this.viewTreeAction);
        menuManager2.add((IAction)this.viewTreeCurrentAction);
        menuManager2.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
                if (dataDisplayInfo == null) {
                    return;
                }
                BaseTreeNode baseTreeNode = dataDisplayInfo.treeNode;
                if (baseTreeNode == null) {
                    return;
                }
                TreeNode[] treeNodeArray = BaseTree.MyTree.getPathToRoot((TreeNode)baseTreeNode);
                if (treeNodeArray == null || treeNodeArray.length == 0) {
                    return;
                }
                if (treeNodeArray[0] == (TreeNode)BaseTree.MyTree.getRoot()) {
                    GuiMainPanel.selectedNode = baseTreeNode;
                }
            }
        });
        MenuManager menuManager3 = new MenuManager(PREFERENCES_MENU_LABEL, PREFERENCES_MENU_ID);
        menuManager3.add((IAction)this.editPrefAction);
        MenuManager menuManager4 = new MenuManager(LOOKANDFEEL_MENU_LABEL, LOOKANDFEEL_MENU_ID);
        menuManager3.add((IContributionItem)menuManager4);
        String string2 = GuiMainPanel.getSystemLAF();
        boolean bl = false;
        String string3 = System.getProperty("os.name", " ");
        if (string3.regionMatches(true, 0, "win", 0, 3)) {
            bl = true;
        }
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = 0;
        while (n < lookAndFeelInfoArray.length) {
            string = lookAndFeelInfoArray[n].getName();
            if (string != null && (bl || !string.equalsIgnoreCase("windows"))) {
                boolean bl2 = false;
                if (string2.equals(lookAndFeelInfoArray[n].getClassName())) {
                    bl2 = true;
                }
                changeLookAndFeelAction = new ChangeLookAndFeelAction(this.window, string, lookAndFeelInfoArray[n].getClassName());
                this.register((IAction)changeLookAndFeelAction);
                menuManager4.add((IAction)changeLookAndFeelAction);
                changeLookAndFeelAction.setChecked(bl2);
            }
            ++n;
        }
        MenuManager menuManager5 = new MenuManager(WINDOW_MENU_LABEL, WINDOW_MENU_ID);
        menuManager5.add((IAction)this.closeAllAction);
        menuManager5.add((IAction)this.showDashAction);
        string = new MenuManager(WINDOW_LIST_MENU_LABEL, WINDOW_LIST_MENU_ID);
        menuManager5.add((IContributionItem)string);
        MenuManager menuManager6 = new MenuManager("Perspectives", "Perspectives");
        menuManager6.add(this.perspectiveMenu);
        menuManager5.add((IContributionItem)menuManager6);
        menuManager5.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                int n = 0;
                IMenuManager iMenuManager2 = iMenuManager.findMenuUsingPath(ApplicationActionBarAdvisor.WINDOW_LIST_MENU_ID);
                iMenuManager2.removeAll();
                DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getRoot();
                while (dataDisplayInfo != null) {
                    ShowDDIAction showDDIAction = new ShowDDIAction(ApplicationActionBarAdvisor.this.window, dataDisplayInfo.getDescription(), n++);
                    ApplicationActionBarAdvisor.this.register((IAction)showDDIAction);
                    iMenuManager2.add((IAction)showDDIAction);
                    dataDisplayInfo = dataDisplayInfo.getNext();
                }
            }
        });
        changeLookAndFeelAction = new MenuManager(HELP_MENU_LABEL, HELP_MENU_ID);
        changeLookAndFeelAction.add((IAction)this.helpDirAction);
        changeLookAndFeelAction.add((IAction)this.helpCSAction);
        changeLookAndFeelAction.add((IAction)this.aboutAction);
        iMenuManager.add((IContributionItem)menuManager);
        iMenuManager.add((IContributionItem)menuManager2);
        iMenuManager.add((IContributionItem)menuManager3);
        MenuExtensionMgr menuExtensionMgr = new MenuExtensionMgr();
        String[] stringArray = menuExtensionMgr.getAllExtensionIds();
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string4 = null;
            try {
                ArrayList arrayList = menuExtensionMgr.getMenuPathRoots(stringArray[n2]);
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    string4 = (String)arrayList.get(n3);
                    iMenuManager.add((IContributionItem)new GroupMarker(string4));
                    ++n3;
                }
            }
            catch (ExtensionException extensionException) {
                extensionException.printStackTrace();
            }
            ++n2;
        }
        iMenuManager.add((IContributionItem)menuManager5);
        iMenuManager.add((IContributionItem)new GroupMarker("window_menu_addition"));
        iMenuManager.add((IContributionItem)changeLookAndFeelAction);
    }

    protected void fillCoolBar(ICoolBarManager iCoolBarManager) {
        ToolBarManager toolBarManager = new ToolBarManager(iCoolBarManager.getStyle() | 0x400);
        toolBarManager.add((IAction)this.backAction);
        toolBarManager.add((IAction)this.forwardAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.saveAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.cancelAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.stopAction);
        toolBarManager.add((IContributionItem)new Separator("additions"));
        int n = 0;
        while (n < this.toolbarActions.size()) {
            toolBarManager.add((IAction)((Action)this.toolbarActions.get(n)));
            ++n;
        }
        iCoolBarManager.add((IToolBarManager)toolBarManager);
        MenuExtensionMgr menuExtensionMgr = new MenuExtensionMgr();
        String[] stringArray = menuExtensionMgr.getAllExtensionIds();
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = null;
            try {
                ArrayList arrayList = menuExtensionMgr.getMenuPathRoots(stringArray[n2]);
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    string = (String)arrayList.get(n3);
                    iCoolBarManager.add((IContributionItem)new Separator(string));
                    ++n3;
                }
            }
            catch (ExtensionException extensionException) {
                extensionException.printStackTrace();
            }
            ++n2;
        }
    }

    protected void fillStatusLine(IStatusLineManager iStatusLineManager) {
        iStatusLineManager.add((IContributionItem)statusContribution);
    }

    public static void updateStatusLine(final String string, final String string2) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (statusContribution != null) {
                    statusContribution.setText(string);
                    statusContribution.setTooltip(string2);
                }
            }
        });
    }

    public void setActionEnabled(String string, boolean bl) {
        if (string.equals("org.eclipse.aperi.rcp.gui.actions.login")) {
            this.loginAction.setEnabled(bl);
        } else if (string.equals("org.eclipse.aperi.rcp.gui.actions.saveaction")) {
            this.saveAction.setEnabled(bl);
        } else if (string.equals("org.eclipse.aperi.rcp.gui.actions.saveasaction")) {
            this.saveAsAction.setEnabled(bl);
        } else if (string.equals("org.eclipse.aperi.rcp.gui.actions.backaction")) {
            this.backAction.setEnabled(bl);
        } else if (string.equals("org.eclipse.aperi.rcp.gui.actions.forwardaction")) {
            this.forwardAction.setEnabled(bl);
        } else if (string.equals("org.eclipse.aperi.rcp.gui.actions.closeaction")) {
            this.cancelAction.setEnabled(bl);
        } else if (string.equals("org.eclipse.aperi.rcp.gui.actions.stopaction")) {
            this.stopAction.setEnabled(bl);
        } else if (string.equals("org.eclipse.aperi.rcp.gui.actions.exportDataAction")) {
            this.exportDataAction.setEnabled(bl);
        } else if (string.equals(ShowDashAction.ID)) {
            this.showDashAction.setEnabled(bl);
        } else if (string.equals(CloseAllAction.ID)) {
            this.closeAllAction.setEnabled(bl);
        }
    }

    public void setActionToolTipText(String string, String string2) {
        if (string.equals("org.eclipse.aperi.rcp.gui.actions.saveaction")) {
            this.saveAction.setToolTipText(string2);
        } else if (string.equals("org.eclipse.aperi.rcp.gui.actions.saveasaction")) {
            this.saveAsAction.setToolTipText(string2);
        } else if (string.equals("org.eclipse.aperi.rcp.gui.actions.backaction")) {
            this.backAction.setToolTipText(string2);
        } else if (string.equals("org.eclipse.aperi.rcp.gui.actions.forwardaction")) {
            this.forwardAction.setToolTipText(string2);
        } else if (string.equals("org.eclipse.aperi.rcp.gui.actions.closeaction")) {
            this.cancelAction.setToolTipText(string2);
        } else if (string.equals("org.eclipse.aperi.rcp.gui.actions.stopaction")) {
            this.stopAction.setToolTipText(string2);
        } else if (string.equals("org.eclipse.aperi.rcp.gui.actions.exportDataAction")) {
            this.exportDataAction.setToolTipText(string2);
        }
    }
}

