/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.rcp.gui;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public class StatusLineContribution
extends ContributionItem {
    public static final int DEFAULT_CHAR_WIDTH = 80;
    private CCombo combo;
    private String text;
    private int widthHint = -1;
    private int heightHint = -1;
    private Listener listener;
    private int eventType;
    private String tooltip;

    public StatusLineContribution(String string) {
        this(string, 80);
    }

    public StatusLineContribution(String string, int n) {
        super(string);
        this.widthHint = n;
        this.setVisible(false);
    }

    public void fill(Composite composite) {
        Label label = new Label(composite, 2);
        this.combo = new CCombo(composite, 16);
        this.combo.setVisibleItemCount(10);
        this.combo.setEditable(false);
        this.combo.setText(this.text);
        this.combo.add(this.text);
        GC gC = new GC((Drawable)composite);
        gC.setFont(composite.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        Point point = gC.textExtent(this.text);
        this.widthHint = this.widthHint > 0 ? fontMetrics.getAverageCharWidth() * this.widthHint : point.x;
        this.heightHint = fontMetrics.getHeight();
        gC.dispose();
        StatusLineLayoutData statusLineLayoutData = new StatusLineLayoutData();
        statusLineLayoutData.widthHint = this.widthHint;
        statusLineLayoutData.heightHint = this.heightHint;
        this.combo.setLayoutData((Object)statusLineLayoutData);
        if (this.listener != null) {
            this.combo.addListener(this.eventType, this.listener);
        }
        if (this.tooltip != null) {
            this.combo.setToolTipText(this.tooltip);
        }
        statusLineLayoutData = new StatusLineLayoutData();
        statusLineLayoutData.heightHint = this.heightHint;
        label.setLayoutData((Object)statusLineLayoutData);
    }

    public void addListener(int n, Listener listener) {
        this.eventType = n;
        this.listener = listener;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.text = string;
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.setText(this.text);
            this.combo.add(this.text);
        }
        if (this.text.length() == 0) {
            if (this.isVisible()) {
                this.setVisible(false);
                IContributionManager iContributionManager = this.getParent();
                if (iContributionManager != null) {
                    iContributionManager.update(true);
                }
            }
        } else if (!this.isVisible()) {
            this.setVisible(true);
            IContributionManager iContributionManager = this.getParent();
            if (iContributionManager != null) {
                iContributionManager.update(true);
            }
        }
    }

    public void setTooltip(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.tooltip = string;
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.setToolTipText(this.tooltip);
        }
    }
}

