/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.datafeed;

import org.eclipse.birt.chart.datafeed.IResultSetDataSet;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.util.ChartUtil;

public class UserDataSetProcessor {
    public DataSet[] populate(Object oResultSetDef) throws ChartException {
        DataSet[] ds = new DataSet[]{};
        if (oResultSetDef instanceof IResultSetDataSet) {
            IResultSetDataSet rsds = (IResultSetDataSet)oResultSetDef;
            long lRowCount = rsds.getSize();
            if (lRowCount <= 0L) {
                throw new ChartException("org.eclipse.birt.chart.engine", 16, "exception.empty.dataset", Messages.getResourceBundle());
            }
            int columnCount = rsds.getColumnCount();
            ds = new DataSet[columnCount];
            String[][] saDataSet = new String[columnCount][(int)lRowCount];
            int i = 0;
            while (rsds.hasNext()) {
                Object[] nextRow = rsds.next();
                for (int k = 0; k < columnCount; ++k) {
                    saDataSet[k][i] = ChartUtil.stringValue(nextRow[k]);
                }
                ++i;
            }
            for (int k = 0; k < columnCount; ++k) {
                ds[k] = TextDataSetImpl.create(saDataSet[k]);
            }
        } else {
            throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.unknown.custom.dataset", Messages.getResourceBundle());
        }
        return ds;
    }
}

