/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.tape.collection;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.discovery.AssociatorCIMQuery;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.DiscoverStep;
import org.eclipse.aperi.discovery.IProgressLogger;
import org.eclipse.aperi.discovery.ProgressLogger;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeMediaLocationTable;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.tape.TapeManagerConstants;
import org.eclipse.aperi.tape.TapeReportingService;
import org.eclipse.aperi.tape.collection.TapeCIMProcessor;

public abstract class ProbeGenericTapeLibraryProcess
extends DiscoverProcess
implements TapeManagerConstants {
    private static final String QUERY_SLOTS = "select count(*) from t_res_tape_media_location where location_type=2 and tape_library_id=?";
    protected static final String COLLECTDRIVESROMCOMPUTERSYSTEM = "collectDrivesFromComputerSystem";
    protected static final String COLLECTCHASSISFROMCOMPUTERSYSTEM = "collectChassisFromComputerSystem";
    protected static final String COLLECTLIMITEDACCESSPORTSFROMCOMPUTERSYSTEM = "collectLimitedAccessPortsFromComputerSystem";
    protected static final String COLLECTCHANGERDEVICESFROMCOMPUTERSYSTEM = "collectChangerDevicesFromComputerSystem";
    protected static final String COLLECTREMOTESERVICEACCESSPOINTFROMCOMPUTERSYSTEM = "collectRemoteServiceAccessPointFromComputerSystem";
    protected static final String COLLECTSOFTWAREIDENTITYFROMCOMPUTERSYSTEM = "collectSoftwareIdentityFromComputerSystem";
    protected static final String COLLECTCONTROLLERFROMCOMPUTERSYSTEM = "collectControllerFromComputerSystem";
    protected static final String COLLECTFCPORTSFROMCOMPUTERSYSTEM = "collectFCPortsFromComputerSystem";
    protected static final String COLLECTFCPORTSFROMCONTROLLER = "collectFCPortsFromController";
    protected static final String COLLECTCONTROLLERSFROMDRIVES = "collectControllersFromDrives";
    protected static final String COLLECTCONTROLLERSFROMCHANGERDEVICE = "collectControllersFromChangerDevice";
    protected static final String COLLECTSOFTWAREIDENTITYFROMDRIVES = "collectSoftwareIdentityFromDrives";
    protected static final String COLLECTSOFTWAREIDENTITYFROMCHANGERDEVICE = "collectSoftwareIdentityFromChangerDevice";
    protected static final String COLLECTSTORAGEMEDIALOCATIONFORDRIVES = "collectStorageMediaLocationForDrives";
    protected static final String COLLECTSTORAGEMEDIALOCATIONFORLIMITEDACCESSPORTS = "collectStorageMediaLocationForLimitedAccessPorts";
    protected static final String COLLECTSTORAGEMEDIALOCATIONFORCHANGERDEVICES = "collectStorageMediaLocationForChangerDevices";
    protected static final String COLLECTCONTROLLERFROMCHANGERDEVICE = "collectControllerFromChangerDevice";
    protected static final String COLLECTCARTRIDGESFORCHASSIS = "collectCartridgesFromChassis";
    protected static final String COLLECTSTORAGEMEDIALOCATIONFORCARTRIDGES = "collectStorageMediaLocationForCartridges";
    protected static final String COLLECTSTORAGEMEDIALOCATIONFROMLIMITEDACCESSPORTS = "collectStorageMediaLocationForLimitedAccessPorts";
    protected static final String COLLECTMAGAZINESFROMCHASSIS = "collectMagazinesFromChassis";
    protected static final String COLLECTSTORAGEMEDIALOCATIONFROMCHASSIS = "collectStorageMediaLocationFromChassis";
    protected static final String COLLECTSTORAGEMEDIALOCATIONFROMMAGAZINE = "collectStorageMediaLocationFromMagazine";
    protected static final String MESSAGE_NAME = "aperi.logger.message.TapeManager";
    protected static final String TRACE_NAME = "aperi.logger.trace.TapeManager";
    protected static ILogger msgLogger = null;
    protected static ILogger traceLogger = null;
    public static String COMPUTERSYSTEM = "COMPUTERSYSTEM";
    public static String CHASSIS = "CHASSIS";
    public static String CARTRIDGE = "CARTRIDGE";
    public static String PHYSICALPACKAGE = "PHYSICALPACKAGE";
    public static String SCSIPROTOCOLCONTROLLER = "SCSIPROTOCOLCONTROLLER";
    public static String MEDIAACCESSDEVICE = "MEDIAACCESSDEVICE";
    public static String SOFTWAREIDENTITY = "SOFTWAREIDENTITY";
    public static String STORAGEMEDIALOCATION = "STORAGEMEDIALOCATION";
    public static String CHANGERDEVICE = "CHANGERDEVICE";
    public static String LIMITEDACCESSPORT = "LIMITEDACCESSPORT";
    public static String PHYSICALTAPE = "PHYSICALTAPE";
    public static String MAGAZINE = "MAGAZINE";

    public static void addLegacyDiscoverProcess(IDiscoverRouterService iDiscoverRouterService) {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        Class<?> clazz9;
        Class<?> clazz10;
        Class<?> clazz11;
        Class<?> clazz12;
        Class<?> clazz13;
        Class<?> clazz14;
        Class<?> clazz15;
        Class<?> clazz16;
        Class<?> clazz17;
        Class<?> clazz18;
        Class<?> clazz19;
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        try {
            clazz19 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTCHASSISFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect Chassis From ComputerSystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_ComputerSystemPackage", (String)"CIM_Chassis", null, null), "IN_SYSTEM_" + COMPUTERSYSTEM, clazz19.getName(), false));
        try {
            clazz18 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTCARTRIDGESFORCHASSIS, (IDiscoverProcess)new AssociatorCIMQuery("Collect Cartridges From Chassis", Query.associators((String)"CIM_Chassis", (String)"CIM_PackagedComponent", (String)"CIM_PhysicalTape", null, null), "IN_SYSTEM_" + CHASSIS, clazz18.getName(), false));
        try {
            clazz17 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTSTORAGEMEDIALOCATIONFORCARTRIDGES, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageMediaLocation From Cartridge", Query.associators((String)"CIM_PhysicalTape", (String)"CIM_PhysicalMediaInLocation", (String)"CIM_StorageMediaLocation", null, null), "IN_SYSTEM_" + PHYSICALTAPE, clazz17.getName(), false));
        try {
            clazz16 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTREMOTESERVICEACCESSPOINTFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect RemoteServiceAccessPoint From ComputerSystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SAPAvailableForElement", (String)"CIM_RemoteServiceAccessPoint", null, null), "IN_SYSTEM_" + COMPUTERSYSTEM, clazz16.getName(), false));
        try {
            clazz15 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTSOFTWAREIDENTITYFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect SoftwareIdentity From ComputerSystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_InstalledSoftwareIdentity", (String)"CIM_SoftwareIdentity", null, null), "IN_SYSTEM_" + COMPUTERSYSTEM, clazz15.getName(), false));
        try {
            clazz14 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTDRIVESROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect Drives From ComputerSystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_MediaAccessDevice", null, null), "IN_SYSTEM_" + COMPUTERSYSTEM, clazz14.getName(), false));
        try {
            clazz13 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTSTORAGEMEDIALOCATIONFORDRIVES, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageMediaLocation For Drives", Query.associators((String)"CIM_MediaAccessDevice", (String)"CIM_Realizes", (String)"CIM_StorageMediaLocation", null, null), "IN_SYSTEM_" + MEDIAACCESSDEVICE, clazz13.getName(), false));
        try {
            clazz12 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTSOFTWAREIDENTITYFROMDRIVES, (IDiscoverProcess)new AssociatorCIMQuery("Collect SoftwareIdentity From Drives", Query.associators((String)"CIM_MediaAccessDevice", (String)"CIM_ElementSoftwareIdentity", (String)"CIM_SoftwareIdentity", null, null), "IN_SYSTEM_" + MEDIAACCESSDEVICE, clazz12.getName(), false));
        try {
            clazz11 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTCONTROLLERSFROMDRIVES, (IDiscoverProcess)new AssociatorCIMQuery("Collect Controllers From Drives", Query.associators((String)"CIM_MediaAccessDevice", (String)"CIM_ProtocolControllerForUnit", (String)"CIM_SCSIProtocolController", null, null), "IN_SYSTEM_" + MEDIAACCESSDEVICE, clazz11.getName(), false));
        try {
            clazz10 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTFCPORTSFROMCONTROLLER, (IDiscoverProcess)new AssociatorCIMQuery("Collect Ports From Controllers", Query.associators((String)"CIM_SCSIProtocolController", (String)"CIM_ProtocolControllerForPort", (String)"CIM_FCPort", null, null), "IN_SYSTEM_" + SCSIPROTOCOLCONTROLLER, clazz10.getName(), false));
        try {
            clazz9 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTCHANGERDEVICESFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect ChangerDevice From ComputerSystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_ChangerDevice", null, null), "IN_SYSTEM_" + COMPUTERSYSTEM, clazz9.getName(), false));
        try {
            clazz8 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTSTORAGEMEDIALOCATIONFORCHANGERDEVICES, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageMediaLocation For ChangerDevices", Query.associators((String)"CIM_ChangerDevice", (String)"CIM_Realizes", (String)"CIM_StorageMediaLocation", null, null), "IN_SYSTEM_" + CHANGERDEVICE, clazz8.getName(), false));
        try {
            clazz7 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTSOFTWAREIDENTITYFROMCHANGERDEVICE, (IDiscoverProcess)new AssociatorCIMQuery("Collect SoftwareIdentity From ChangerDevice", Query.associators((String)"CIM_ChangerDevice", (String)"CIM_ElementSoftwareIdentity", (String)"CIM_SoftwareIdentity", null, null), "IN_SYSTEM_" + CHANGERDEVICE, clazz7.getName(), false));
        try {
            clazz6 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTCONTROLLERSFROMCHANGERDEVICE, (IDiscoverProcess)new AssociatorCIMQuery("Collect Controllers From ChangerDevice", Query.associators((String)"CIM_ChangerDevice", (String)"CIM_ProtocolControllerForUnit", (String)"CIM_SCSIProtocolController", null, null), "IN_SYSTEM_" + CHANGERDEVICE, clazz6.getName(), false));
        try {
            clazz5 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTLIMITEDACCESSPORTSFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect Limited Access Port From ComputerSystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_LimitedAccessPort", null, null), "IN_SYSTEM_" + COMPUTERSYSTEM, clazz5.getName(), false));
        try {
            clazz4 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess("collectStorageMediaLocationForLimitedAccessPorts", (IDiscoverProcess)new AssociatorCIMQuery("Collect Storage Media Location From Limited Access Port", Query.associators((String)"CIM_LimitedAccessPort", (String)"CIM_Realizes", (String)"CIM_StorageMediaLocation", null, null), "IN_SYSTEM_" + LIMITEDACCESSPORT, clazz4.getName(), false));
        try {
            clazz3 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTSTORAGEMEDIALOCATIONFROMCHASSIS, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageMediaLocation from Chassis", Query.associators((String)"CIM_Chassis", (String)"CIM_Container", (String)"CIM_StorageMediaLocation", null, null), "IN_SYSTEM_" + CHASSIS, clazz3.getName(), false));
        try {
            clazz2 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTMAGAZINESFROMCHASSIS, (IDiscoverProcess)new AssociatorCIMQuery("Collect Magazines from Chassis", Query.associators((String)"CIM_Chassis", (String)"CIM_Container", (String)"CIM_Magazine", null, null), "IN_SYSTEM_" + CHASSIS, clazz2.getName(), false));
        try {
            clazz = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTSTORAGEMEDIALOCATIONFROMMAGAZINE, (IDiscoverProcess)new AssociatorCIMQuery("Collect Storage Media Location from Magazine", Query.associators((String)"CIM_Magazine", (String)"CIM_Container", (String)"CIM_StorageMediaLocation", null, null), "IN_SYSTEM_" + MAGAZINE, clazz.getName(), false));
    }

    public ProbeGenericTapeLibraryProcess(String string, boolean bl, String[] stringArray, String[] stringArray2) {
        super(string, bl, stringArray, stringArray2);
    }

    public DiscoverStep getStepCollectStorageMediaLocationsFromComputerSystem(TapeCIMProcessor tapeCIMProcessor, ProgressLogger progressLogger) {
        progressLogger.enableHierarchicalMode();
        DiscoverStep discoverStep = new DiscoverStep(COLLECTCHASSISFROMCOMPUTERSYSTEM, "IN_SYSTEM_" + CHASSIS, (CIMProcessor)tapeCIMProcessor, (IProgressLogger)progressLogger);
        DiscoverStep discoverStep2 = new DiscoverStep(COLLECTSTORAGEMEDIALOCATIONFROMCHASSIS, "IN_SYSTEM_" + STORAGEMEDIALOCATION, (CIMProcessor)tapeCIMProcessor, (IProgressLogger)new ProgressLogger.InnerProgressLogger(progressLogger));
        DiscoverStep discoverStep3 = new DiscoverStep(COLLECTMAGAZINESFROMCHASSIS, "IN_SYSTEM_" + MAGAZINE, (CIMProcessor)tapeCIMProcessor);
        DiscoverStep discoverStep4 = new DiscoverStep(COLLECTSTORAGEMEDIALOCATIONFROMMAGAZINE, null, (CIMProcessor)tapeCIMProcessor, (IProgressLogger)new ProgressLogger.InnerProgressLogger(progressLogger));
        discoverStep.addNextStep((IStep)discoverStep3);
        discoverStep.addNextStep((IStep)discoverStep2);
        discoverStep3.addNextStep((IStep)discoverStep4);
        return discoverStep;
    }

    public DiscoverStep getStepCollectCartridgesFromComputerSystem(TapeCIMProcessor tapeCIMProcessor, ProgressLogger progressLogger) {
        progressLogger.enableHierarchicalMode();
        DiscoverStep discoverStep = new DiscoverStep(COLLECTCHASSISFROMCOMPUTERSYSTEM, "IN_SYSTEM_" + CHASSIS, (CIMProcessor)tapeCIMProcessor, (IProgressLogger)progressLogger);
        DiscoverStep discoverStep2 = new DiscoverStep(COLLECTCARTRIDGESFORCHASSIS, "IN_SYSTEM_" + PHYSICALTAPE, (CIMProcessor)tapeCIMProcessor, (IProgressLogger)new ProgressLogger.InnerProgressLogger(progressLogger));
        DiscoverStep discoverStep3 = new DiscoverStep(COLLECTSTORAGEMEDIALOCATIONFORCARTRIDGES, null, (CIMProcessor)tapeCIMProcessor);
        discoverStep.addNextStep((IStep)discoverStep2);
        discoverStep2.addNextStep((IStep)discoverStep3);
        return discoverStep;
    }

    public DiscoverStep getStepCollectDrivesFromComputerSystem(TapeCIMProcessor tapeCIMProcessor, ProgressLogger progressLogger) {
        DiscoverStep discoverStep = new DiscoverStep(COLLECTDRIVESROMCOMPUTERSYSTEM, "IN_SYSTEM_" + MEDIAACCESSDEVICE, (CIMProcessor)tapeCIMProcessor, (IProgressLogger)progressLogger);
        DiscoverStep discoverStep2 = new DiscoverStep(COLLECTSTORAGEMEDIALOCATIONFORDRIVES, null, (CIMProcessor)tapeCIMProcessor);
        DiscoverStep discoverStep3 = new DiscoverStep(COLLECTSOFTWAREIDENTITYFROMDRIVES, null, (CIMProcessor)tapeCIMProcessor);
        DiscoverStep discoverStep4 = new DiscoverStep(COLLECTCONTROLLERSFROMDRIVES, "IN_SYSTEM_" + SCSIPROTOCOLCONTROLLER, null);
        DiscoverStep discoverStep5 = new DiscoverStep(COLLECTFCPORTSFROMCONTROLLER, "IN_SYSTEM_" + SCSIPROTOCOLCONTROLLER, (CIMProcessor)tapeCIMProcessor);
        discoverStep.addNextStep((IStep)discoverStep2);
        discoverStep.addNextStep((IStep)discoverStep3);
        discoverStep.addNextStep((IStep)discoverStep4);
        discoverStep4.addNextStep((IStep)discoverStep5);
        return discoverStep;
    }

    public DiscoverStep getStepCollectChangerDeviceFromComputerSystem(TapeCIMProcessor tapeCIMProcessor, ProgressLogger progressLogger) {
        DiscoverStep discoverStep = new DiscoverStep(COLLECTCHANGERDEVICESFROMCOMPUTERSYSTEM, "IN_SYSTEM_" + CHANGERDEVICE, (CIMProcessor)tapeCIMProcessor, (IProgressLogger)progressLogger);
        DiscoverStep discoverStep2 = new DiscoverStep(COLLECTSTORAGEMEDIALOCATIONFORCHANGERDEVICES, null, (CIMProcessor)tapeCIMProcessor);
        DiscoverStep discoverStep3 = new DiscoverStep(COLLECTSOFTWAREIDENTITYFROMCHANGERDEVICE, null, (CIMProcessor)tapeCIMProcessor);
        DiscoverStep discoverStep4 = new DiscoverStep(COLLECTCONTROLLERSFROMCHANGERDEVICE, "IN_SYSTEM_" + SCSIPROTOCOLCONTROLLER, (CIMProcessor)tapeCIMProcessor);
        DiscoverStep discoverStep5 = new DiscoverStep(COLLECTFCPORTSFROMCONTROLLER, null, (CIMProcessor)tapeCIMProcessor);
        discoverStep.addNextStep((IStep)discoverStep2);
        discoverStep.addNextStep((IStep)discoverStep3);
        discoverStep.addNextStep((IStep)discoverStep4);
        discoverStep4.addNextStep((IStep)discoverStep5);
        return discoverStep;
    }

    public DiscoverStep getStepCollectLimitedAccessPortFromComputerSystem(TapeCIMProcessor tapeCIMProcessor, ProgressLogger progressLogger) {
        DiscoverStep discoverStep = new DiscoverStep(COLLECTLIMITEDACCESSPORTSFROMCOMPUTERSYSTEM, "IN_SYSTEM_" + LIMITEDACCESSPORT, (CIMProcessor)tapeCIMProcessor, (IProgressLogger)progressLogger);
        DiscoverStep discoverStep2 = new DiscoverStep("collectStorageMediaLocationForLimitedAccessPorts", null, (CIMProcessor)tapeCIMProcessor);
        discoverStep.addNextStep((IStep)discoverStep2);
        return discoverStep;
    }

    public String getScannerId(Map map) throws ParameterException {
        String string = "PT1";
        String[] stringArray = (String[])map.get("CIMOM");
        if (stringArray == null || stringArray.length < 1) {
            throw new ParameterException("Missing parameter: CIMOM");
        }
        String string2 = stringArray[0];
        String string3 = (String)map.get("DEVICEID");
        if (string3 == null) {
            throw new ParameterException("Missing parameter: DEVICEID");
        }
        String string4 = String.valueOf(string) + ":" + string2 + "+" + string3;
        return string4;
    }

    public int getAuthoritativeReferenceType(Map map) throws ParameterException {
        return 2;
    }

    public int getAuthoritativeReferenceId(Map map) throws ParameterException {
        String string = (String)map.get("DEVICEID");
        if (string == null) {
            throw new ParameterException("Missing parameter: DEVICEID");
        }
        return Integer.parseInt(string);
    }

    protected boolean processSteps(ArrayList arrayList, Map map, String string, ILogger iLogger) {
        boolean bl = true;
        int n = Integer.parseInt((String)map.get("DEVICEID"));
        int n2 = 0;
        while (n2 < arrayList.size()) {
            DiscoverStep discoverStep = (DiscoverStep)arrayList.get(n2);
            long l = this.traceBegin(discoverStep.getCmd(), n);
            boolean bl2 = false;
            try {
                bl2 = discoverStep.process(string, map);
            }
            catch (Exception exception) {
                iLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this.getClass().getName(), "processSteps", (Throwable)exception);
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "traceException", "Exception from DiscoverStep's process method" + exception.getStackTrace().toString());
                }
                traceLogger.exception(IRecordType.TYPE_WARN, (Object)this.getClass().getName(), "processSteps", (Throwable)exception);
            }
            this.traceEnd(discoverStep.getCmd(), l, bl2, n);
            bl = bl && bl2;
            ++n2;
        }
        n2 = (Integer)map.get("COLLTYPE");
        if (n2 == 3) {
            this.updateMaxCartridges(map);
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateMaxCartridges(Map map) {
        String string = "updateMaxCartridges";
        String string2 = (String)map.get("TAPELIBRARY");
        String string3 = (String)map.get("DEVICEID");
        try {
            String string4;
            int n;
            DBConnection dBConnection;
            block10: {
                dBConnection = ServiceUtils.getConnection();
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(TResTapeMediaLocationTable.getColumnInfo((String)"TAPE_LIBRARY_ID"), string3);
                DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)QUERY_SLOTS, hashtable);
                n = 0;
                try {
                    while (dBResultSet.next()) {
                        n = dBResultSet.getInt(1);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    if (dBResultSet == null) throw throwable;
                    dBResultSet.close();
                    throw throwable;
                }
                {
                    string4 = null;
                    if (dBResultSet == null) break block10;
                }
                dBResultSet.close();
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), string, "Updated MAX_CARTRIDGES to " + n + " for libId " + string3);
            }
            if (Configuration.debug) {
                System.out.println("*** Max. Cartridges: " + n + ", Library: " + string2);
            }
            string4 = TapeReportingService.getNameFromKey(string2);
            short s = TapeReportingService.getNameFormatFromKey(string2);
            TapeLibrary tapeLibrary = new TapeLibrary();
            tapeLibrary.setName(string4);
            tapeLibrary.setNameFormat(s);
            try {
                tapeLibrary.retrieve(dBConnection);
                tapeLibrary.setMaxCartridges(n);
                tapeLibrary.update(dBConnection);
            }
            catch (SQLException sQLException) {
                traceLogger.exception(IRecordType.TYPE_WARN, (Object)this.getClass().getName(), string, (Throwable)sQLException);
            }
            if (dBConnection == null) return;
            dBConnection.commit();
            dBConnection.close();
            return;
        }
        catch (SQLException sQLException) {
            traceLogger.exception(IRecordType.TYPE_WARN, (Object)this.getClass().getName(), string, (Throwable)sQLException);
        }
    }

    protected long traceBegin(String string, int n) {
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "traceBegin", "===== Starting " + string + " for lib id " + n);
        }
        if (Configuration.debug) {
            System.out.println(String.valueOf(this.getClass().getName()) + ": ===== Starting " + string + " for lib id " + n);
        }
        return System.currentTimeMillis();
    }

    protected void traceEnd(String string, long l, boolean bl, int n) {
        long l2 = System.currentTimeMillis();
        long l3 = (long)Math.floor((double)(l2 - l) / 60000.0);
        if (bl) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "traceEnd", "===== Completed " + string + " for lib id " + n + " after " + (l2 - l) + " ms (" + l3 + " min)");
            }
            if (Configuration.debug) {
                System.out.println(String.valueOf(this.getClass().getName()) + ": ===== Completed " + string + " for lib id " + n + " after " + (l2 - l) + " ms (" + l3 + " min)");
            }
        } else {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "traceEnd", "===== Step " + string + " for lib id " + n + " failed!");
            }
            if (Configuration.debug) {
                System.out.println(String.valueOf(this.getClass().getName()) + ": ===== Step " + string + " for lib id " + n + " failed!");
            }
        }
    }
}

