/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.Serializable;
import org.eclipse.aperi.TStorm.common.ComputerUpTimeAdjuster;
import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.UpTimeReport;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.SpaceHistChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.charting.AperiCustomizableChart;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class ComputerUpTimeGrapher
extends Grapher {
    public int rowChartIcon;
    public static final byte CHART_AVAILABILITY = 101;
    public static final byte CHART_AVAILABILITY_X = 102;
    public static final String GRAPH_AVAILABILITY = "STG7527L";
    public static final String GRAPH_AVAILABILITY_SEL = "STG4121L";
    public static final String GRAPH_AVAILABILITY_ALL = "STG4122L";
    public static final String GRAPH_AVAILABILITY_HIST = "STG4123L";

    public String getChartType(GuiReportReq guiReportReq, ReportDataAdjuster reportDataAdjuster) {
        if (guiReportReq.chartSubtype > 0) {
            return null;
        }
        return MessageLog.getMessageNoID(GRAPH_AVAILABILITY_HIST);
    }

    public int graphsPerPage(GuiReportReq guiReportReq) {
        return 2;
    }

    public AperiChart processBatch(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, ReportDataAdjuster reportDataAdjuster, GuiChartSettingsReq guiChartSettingsReq) {
        AperiChart aperiChart = null;
        this.setIcon(guiReportReq);
        if (guiReportReq.chartSubtype > 0) {
            aperiChart = this.createChart(guiReportReq, objectArray, nArray, reportDataAdjuster, null, guiChartSettingsReq);
        } else {
            GuiReportReq guiReportReq2 = this.createHistory(guiReportReq, objectArray, nArray);
            aperiChart = (AperiChart)new SpaceHistChart().batch(guiReportReq2, guiChartSettingsReq);
        }
        return aperiChart;
    }

    public void setIcon(GuiReportReq guiReportReq) {
        this.rowChartIcon = guiReportReq.reportSubtype == 15 ? 11 : (guiReportReq.reportSubtype == 28 ? 10 : 12);
    }

    public AperiCustomizableChart createChart(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, ReportDataAdjuster reportDataAdjuster, ReportingDDI reportingDDI, GuiChartSettingsReq guiChartSettingsReq) {
        Serializable serializable;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.common.ComputerUpTimeGrapher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "createChart", "grr, pData, rows, pAdjuster, ddi, gcsr");
        }
        UpTimeReport[] upTimeReportArray = (UpTimeReport[])objectArray;
        ComputerUpTimeAdjuster computerUpTimeAdjuster = (ComputerUpTimeAdjuster)reportDataAdjuster;
        Number[][] numberArray = new Number[2][nArray.length];
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[2];
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            serializable = upTimeReportArray[n2];
            numberArray[0][n] = new Long(serializable.crUpTime);
            numberArray[1][n] = new Long(serializable.chDownTime);
            stringArray[n] = this.getRowName(upTimeReportArray, n2, computerUpTimeAdjuster, guiReportReq);
            ++n;
        }
        stringArray2[0] = MessageLog.getMessageNoID("STG4128L");
        stringArray2[1] = MessageLog.getMessageNoID("STG4127L");
        ChartOptions chartOptions = new ChartOptions();
        if (this.rowChartIcon == 12) {
            chartOptions.chartType = 5;
            chartOptions.chartsPerView = 1;
        }
        AperiCustomizableChart aperiCustomizableChart = new AperiCustomizableChart(6, 7, numberArray, stringArray2, stringArray, chartOptions, guiReportReq);
        if (reportingDDI != null) {
            reportingDDI.addChart(guiReportReq, aperiCustomizableChart, "");
        }
        serializable = aperiCustomizableChart;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.common.ComputerUpTimeGrapher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "createChart", serializable);
        }
        return serializable;
    }

    public GuiReportReq createHistory(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.common.ComputerUpTimeGrapher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "createHistory", "grr, pData, rows");
        }
        UpTimeReport[] upTimeReportArray = (UpTimeReport[])objectArray;
        GuiReportReq guiReportReq2 = guiReportReq.explode(-1);
        guiReportReq2.reportSubtype = guiReportReq.reportSubtype;
        guiReportReq2.idSubtype = -1;
        SpaceHistChart.initLegend(guiReportReq2);
        guiReportReq2.selectedResources = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            UpTimeReport upTimeReport = upTimeReportArray[nArray[n]];
            guiReportReq2.selectedResources[n] = upTimeReport.crID;
            SpaceHistChart.addLegend(guiReportReq2, upTimeReport.crName1, upTimeReport.getCrName2(), upTimeReport.crID);
            ++n;
        }
        guiReportReq2.chartLabelType = (byte)8;
        guiReportReq2.histSubtype = (byte)6;
        guiReportReq2.historyTitle = GRAPH_AVAILABILITY_HIST;
        guiReportReq2.reportSubtypeOrig = guiReportReq.reportSubtype;
        guiReportReq2.reportSubtype = 28;
        GuiReportReq guiReportReq3 = guiReportReq2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.common.ComputerUpTimeGrapher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "createHistory", guiReportReq3);
        }
        return guiReportReq3;
    }

    public String getRowName(UpTimeReport[] upTimeReportArray, int n, ComputerUpTimeAdjuster computerUpTimeAdjuster, GuiReportReq guiReportReq) {
        if (guiReportReq.reportSubtype == 82) {
            return upTimeReportArray[n].getCrName2();
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        if (computerUpTimeAdjuster.frozenColumns > 0) {
            stringBuffer.append(upTimeReportArray[n].crName1);
            if (computerUpTimeAdjuster.frozenColumns > 1) {
                stringBuffer.append('.');
                stringBuffer.append(upTimeReportArray[n].getCrName2());
            }
            stringBuffer.append(' ');
            return stringBuffer.toString();
        }
        return MessageLog.getMessageNoID("STG5048L");
    }
}

