/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.Serializable;
import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.PingAdjuster;
import org.eclipse.aperi.TStorm.common.PingReport;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.SpaceHistChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.charting.AperiCustomizableChart;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class PingGrapher
extends Grapher {
    String title;
    public static final byte CHART_AVAILABILITY = 101;
    public static final byte CHART_AVAILABILITY_X = 102;
    public static final String GRAPH_AVAILABILITY_SEL = "STG4121L";
    public static final String GRAPH_AVAILABILITY = "STG7554L";
    public static final String GRAPH_AVAILABILITY_ALL = "STG4122L";
    public static final String GRAPH_AVAILABILITY_HIST = "STG4123L";
    public static final String GRAPH_TRANSIT_TIME_HIST = "STG4124L";

    public String getChartType(GuiReportReq guiReportReq, ReportDataAdjuster reportDataAdjuster) {
        if (guiReportReq.chartSubtype > 0) {
            return null;
        }
        this.title = guiReportReq.histSubtype == 6 ? GRAPH_AVAILABILITY_HIST : GRAPH_TRANSIT_TIME_HIST;
        return MessageLog.getMessageNoID(this.title);
    }

    public int graphsPerPage(GuiReportReq guiReportReq) {
        return 2;
    }

    public AperiChart processBatch(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, ReportDataAdjuster reportDataAdjuster, GuiChartSettingsReq guiChartSettingsReq) {
        AperiChart aperiChart = null;
        if (guiReportReq.chartSubtype > 0) {
            aperiChart = this.createChart(guiReportReq, objectArray, nArray, reportDataAdjuster, null, guiChartSettingsReq);
        } else {
            GuiReportReq guiReportReq2 = this.createHistory(guiReportReq, objectArray, nArray, this.title);
            aperiChart = (AperiChart)new SpaceHistChart().batch(guiReportReq2, guiChartSettingsReq);
        }
        return aperiChart;
    }

    public AperiCustomizableChart createChart(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, ReportDataAdjuster reportDataAdjuster, ReportingDDI reportingDDI, GuiChartSettingsReq guiChartSettingsReq) {
        Serializable serializable;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.common.PingGrapher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "createChart", "grr, pData, rows, pAdjuster, ddi, gcsr");
        }
        PingReport[] pingReportArray = (PingReport[])objectArray;
        PingAdjuster pingAdjuster = (PingAdjuster)reportDataAdjuster;
        int n = nArray.length;
        Number[][] numberArray = new Number[2][n];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[2];
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            serializable = pingReportArray[n3];
            numberArray[0][n2] = new Double(serializable.pngReceived);
            numberArray[1][n2] = new Double(serializable.pngTransmitted - serializable.pngReceived);
            stringArray[n2] = this.getRowName(pingReportArray, n3, pingAdjuster);
            ++n2;
        }
        stringArray2[0] = MessageLog.getMessageNoID("STG4125L");
        stringArray2[1] = MessageLog.getMessageNoID("STG4126L");
        ChartOptions chartOptions = new ChartOptions();
        chartOptions.chartType = 7;
        AperiCustomizableChart aperiCustomizableChart = new AperiCustomizableChart(6, 7, numberArray, stringArray2, stringArray, chartOptions, guiReportReq);
        if (reportingDDI != null) {
            reportingDDI.addChart(guiReportReq, aperiCustomizableChart, "");
        }
        serializable = aperiCustomizableChart;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.common.PingGrapher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "createChart", serializable);
        }
        return serializable;
    }

    public GuiReportReq createHistory(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.common.PingGrapher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "createHistory", "grr, pData, rows, actionCommand");
        }
        PingReport[] pingReportArray = (PingReport[])objectArray;
        GuiReportReq guiReportReq2 = guiReportReq.explode(-1);
        guiReportReq2.reportSubtype = guiReportReq.reportSubtype;
        guiReportReq2.idSubtype = -1;
        SpaceHistChart.initLegend(guiReportReq2);
        guiReportReq2.selectedResources = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            PingReport pingReport = pingReportArray[nArray[n]];
            guiReportReq2.selectedResources[n] = pingReport.prID;
            SpaceHistChart.addLegend(guiReportReq2, pingReport.prName1, pingReport.getPrName2(), pingReport.prID);
            ++n;
        }
        if (string == GRAPH_AVAILABILITY_HIST) {
            guiReportReq2.chartLabelType = (byte)8;
            guiReportReq2.histSubtype = (byte)6;
            guiReportReq2.historyTitle = GRAPH_AVAILABILITY_HIST;
        } else {
            guiReportReq2.chartLabelType = (byte)3;
            guiReportReq2.histSubtype = (byte)7;
            guiReportReq2.historyTitle = GRAPH_TRANSIT_TIME_HIST;
        }
        guiReportReq2.reportSubtypeOrig = guiReportReq.reportSubtype;
        guiReportReq2.reportSubtype = 28;
        GuiReportReq guiReportReq3 = guiReportReq2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.common.PingGrapher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "createHistory", guiReportReq3);
        }
        return guiReportReq3;
    }

    public String getRowName(PingReport[] pingReportArray, int n, PingAdjuster pingAdjuster) {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (pingAdjuster.frozenColumns > 0) {
            stringBuffer.append(pingReportArray[n].prName1);
            if (pingAdjuster.frozenColumns > 1) {
                stringBuffer.append('.');
                stringBuffer.append(pingReportArray[n].getPrName2());
            }
            stringBuffer.append(' ');
            return stringBuffer.toString();
        }
        return MessageLog.getMessageNoID("STG5048L");
    }
}

