/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.AbstractAlertEditor;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class AlertCreateOrEdit
implements CreateOrEdit,
ChangeListener,
GuiRequestor,
ObjectChangeListener {
    protected CreateOrEditDDI ddi;
    protected CreateHeaderPanel createHeaderPanel;
    public JTabbedPane tabbedPane;
    protected AbstractAlertEditor alertEditor;
    private static final int ALERT_TAB = 0;
    private static final int RESOURCE_TAB = 1;

    public AlertCreateOrEdit(CreateOrEditDDI createOrEditDDI) {
        this.ddi = createOrEditDDI;
        this.ddi.showEnabled = true;
        this.ddi.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        this.ddi.subType = "org.eclipse.aperi.server.handler.gui.AlertDefHndlr";
    }

    public void build(int n) {
        if (n > 0) {
            this.fetch(n);
        } else {
            AlertHeader alertHeader = new AlertHeader();
            this.create(alertHeader);
            alertHeader.alert = this.alertEditor.getData();
            this.ddi.oldCreateHeader = (CreateHeader)alertHeader.clone();
        }
    }

    public void build(CreateHeader createHeader) {
        AlertHeader alertHeader = (AlertHeader)createHeader;
        this.create(alertHeader);
    }

    protected void create(AlertHeader alertHeader) {
        this.createHeaderPanel = new CreateHeaderPanel(alertHeader, this, this.ddi);
        this.makeTabbedPane(alertHeader);
        this.tabbedPane.setSelectedIndex(this.ddi.tabIndex);
        this.tabbedPane.addChangeListener(this);
        this.createHeaderPanel.add((Component)this.tabbedPane, "Center");
        this.ddi.panel = this.createHeaderPanel;
        this.ddi.show();
        this.createHeaderPanel.gettingFocus();
    }

    protected abstract void makeTabbedPane(AlertHeader var1);

    public CreateHeader getData() {
        AlertHeader alertHeader = (AlertHeader)this.createHeaderPanel.getData();
        alertHeader.alert = this.alertEditor.getData();
        return alertHeader;
    }

    public void validate(CreateHeader createHeader) throws GeneralException {
        AlertHeader alertHeader = (AlertHeader)createHeader;
        try {
            this.alertEditor.validateData();
        }
        catch (GeneralException generalException) {
            this.ddi.exceptionTabIndex = 0;
            throw generalException;
        }
        switch (alertHeader.alert.aldCondition) {
            case 64: 
            case 103: 
            case 106: 
            case 107: {
                break;
            }
            default: {
                if (alertHeader.alertElements != null || alertHeader.alertGroups != null || alertHeader.alertElements2 != null || alertHeader.alertGroups2 != null || alertHeader.alertElements3 != null || alertHeader.alertClusters != null || alertHeader.allObjects || alertHeader.allElements1 || alertHeader.allElements2) break;
                String string = MessageLog.getMessageNoTS("STG4048E", null);
                this.ddi.exceptionTabIndex = 1;
                throw new GeneralException(string);
            }
        }
    }

    public void replace(CreateHeader createHeader) {
        AlertHeader alertHeader = (AlertHeader)createHeader;
        this.createHeaderPanel.replace(alertHeader);
    }

    protected void fetch(int n) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.AlertDefHndlr";
        request.userName = GuiUtil.getUserName();
        AlertHeader alertHeader = new AlertHeader();
        alertHeader.ID = n;
        request.requestData = alertHeader;
        GuiClient.doRequest(this, request);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
    }

    public void showTab(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        AlertHeader alertHeader = (AlertHeader)response.responseData;
        this.ddi.oldCreateHeader = (CreateHeader)alertHeader.clone();
        this.create(alertHeader);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.ddi.tabIndex = this.tabbedPane.getSelectedIndex();
    }

    public abstract void changeOccurred(int var1, NameList var2);
}

