/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import org.eclipse.aperi.TStorm.gui.HistoryHelper;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiscoveryTreeNode
extends BaseTreeNode
implements ActionListener,
GuiRequestor {
    private static final String label = MessageLog.getMessageNoID("STG4091L");
    private static final String RUN_NOW = "R";
    private static final String EDIT = "E";
    private static final String HISTORY = "H";
    private static final String REFRESH = "F";
    private JMenuItem runNow;
    private JMenuItem edit;
    private JMenuItem history;
    private JMenuItem refresh;
    private HistoryHelper historyHelper;

    public DiscoveryTreeNode() {
        super(label, true);
        String string = MessageLog.getMessageNoID("JSS1002L");
        this.runNow = new JMenuItem(string);
        this.runNow.setActionCommand(RUN_NOW);
        this.runNow.addActionListener(this);
        this.runNow.setEnabled(DiscoveryTreeNode.guiMain.getUserPrefs().administrator);
        string = MessageLog.getMessageNoID("GUI0046L");
        this.edit = new JMenuItem(string);
        this.edit.setActionCommand(EDIT);
        this.edit.addActionListener(this);
        string = MessageLog.getMessageNoID("GUI0052L");
        this.history = new JMenuItem(string);
        this.history.setActionCommand(HISTORY);
        this.history.addActionListener(this);
        string = MessageLog.getMessageNoID("STG0003L");
        this.refresh = new JMenuItem(string);
        this.refresh.setActionCommand(REFRESH);
        this.refresh.addActionListener(this);
        this.historyHelper = new HistoryHelper(this, label, 100);
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.add(this.edit);
        jPopupMenu.add(this.refresh);
        jPopupMenu.add(this.history);
        jPopupMenu.add(this.runNow);
        this.showPopupMenu(jPopupMenu, mouseEvent);
    }

    private void submitToRun() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.scheduler.SchRunNowHandler";
        request.flags = (byte)4;
        NameList nameList = new NameList();
        nameList.nlID = 100;
        nameList.nlInfo = (short)32;
        request.requestData = nameList;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = MessageLog.getMessageNoID("STG3197L");
        Object[] objectArray2 = objectArray;
        JSgcScheduleCreateWhenData.displayJobSubmittedMessage(objectArray2);
    }

    private void createEditor() {
        Class<?> clazz;
        CreateOrEditDDI createOrEditDDI = new CreateOrEditDDI();
        try {
            clazz = Class.forName("org.eclipse.aperi.TStorm.gui.DiscoveryCreateOrEdit");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        createOrEditDDI.buildEditor(clazz, "", 100, (short)32);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == RUN_NOW) {
            this.submitToRun();
        } else if (string == EDIT) {
            this.createEditor();
        } else if (string == HISTORY) {
            this.historyHelper.makeRunDDI();
        } else if (string == REFRESH) {
            this.historyHelper.sendRequest();
        }
    }

    public void select(TreeSelectionEvent treeSelectionEvent) {
        this.createEditor();
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
        if (this.getChildCount() == 0) {
            this.historyHelper.sendRequest();
        }
    }
}

