/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.xmsg.MessageLog;

public class PrimitiveConditionEditor
implements ActionListener,
ComponentListener {
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    public JDialog dialog;
    public JLabel text;
    public JComboBox column;
    public JComboBox operator;
    public Container valuePanel;
    public JButton okButton;
    public boolean accepted = false;
    private Dimension minimumSize;
    private JButton helpButton;

    public void actionPerformed(ActionEvent actionEvent) {
        this.dialog.dispose();
    }

    public void accept() {
        this.accepted = true;
        this.dialog.dispose();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        Dimension dimension = component.getSize();
        boolean bl = false;
        if (dimension.width < this.minimumSize.width) {
            bl = true;
            dimension.width = this.minimumSize.width;
        }
        if (dimension.height < this.minimumSize.height) {
            bl = true;
            dimension.height = this.minimumSize.height;
        }
        if (bl) {
            component.setSize(dimension);
        }
    }

    public PrimitiveConditionEditor(String string) {
        String string2 = MessageLog.getMessageNoID("GUI0113L");
        this.okButton = new JButton(string2);
        GuiUtil.setAccessible(this.okButton, string2, string2);
        string2 = MessageLog.getMessageNoID("GUI0114L");
        JButton jButton = new JButton(string2);
        GuiUtil.setAccessible(jButton, string2, string2);
        string2 = MessageLog.getMessageNoID("GUI0072L");
        this.helpButton = new JButton(string2);
        GuiUtil.setAccessible(this.helpButton, string2, string2);
        jButton.addActionListener(this);
        this.text = new JLabel();
        this.dialog = new JDialog(this.guiMain.getFrame(), string, true);
        GuiUtil.setAccessible(this.dialog, string, string);
        this.dialog.setDefaultCloseOperation(2);
        Container container = this.dialog.getContentPane();
        Color color = container.getBackground();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.text, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)new HorizontalSeparator(color), gridBagConstraints);
        gridBagConstraints.fill = 0;
        jPanel.add(Box.createVerticalStrut(10), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.column = new TComboBox();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this.column, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add(Box.createHorizontalStrut(10), gridBagConstraints);
        this.operator = new TComboBox();
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this.operator, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut(10), gridBagConstraints);
        this.valuePanel = new JPanel();
        this.valuePanel.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.valuePanel, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)new HorizontalSeparator(color), gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.fill = 0;
        jPanel.add(Box.createVerticalStrut(10), gridBagConstraints);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.okButton);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(jButton);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(this.helpButton);
        gridBagConstraints.gridheight = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        container.setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        container.add((Component)jPanel, gridBagConstraints);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.setHelpID("welcome_htm");
        this.helpButton.addActionListener(Help.getDisplayHelpFromSource());
        this.dialog.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.dialog.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
    }

    public void enforceMinimumSize(Dimension dimension) {
        this.minimumSize = dimension;
        this.dialog.addComponentListener(this);
    }

    public void setHelpID(String string) {
        Help.setHelpID(this.helpButton, string);
        Help.setHelpID(this.dialog.getRootPane(), string);
    }

    public static abstract class Separator
    extends Component {
        protected Color shadow;
        protected Color highlight;
        protected Dimension reqMax;
        protected Dimension reqMin;
        protected Dimension reqPreferred;

        public Separator(Color color) {
            this.shadow = color.darker();
            this.highlight = color.brighter();
        }

        public Dimension getMaximumSize() {
            return this.reqMax;
        }

        public Dimension getMinimumSize() {
            return this.reqMin;
        }

        public Dimension getPreferredSize() {
            return this.reqPreferred;
        }
    }

    public static class HorizontalSeparator
    extends Separator {
        public HorizontalSeparator(Color color) {
            super(color);
            this.reqMax = new Dimension(Short.MAX_VALUE, 2);
            this.reqMin = new Dimension(0, 2);
            this.reqPreferred = new Dimension(0, 2);
        }

        public void paint(Graphics graphics) {
            Rectangle rectangle = graphics.getClipBounds();
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = n + rectangle.width;
            Color color = graphics.getColor();
            graphics.setColor(this.shadow);
            graphics.drawLine(n, n2, n3, n2);
            graphics.setColor(this.highlight);
            graphics.drawLine(n, n2 + 1, n3, n2 + 1);
            graphics.setColor(color);
        }
    }
}

