/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.TStorm.gui.ResourceSettingsEditor;
import org.eclipse.aperi.TStorm.gui.SettingsDDI;
import org.eclipse.aperi.TStorm.gui.SettingsEditor;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.xmsg.MessageLog;

public class ResourceHistorySettingsEditor
extends ResourceSettingsEditor
implements SettingsEditor,
ActionListener {
    private static final int DAYS = 0;
    private static final int WEEKS = 1;
    private static final int MONTHS = 2;
    private static final int FIELDS_PER_GROUP = 3;
    private static final int FILESYSTEM = 0;
    private static final int PING = 1;
    private static final int UPTIME = 2;
    private static final int DISK = 3;
    private static final int N_GROUPS = 4;
    private static final int TOTAL_FIELDS = 12;
    private static final String[] groupLabels = new String[]{"STG1006L", "STG3147L", "STG2002L", "STG1004L"};
    private static final String[] dailyLabels = new String[]{"STG3243L", "STG3244L", "STG3244L", "STG3243L"};
    private static final char NO_HISTORY = 'N';
    private static final char DEFAULTS = 'D';
    private JComponent panel;
    private static final String[] moreTrailingIDs = new String[]{"STG3091L", "STG3092L", "STG3093L"};

    public ResourceHistorySettingsEditor(SettingsDDI settingsDDI) {
        this.ddi = settingsDDI;
    }

    protected void fillSettingsFromValues(Settings settings) {
        int n = 0;
        settings.seFSDailyHist = this.values[n++];
        settings.seFSWeeklyHist = this.values[n++];
        settings.seFSMonthlyHist = this.values[n++];
        settings.sePingDailyHist = this.values[n++];
        settings.sePingWeeklyHist = this.values[n++];
        settings.sePingMonthlyHist = this.values[n++];
        settings.seCompDailyHist = this.values[n++];
        settings.seCompWeeklyHist = this.values[n++];
        settings.seCompMonthlyHist = this.values[n++];
        settings.seDiskDailyHist = this.values[n++];
        settings.seDiskWeeklyHist = this.values[n++];
        settings.seDiskMonthlyHist = this.values[n++];
    }

    protected void fillValuesFromSettings(Settings settings) {
        int n = 0;
        this.values[n++] = settings.seFSDailyHist;
        this.values[n++] = settings.seFSWeeklyHist;
        this.values[n++] = settings.seFSMonthlyHist;
        this.values[n++] = settings.sePingDailyHist;
        this.values[n++] = settings.sePingWeeklyHist;
        this.values[n++] = settings.sePingMonthlyHist;
        this.values[n++] = settings.seCompDailyHist;
        this.values[n++] = settings.seCompWeeklyHist;
        this.values[n++] = settings.seCompMonthlyHist;
        this.values[n++] = settings.seDiskDailyHist;
        this.values[n++] = settings.seDiskWeeklyHist;
        this.values[n++] = settings.seDiskMonthlyHist;
    }

    private JLabel restOfLine(int n, int n2, GridBagConstraints gridBagConstraints, int n3) {
        int n4 = n + n2;
        String string = MessageLog.getMessageNoID(moreTrailingIDs[n2]);
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Color.black);
        jLabel.setEnabled(false);
        this.leadingLabels[n4] = jLabel;
        gridBagConstraints.insets.left = 3;
        this.panel.add((Component)jLabel, gridBagConstraints);
        TTextField tTextField = TTextField.newTTextField(null, 3, 5, true);
        String string2 = jLabel.getText();
        if (string2 != null) {
            if (string2.equalsIgnoreCase("Number of days to keep:")) {
                GuiUtil.setAccessible(tTextField, MessageLog.getMessageNoID("STG3091L"), MessageLog.getMessageNoID("STG3091L"));
            } else if (string2.equalsIgnoreCase("Number of weeks to keep:")) {
                GuiUtil.setAccessible(tTextField, MessageLog.getMessageNoID("STG3092L"), MessageLog.getMessageNoID("STG3091L"));
            } else if (string2.equalsIgnoreCase("Number of months to keep:")) {
                GuiUtil.setAccessible(tTextField, MessageLog.getMessageNoID("STG3093L"), MessageLog.getMessageNoID("STG3091L"));
            }
        }
        tTextField.setEnabled(false);
        this.fields[n4] = tTextField;
        this.panel.add((Component)tTextField, gridBagConstraints);
        jLabel = new JLabel("");
        gridBagConstraints.gridwidth = 0;
        return jLabel;
    }

    private Container makeGroup(int n) {
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setBorder(GuiUtil.getBorder());
        String string = Util.getString(groupLabels[n]);
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(BaseTree.boldFont);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 4;
        gridBagConstraints.insets.left = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        this.panel.add((Component)jLabel, gridBagConstraints);
        string = Util.getString(dailyLabels[n]);
        JCheckBox jCheckBox = new JCheckBox(string);
        GuiUtil.setAccessible(jCheckBox, string, string);
        int n2 = 0;
        n2 = n * 3;
        this.checkBoxes[n2 + 0] = jCheckBox;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 23;
        gridBagConstraints.gridwidth = 1;
        this.panel.add((Component)jCheckBox, gridBagConstraints);
        jLabel = this.restOfLine(n2, 0, gridBagConstraints, n);
        this.panel.add((Component)jLabel, gridBagConstraints);
        string = MessageLog.getMessageNoID("STG3088L");
        jCheckBox = new JCheckBox(string);
        GuiUtil.setAccessible(jCheckBox, string, string);
        this.checkBoxes[n2 + 1] = jCheckBox;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 23;
        gridBagConstraints.gridwidth = 1;
        this.panel.add((Component)jCheckBox, gridBagConstraints);
        jLabel = this.restOfLine(n2, 1, gridBagConstraints, n);
        this.panel.add((Component)jLabel, gridBagConstraints);
        string = MessageLog.getMessageNoID("STG3089L");
        jCheckBox = new JCheckBox(string);
        GuiUtil.setAccessible(jCheckBox, string, string);
        this.checkBoxes[n2 + 2] = jCheckBox;
        gridBagConstraints.insets.left = 23;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets.bottom = 4;
        gridBagConstraints.gridwidth = 1;
        this.panel.add((Component)jCheckBox, gridBagConstraints);
        jLabel = this.restOfLine(n2, 2, gridBagConstraints, n);
        gridBagConstraints.weightx = 1.0;
        this.panel.add((Component)jLabel, gridBagConstraints);
        return this.panel;
    }

    public JComponent getComponent(Settings settings) {
        this.checkBoxes = new JCheckBox[12];
        this.fields = new JTextField[12];
        this.leadingLabels = new JLabel[12];
        String string = MessageLog.getMessageNoID("STG3245T");
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(BaseTree.boldFont);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.top = 4;
        gridBagConstraints.weightx = 0.5;
        jPanel.add((Component)jLabel, gridBagConstraints);
        String string2 = MessageLog.getMessageNoID("STG3246L");
        JButton jButton = new JButton(string2);
        GuiUtil.setAccessible(jButton, jButton.getText(), jButton.getText());
        Container container = new JPanel(new BorderLayout());
        container.add((Component)jButton, "West");
        container.add(Box.createHorizontalStrut(10), "Center");
        string2 = MessageLog.getMessageNoID("STG3247L");
        JButton jButton2 = new JButton(string2);
        GuiUtil.setAccessible(jButton2, jButton2.getText(), jButton2.getText());
        container.add((Component)jButton2, "East");
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets.right = 4;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)container, gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.top = 4;
        gridBagConstraints.weightx = 0.0;
        container = this.makeGroup(0);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)container, gridBagConstraints);
        container = this.makeGroup(3);
        gridBagConstraints.insets.right = 4;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)container, gridBagConstraints);
        container = this.makeGroup(1);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)container, gridBagConstraints);
        container = this.makeGroup(2);
        gridBagConstraints.insets.right = 4;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)container, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createVerticalStrut(1), gridBagConstraints);
        this.panel = null;
        this.values = new short[12];
        int n = 0;
        while (n < this.checkBoxes.length) {
            this.checkBoxes[n].addChangeListener(this);
            ++n;
        }
        this.pushSettingsOntoPanel(settings);
        char[] cArray = new char[]{'N'};
        string2 = new String(cArray);
        jButton.setActionCommand(string2);
        jButton.addActionListener(this);
        cArray[0] = 68;
        string2 = new String(cArray);
        jButton2.setActionCommand(string2);
        jButton2.addActionListener(this);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        char c = actionEvent.getActionCommand().charAt(0);
        switch (c) {
            case 'N': {
                int n = 0;
                while (n < this.values.length) {
                    this.values[n] = 0;
                    ++n;
                }
                this.pushValuesOntoPanel();
                break;
            }
            case 'D': {
                Settings settings = new Settings(true);
                this.pushSettingsOntoPanel(settings);
            }
        }
    }
}

