/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.server.guireq.PartitionedReport;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class TJCPartitionedTableData
extends BaseTableModel
implements ActionListener {
    protected PartitionedReport partition;
    protected MegaTable table;
    private JPanel tablePanel;
    private GuiRequestor requestor;
    private LinkedList sortList;
    private boolean ignoreSort;
    private JButton moreButton;

    public TJCPartitionedTableData(PartitionedReport partitionedReport, MegaTable megaTable, JPanel jPanel, GuiRequestor guiRequestor) {
        this.partition = partitionedReport;
        this.table = megaTable;
        this.tablePanel = jPanel;
        this.requestor = guiRequestor;
        if (!partitionedReport.prLastPart) {
            this.sortList = new LinkedList();
            if (jPanel != null) {
                JPanel jPanel2 = new JPanel();
                this.moreButton = new JButton(MessageLog.getMessageNoID("STG4159L"));
                GuiUtil.setAccessible(this.moreButton, this.moreButton.getText(), this.moreButton.getText());
                jPanel2.add(this.moreButton);
                jPanel.add((Component)jPanel2, "North");
                this.moreButton.addActionListener(this);
            }
        }
    }

    public void appendRows(Object object, Object object2, PartitionedReport partitionedReport, ReportDataAdjuster reportDataAdjuster) {
        int n;
        this.partition = partitionedReport;
        if (partitionedReport.prLastPart) {
            this.moreButton.setEnabled(false);
        }
        Serializable serializable = partitionedReport.prData;
        int n2 = Array.getLength(object2);
        int n3 = Array.getLength(serializable);
        this.rowCount += n3;
        System.arraycopy(object2, 0, object, 0, n2);
        System.arraycopy(serializable, 0, object, n2, n3);
        reportDataAdjuster.replaceArray(object);
        this.fireTableDataChanged();
        if (this.sortList != null && (n = this.sortList.size()) > 0) {
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            n = 0;
            ListIterator listIterator = this.sortList.listIterator(0);
            while (listIterator.hasNext()) {
                SortCol sortCol = (SortCol)listIterator.next();
                nArray[n] = sortCol.column;
                nArray2[n++] = sortCol.direction;
            }
            this.ignoreSort = true;
        }
    }

    private Object extendArray(Object object, int n) {
        int n2 = Array.getLength(object);
        Object object2 = Array.get(object, 0);
        Object object3 = Array.newInstance(object2.getClass(), n);
        System.arraycopy(object, 0, object3, 0, n2);
        return object3;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.moreButton) {
            PartitionedReport partitionedReport = (PartitionedReport)this.partition.clone();
            partitionedReport.prPartition = (short)(partitionedReport.prPartition + 1);
            partitionedReport.prData = null;
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.PartitionHndlr";
            request.requestData = partitionedReport;
            GuiClient.doRequest(this.requestor, request);
        }
    }

    private class SortCol {
        int column;
        int direction;

        SortCol(int n, int n2) {
            this.column = n;
            this.direction = n2;
            ListIterator listIterator = TJCPartitionedTableData.this.sortList.listIterator(0);
            while (listIterator.hasNext()) {
                SortCol sortCol = (SortCol)listIterator.next();
                if (sortCol.column != n) continue;
                listIterator.remove();
            }
            TJCPartitionedTableData.this.sortList.addFirst(this);
            if (TJCPartitionedTableData.this.sortList.size() > 4) {
                TJCPartitionedTableData.this.sortList.removeLast();
            }
        }
    }
}

