/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.Component;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.TimestampWidget;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditorDialog;
import org.eclipse.aperi.TStorm.gui.rptfilter.WidgetListener;
import org.eclipse.aperi.common.MutableLong;

public class DateEditor
implements ValueEditor,
WidgetListener {
    private ColumnFilter filter;
    private TimestampWidget widget;
    private Component panel;
    private ValueEditorDialog dialog;

    public static TimestampWidget makeTimestampWidget(ColumnFilter columnFilter, ColumnFilterValue columnFilterValue, WidgetListener widgetListener) {
        long l;
        short s;
        if (columnFilterValue == null) {
            s = 1;
            Date date = new Date();
            l = date.getTime();
        } else if (columnFilter.clfDataType == 3) {
            s = 1;
            Date date = (Date)columnFilterValue.fvValue;
            l = date.getTime();
        } else {
            s = 0;
            MutableLong mutableLong = (MutableLong)columnFilterValue.fvValue;
            l = mutableLong.value;
        }
        return new TimestampWidget(l / 1000L, s, widgetListener);
    }

    public static ColumnFilterValue makeValue(TimestampWidget timestampWidget, ColumnFilter columnFilter) {
        Comparable comparable;
        if (timestampWidget.scale == 0) {
            columnFilter.clfDataType = (short)6;
            comparable = new MutableLong(timestampWidget.number * 1000L);
        } else {
            columnFilter.clfDataType = (short)3;
            comparable = new Date(timestampWidget.number * 1000L);
        }
        return new ColumnFilterValue(comparable);
    }

    public DateEditor(ColumnFilter columnFilter, ValueEditorDialog valueEditorDialog) {
        this.filter = columnFilter;
        this.dialog = valueEditorDialog;
        this.widget = DateEditor.makeTimestampWidget(this.filter, this.filter.clfValueList, this);
        this.panel = this.widget.makeSwitchable(false);
    }

    public Component getWholeComponent() {
        return this.panel;
    }

    public void getData() {
        this.filter.clfValueList = DateEditor.makeValue(this.widget, this.filter);
    }

    public void setFocus() {
        this.widget.setFocus();
    }

    public void valueChanged(int n) {
        if (n != 0) {
            this.dialog.setOKEnabled(n > 0);
        }
    }

    public void notifyEnterStruck() {
    }
}

