/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.backend;

import java.io.PrintWriter;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.ReadLogRequest;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class LogFileReader {
    private static Class requestDataClass;

    static {
        ReadLogRequest readLogRequest = new ReadLogRequest();
        requestDataClass = readLogRequest.getClass();
    }

    protected abstract MutableInteger open(ReadLogRequest var1, Response var2);

    protected abstract int read(MutableInteger var1, LogFilePos var2, ReadLogRequest var3, ReadLogResponse var4, Response var5);

    protected abstract boolean setPosition(MutableInteger var1, ReadLogRequest var2, LogFilePos var3);

    protected native int openFile(String var1, int var2) throws LocalizableException;

    private native int readBackwards(int var1, String[] var2, int var3) throws LocalizableException;

    private native int readForwards(int var1, String[] var2, int var3) throws LocalizableException;

    protected native int getFilePosition(int var1);

    protected native void setFilePosition(int var1, int var2);

    protected native void closeFile(int var1);

    private void close(MutableInteger mutableInteger) {
        this.closeFile(mutableInteger.value);
    }

    protected int basicRead(int n, LogFilePos logFilePos, ReadLogRequest readLogRequest, String[] stringArray, int n2, Response response) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LogFileReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "basicRead", "fd, pos, requestData, lineArray, alreadyDone, response");
        }
        int n3 = -1;
        byte by = readLogRequest.direction;
        try {
            n3 = by == 1 ? this.readForwards(n, stringArray, n2) : this.readBackwards(n, stringArray, stringArray.length - n2);
            logFilePos.offset = this.getFilePosition(n);
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.LogFileReader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception(clazz.getName(), "basicRead", localizableException);
            }
            localizableException.getParameters()[0] = readLogRequest.name;
            response.errorMessage = localizableException.getMessage();
        }
        int n4 = n3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LogFileReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "basicRead", n4);
        }
        return n4;
    }

    private void searchForward(ReadLogResponse readLogResponse, int n, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LogFileReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "searchForward", "resp, upTo, searchFor");
        }
        String[] stringArray = readLogResponse.lineArray;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        boolean bl = true;
        while (bl && n3 < n) {
            String string2 = stringArray[n3];
            int n5 = string2.length() - n2;
            n4 = 0;
            while (bl && n4 <= n5) {
                if (string2.regionMatches(true, n4, string, 0, n2)) {
                    bl = false;
                    continue;
                }
                ++n4;
            }
            if (!bl) continue;
            ++n3;
        }
        if (!bl) {
            readLogResponse.status = 0;
            readLogResponse.foundIndex = n3;
            readLogResponse.foundOffset = n4;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LogFileReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "searchForward");
        }
    }

    private void searchBackward(ReadLogResponse readLogResponse, int n, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LogFileReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "searchBackward", "resp, backTo, searchFor");
        }
        String[] stringArray = readLogResponse.lineArray;
        int n2 = string.length();
        int n3 = stringArray.length - 1;
        int n4 = 0;
        boolean bl = true;
        while (bl && n3 >= n) {
            String string2 = stringArray[n3];
            n4 = string2.length() - n2;
            while (bl && n4 >= 0) {
                if (string2.regionMatches(true, n4, string, 0, n2)) {
                    bl = false;
                    continue;
                }
                --n4;
            }
            if (!bl) continue;
            --n3;
        }
        if (!bl) {
            readLogResponse.status = 0;
            readLogResponse.foundIndex = n3;
            readLogResponse.foundOffset = n4;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LogFileReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "searchBackward");
        }
    }

    private int doSearch(MutableInteger mutableInteger, ReadLogRequest readLogRequest, Response response, ReadLogResponse readLogResponse) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LogFileReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "doSearch", "handle, rq, response, responseData");
        }
        byte by = readLogRequest.direction;
        readLogResponse.status = 1;
        LogFilePos logFilePos = new LogFilePos(readLogRequest.position);
        int n = 0;
        int n2 = 0;
        while (readLogResponse.status != 0 && (n2 = this.read(mutableInteger, readLogRequest.position, readLogRequest, readLogResponse, response)) > 0) {
            ++n;
            if (by == 1) {
                this.searchForward(readLogResponse, n2, readLogRequest.searchFor);
            } else {
                this.searchBackward(readLogResponse, readLogResponse.lineArray.length - n2, readLogRequest.searchFor);
            }
            if (readLogResponse.status == 0) continue;
            readLogRequest.position.copy(logFilePos);
        }
        if (n2 == 0) {
            readLogResponse.lineArray = null;
            response.status = 0;
            response.responseData = readLogResponse;
            n2 = -1;
        } else if (n2 > 0) {
            if (by == 1) {
                readLogResponse.start = logFilePos;
                readLogResponse.end = readLogRequest.position;
            } else {
                readLogResponse.start = readLogRequest.position;
                readLogResponse.end = logFilePos;
            }
            if (n2 < readLogResponse.lineArray.length && n > 1 && this.setPosition(mutableInteger, readLogRequest, logFilePos)) {
                String[] stringArray = readLogResponse.lineArray;
                readLogResponse.lineArray = new String[stringArray.length - n2];
                Response response2 = new Response(0, null);
                readLogRequest.direction = -by;
                int n3 = this.read(mutableInteger, logFilePos, readLogRequest, readLogResponse, response2);
                if (n3 < 0) {
                    if (response2.errorMessage != null) {
                        PrintWriter printWriter = MessageLog.getThreadLog();
                        printWriter.println(response2.errorMessage);
                    }
                } else if (n3 > 0) {
                    String[] stringArray2;
                    if (n2 + n3 <= stringArray.length) {
                        stringArray2 = stringArray;
                    } else {
                        stringArray2 = new String[n2 + n3];
                        if (by == -1) {
                            readLogResponse.foundIndex += n2 + n3 - stringArray.length;
                        }
                    }
                    if (by == 1) {
                        System.arraycopy(stringArray, 0, stringArray2, n3, n2);
                    } else {
                        System.arraycopy(stringArray, stringArray.length - n2, stringArray2, stringArray2.length - n2 - n3, n2);
                    }
                    readLogResponse.foundIndex += by * n3;
                    stringArray = stringArray2;
                    String[] stringArray3 = readLogResponse.lineArray;
                    if (by == 1) {
                        System.arraycopy(stringArray3, stringArray3.length - n3, stringArray, 0, n3);
                    } else {
                        System.arraycopy(stringArray3, 0, stringArray, stringArray.length - n3, n3);
                    }
                    n2 += n3;
                }
                readLogResponse.lineArray = stringArray;
            }
        }
        int n4 = n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LogFileReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "doSearch", n4);
        }
        return n4;
    }

    private void trim(ReadLogResponse readLogResponse, int n, byte by) {
        int n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LogFileReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "trim", "resp, linesRead, direction");
        }
        String[] stringArray = readLogResponse.lineArray;
        String[] stringArray2 = new String[n];
        if (by == 1) {
            n2 = 0;
        } else {
            n2 = stringArray.length - n;
            readLogResponse.foundIndex -= n2;
        }
        System.arraycopy(stringArray, n2, stringArray2, 0, n);
        readLogResponse.lineArray = stringArray2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LogFileReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "trim");
        }
    }

    public void handle(Request request, Response response) {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LogFileReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "handle", "request, response");
        }
        if (!RequestChecker.isDesiredType(requestDataClass, request, response)) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.LogFileReader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "handle");
            }
            return;
        }
        ReadLogRequest readLogRequest = (ReadLogRequest)request.requestData;
        MutableInteger mutableInteger = this.open(readLogRequest, response);
        if (mutableInteger == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.LogFileReader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "handle");
            }
            return;
        }
        ReadLogResponse readLogResponse = new ReadLogResponse();
        readLogResponse.lineArray = new String[readLogRequest.linesDesired];
        byte by = readLogRequest.direction;
        if (readLogRequest.searchFor != null) {
            n = this.doSearch(mutableInteger, readLogRequest, response, readLogResponse);
        } else {
            LogFilePos logFilePos = readLogRequest.position;
            LogFilePos logFilePos2 = new LogFilePos(logFilePos);
            n = this.read(mutableInteger, logFilePos, readLogRequest, readLogResponse, response);
            if (n >= 0) {
                if (by == 1) {
                    readLogResponse.start = logFilePos2;
                    readLogResponse.end = logFilePos;
                } else {
                    readLogResponse.start = logFilePos;
                    readLogResponse.end = logFilePos2;
                }
            }
        }
        if (n >= 0) {
            if (n < readLogRequest.linesDesired) {
                this.trim(readLogResponse, n, by);
            }
            response.responseData = readLogResponse;
            response.status = 0;
        }
        this.close(mutableInteger);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.LogFileReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "handle");
        }
    }
}

