/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.api;

import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;

public class AsyncResult
extends Result {
    static final long serialVersionUID = -8141904872480418282L;
    public static final int WAITING = -2;
    public static final int SUBMITTED = -1;
    public static final int FAILED = 0;
    public static final int SUCCESSFUL = 1;
    public static final int RUNNING = 2;
    public static final int WARNING = 3;
    public static final int PARTIAL_FAILURE = 4;
    public static final int CANCELLED = 5;
    protected String jobId = "-1";
    protected int status = 1;
    protected Exception returnException = null;
    protected AsyncResult[] subJobResults = null;

    public AsyncResult() {
    }

    public AsyncResult(int n) {
        this.rc = n;
    }

    public AsyncResult(int n, int n2) {
        this.rc = n;
        this.status = n2;
    }

    public AsyncResult(int n, int n2, SRMMessage sRMMessage) {
        this.rc = n;
        this.status = n2;
        this.msg = sRMMessage;
    }

    public Exception getReturnException() {
        return this.returnException;
    }

    public int getStatus() {
        return this.status;
    }

    public void setReturnException(Exception exception) {
        this.returnException = exception;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public AsyncResult[] getSubJobResults() {
        return this.subJobResults;
    }

    public void setSubJobResults(AsyncResult[] asyncResultArray) {
        this.subJobResults = asyncResultArray;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String string) {
        this.jobId = string;
    }

    public String toString() {
        int n;
        String string = String.valueOf(System.getProperty("line.separator")) + "AsyncResult@" + Integer.toHexString(this.hashCode()) + ":" + System.getProperty("line.separator") + " Status=" + this.status + ", JobId =" + this.jobId + ", ReturnCode=" + this.rc + ",";
        string = String.valueOf(string) + (this.msg == null ? "" : String.valueOf(System.getProperty("line.separator")) + " Message=" + this.getMessage().toString());
        string = String.valueOf(string) + (this.returnException == null ? "" : String.valueOf(System.getProperty("line.separator")) + " ReturnException = " + this.returnException.toString());
        if (this.results != null) {
            string = String.valueOf(string) + System.getProperty("line.separator") + " Results:";
            n = 0;
            while (n < this.results.length) {
                if (this.results[n] != null) {
                    string = String.valueOf(string) + System.getProperty("line.separator") + this.results[n].toString();
                }
                ++n;
            }
        }
        if (this.subJobResults != null) {
            string = String.valueOf(string) + System.getProperty("line.separator") + " SubJobResults:";
            n = 0;
            while (n < this.subJobResults.length) {
                string = String.valueOf(string) + System.getProperty("line.separator") + this.subJobResults[n].toString();
                ++n;
            }
        }
        return string;
    }
}

