/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.identifier;

import org.eclipse.aperi.common.identifier.ComponentId;
import org.eclipse.aperi.common.identifier.DeviceId;

public class IoGroupId
extends ComponentId {
    private int iIoGroupNum;
    static final long serialVersionUID = 3255063080475531414L;

    public IoGroupId(DeviceId deviceId, int n) throws IllegalArgumentException {
        this(deviceId, n, null);
    }

    public IoGroupId(DeviceId deviceId, int n, String string) throws IllegalArgumentException {
        super(deviceId, Integer.toString(n), string);
        this.setIoGroupNumber(n);
    }

    public final int getIoGroupNumber() {
        return this.iIoGroupNum;
    }

    public synchronized void setIoGroupNumber(int n) {
        this.iIoGroupNum = n;
        super.setInternalName(Integer.toString(n));
    }

    public synchronized void setInternalName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The specified internal identifier is invalid (null.)");
        }
        try {
            this.iIoGroupNum = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("The specified internal identifier is invalid (" + string + ").  It must represent an integer between 0 and 2,147,483,648.");
        }
        super.setInternalName(string);
    }

    public boolean equals(Object object) {
        if (object instanceof IoGroupId) {
            return super.equals(object) && this.iIoGroupNum == ((IoGroupId)object).iIoGroupNum;
        }
        return false;
    }

    public int compareTo(Object object) {
        int n = super.compareTo(object);
        if (n == 0) {
            n = this.iIoGroupNum - ((IoGroupId)object).iIoGroupNum;
        }
        return n == 0 ? 0 : (n < 0 ? -1 : 1);
    }

    public boolean isIdentical(Object object) {
        return object instanceof IoGroupId && this.iIoGroupNum == ((IoGroupId)object).iIoGroupNum && super.isIdentical(object);
    }

    public int hashCode() {
        String string = this.getDeviceId().getInternalName();
        int n = string.length();
        return (this.iIoGroupNum << 24) + (n < 3 ? 0 : string.charAt(n - 3) << 16) + (n < 2 ? 0 : string.charAt(n - 2) << 8) + (n < 1 ? 0 : (int)string.charAt(n - 1));
    }

    public String toString() {
        return this.getInternalName();
    }
}

