/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.fabric.api.FabricManagerConstants;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.objects.Hba;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class ExternalKeyConverter {
    public static final String DELIMITER = "+";
    public static String[] externalKeyAttributes;
    private static ILogger traceLogger;
    static final String className;
    public static Vector columnName;

    static {
        Class<?> clazz;
        externalKeyAttributes = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.fabric.ExternalKeyConverter");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        columnName = new Vector(1);
    }

    public static String frameComputerKey(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = new String("");
        if (string != null) {
            string = string.trim();
        }
        string7 = String.valueOf(string) + DELIMITER + string2 + DELIMITER + string3 + DELIMITER + string4 + DELIMITER + string5 + DELIMITER + string6;
        string7 = string7.replaceAll("null", "");
        return string7;
    }

    public static String frameHBAKey(String string, String string2, String string3) {
        String string4 = new String("");
        string4 = String.valueOf(string) + DELIMITER + string2 + DELIMITER + string3;
        string4 = string4.replaceAll("null", "");
        return string4;
    }

    public static String getComputerIdFromExternalKey(String string) {
        String string2;
        String string3;
        block4: {
            string3 = "";
            string2 = "getComputerIdFromExternalKey";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, string);
            }
            try {
                String[] stringArray = ExternalKeyConverter.splitKey(string);
                Hashtable hashtable = ExternalKeyConverter.getInternalIdWhereClause(FabricManagerConstants.EXTERNAL_COMPUTER_KEY_SET, stringArray);
                columnName.clear();
                columnName.add("COMPUTER_ID");
                string3 = ExternalKeyConverter.runQuery(hashtable, columnName);
            }
            catch (Exception exception) {
                if (traceLogger == null || !traceLogger.isLogging()) break block4;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, string3.toString());
        }
        return string3;
    }

    public static String getHBAIdFromExternalKey(String string) {
        String string2;
        String string3;
        block4: {
            string3 = "";
            string2 = "getHBAIdFromExternalKey";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, string);
            }
            try {
                String[] stringArray = ExternalKeyConverter.splitKey(string);
                String string4 = ExternalKeyConverter.frameComputerKey(stringArray[0], stringArray[1], stringArray[2], null, null, null);
                String string5 = ExternalKeyConverter.getComputerIdFromExternalKey(string4);
                Hashtable hashtable = ExternalKeyConverter.getHBAIdWhereClause(FabricManagerConstants.EXTERNAL_HBA_KEY_SET, new String[]{string5, stringArray[6], stringArray[7]});
                columnName.clear();
                columnName.add("HBA_ID");
                string3 = ExternalKeyConverter.runHBAQuery(hashtable, columnName);
            }
            catch (Exception exception) {
                if (traceLogger == null || !traceLogger.isLogging()) break block4;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, string3.toString());
        }
        return string3;
    }

    public static String getSubsystemIdFromExternalKey(String string) {
        String string2;
        String string3;
        block4: {
            string3 = "";
            string2 = "getSubsystemIdFromExternalKey";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, string);
            }
            try {
                String[] stringArray = ExternalKeyConverter.splitStorageSubsystemKey(string);
                Hashtable hashtable = ExternalKeyConverter.getSubsystemIdWhereClause(FabricManagerConstants.EXTERNAL_SUBSYSTEM_KEY_SET, stringArray);
                columnName.clear();
                columnName.add("SUBSYSTEM_ID");
                string3 = ExternalKeyConverter.runSSQuery(hashtable, columnName);
            }
            catch (Exception exception) {
                if (traceLogger == null || !traceLogger.isLogging()) break block4;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, string3.toString());
        }
        return string3;
    }

    public static String[] splitKey(String string) {
        if (string.startsWith(DELIMITER)) {
            string = " " + string;
        }
        if (string.endsWith(DELIMITER)) {
            string = String.valueOf(string) + " ";
        }
        string = string.replaceAll("\\+\\+", "\\+ \\+");
        String[] stringArray = string.split("\\+");
        return stringArray;
    }

    public static String[] splitStorageSubsystemKey(String string) {
        String[] stringArray = string.split("\\+");
        stringArray = ExternalKeyConverter.checkForSlash(stringArray);
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < stringArray.length) {
            string2 = stringArray[n].replaceAll("\\\\\\\\", "\\\\");
            stringArray[n] = string3 = string2.replaceAll("\\\\\\+", "\\+");
            ++n;
        }
        return stringArray;
    }

    private static String[] checkForSlash(String[] stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = null;
        if (stringArray.length > 0) {
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                string = bl ? String.valueOf(string) + DELIMITER + stringArray[n] : stringArray[n];
                if (string.endsWith("\\")) {
                    int n2 = ExternalKeyConverter.countSlashFromEnd(string);
                    if (n2 % 2 == 0) {
                        linkedList.add(string);
                        bl = false;
                        string = null;
                    } else {
                        bl = true;
                    }
                } else {
                    linkedList.add(string);
                    bl = false;
                    string = null;
                }
                ++n;
            }
        }
        if (string != null) {
            linkedList.add(String.valueOf(string) + DELIMITER);
        }
        return linkedList.toArray(new String[0]);
    }

    private static int countSlashFromEnd(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0) {
            if (string.charAt(n2) == '\\') {
                ++n;
            } else {
                return n;
            }
            --n2;
        }
        return n;
    }

    public static Hashtable getInternalIdWhereClause(String[] stringArray, String[] stringArray2) {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        if (stringArray == null || stringArray.length == stringArray2.length) {
            // empty if block
        }
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(Host.getColumnInfo(stringArray[n]), stringArray2[n]);
            ++n;
        }
        return hashtable;
    }

    public static Hashtable getHBAIdWhereClause(String[] stringArray, String[] stringArray2) {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        if (stringArray == null || stringArray.length == stringArray2.length) {
            // empty if block
        }
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(Hba.getColumnInfo(stringArray[n]), stringArray2[n]);
            ++n;
        }
        return hashtable;
    }

    public static Hashtable getSubsystemIdWhereClause(String[] stringArray, String[] stringArray2) {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        if (stringArray == null || stringArray.length == stringArray2.length) {
            // empty if block
        }
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(StorageSubsystem.getColumnInfo(stringArray[n]), stringArray2[n]);
            ++n;
        }
        return hashtable;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String runQuery(Hashtable var0, Vector var1_1) throws Exception {
        block15: {
            var2_2 = "getComputers";
            var3_3 = new String();
            var4_4 = ServiceUtils.getConnection();
            var5_5 = null;
            try {
                try {
                    var5_5 = Host.getCursor(var4_4, var0, var1_1);
                    while (var5_5.next()) {
                        var6_6 = var5_5.getAttribute(var1_1);
                        var3_3 = var6_6[0].toString();
                    }
                }
                catch (Exception var6_7) {
                    var4_4.rollback();
                    if (ExternalKeyConverter.traceLogger == null) throw var6_7;
                    if (ExternalKeyConverter.traceLogger.isLogging() == false) throw var6_7;
                    ExternalKeyConverter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ExternalKeyConverter.className, var2_2, var6_7);
                    throw var6_7;
                }
            }
            catch (Throwable var8_8) {
                block14: {
                    var7_9 = null;
                    try {
                        if (var5_5 != null) {
                            var5_5.close();
                        }
                    }
                    catch (Exception var9_11) {
                        if (ExternalKeyConverter.traceLogger == null || !ExternalKeyConverter.traceLogger.isLogging()) break block14;
                        ExternalKeyConverter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ExternalKeyConverter.className, String.valueOf(var2_2) + " Error closing cursor: ", var9_11);
                    }
                }
                try {
                    if (var4_4 == null) throw var8_8;
                    var4_4.close();
                    throw var8_8;
                }
                catch (Exception var9_11) {
                    if (ExternalKeyConverter.traceLogger == null) throw var8_8;
                    if (ExternalKeyConverter.traceLogger.isLogging() == false) throw var8_8;
                    ExternalKeyConverter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ExternalKeyConverter.className, String.valueOf(var2_2) + " Error closing connection: ", var9_11);
                }
                throw var8_8;
            }
            {
                var7_10 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 113->126)] { 
lbl41:
            // 1 sources

            if (var5_5 != null) {
                var5_5.close();
            }
            break block15;
lbl44:
            // 1 sources

            catch (Exception var9_12) {
                if (ExternalKeyConverter.traceLogger == null || !ExternalKeyConverter.traceLogger.isLogging()) break block15;
                ExternalKeyConverter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ExternalKeyConverter.className, String.valueOf(var2_2) + " Error closing cursor: ", var9_12);
            }
        }
        try {}
        catch (Exception var9_12) {
            if (ExternalKeyConverter.traceLogger == null) return var3_3;
            if (ExternalKeyConverter.traceLogger.isLogging() == false) return var3_3;
            ExternalKeyConverter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ExternalKeyConverter.className, String.valueOf(var2_2) + " Error closing connection: ", var9_12);
            return var3_3;
        }
        if (var4_4 == null) return var3_3;
        var4_4.close();
        return var3_3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String runSSQuery(Hashtable var0, Vector var1_1) throws Exception {
        block15: {
            var2_2 = "getSubsystemId";
            var3_3 = new String();
            var4_4 = ServiceUtils.getConnection();
            var5_5 = null;
            try {
                try {
                    var5_5 = StorageSubsystem.getCursor(var4_4, var0, var1_1);
                    while (var5_5.next()) {
                        var6_6 = var5_5.getAttribute(var1_1);
                        var3_3 = var6_6[0].toString();
                    }
                }
                catch (Exception var6_7) {
                    var4_4.rollback();
                    if (ExternalKeyConverter.traceLogger == null) throw var6_7;
                    if (ExternalKeyConverter.traceLogger.isLogging() == false) throw var6_7;
                    ExternalKeyConverter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ExternalKeyConverter.className, var2_2, var6_7);
                    throw var6_7;
                }
            }
            catch (Throwable var8_8) {
                block14: {
                    var7_9 = null;
                    try {
                        if (var5_5 != null) {
                            var5_5.close();
                        }
                    }
                    catch (Exception var9_11) {
                        if (ExternalKeyConverter.traceLogger == null || !ExternalKeyConverter.traceLogger.isLogging()) break block14;
                        ExternalKeyConverter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ExternalKeyConverter.className, String.valueOf(var2_2) + " Error closing cursor: ", var9_11);
                    }
                }
                try {
                    if (var4_4 == null) throw var8_8;
                    var4_4.close();
                    throw var8_8;
                }
                catch (Exception var9_11) {
                    if (ExternalKeyConverter.traceLogger == null) throw var8_8;
                    if (ExternalKeyConverter.traceLogger.isLogging() == false) throw var8_8;
                    ExternalKeyConverter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ExternalKeyConverter.className, String.valueOf(var2_2) + " Error closing connection: ", var9_11);
                }
                throw var8_8;
            }
            {
                var7_10 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 113->126)] { 
lbl41:
            // 1 sources

            if (var5_5 != null) {
                var5_5.close();
            }
            break block15;
lbl44:
            // 1 sources

            catch (Exception var9_12) {
                if (ExternalKeyConverter.traceLogger == null || !ExternalKeyConverter.traceLogger.isLogging()) break block15;
                ExternalKeyConverter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ExternalKeyConverter.className, String.valueOf(var2_2) + " Error closing cursor: ", var9_12);
            }
        }
        try {}
        catch (Exception var9_12) {
            if (ExternalKeyConverter.traceLogger == null) return var3_3;
            if (ExternalKeyConverter.traceLogger.isLogging() == false) return var3_3;
            ExternalKeyConverter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ExternalKeyConverter.className, String.valueOf(var2_2) + " Error closing connection: ", var9_12);
            return var3_3;
        }
        if (var4_4 == null) return var3_3;
        var4_4.close();
        return var3_3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String runHBAQuery(Hashtable var0, Vector var1_1) throws Exception {
        block15: {
            var2_2 = "getHbas";
            var3_3 = new String();
            var4_4 = ServiceUtils.getConnection();
            var5_5 = null;
            try {
                try {
                    var5_5 = Hba.getCursor(var4_4, var0, var1_1);
                    while (var5_5.next()) {
                        var6_6 = var5_5.getAttribute(var1_1);
                        var3_3 = var6_6[0].toString();
                    }
                }
                catch (Exception var6_7) {
                    var4_4.rollback();
                    if (ExternalKeyConverter.traceLogger == null) throw var6_7;
                    if (ExternalKeyConverter.traceLogger.isLogging() == false) throw var6_7;
                    ExternalKeyConverter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ExternalKeyConverter.className, var2_2, var6_7);
                    throw var6_7;
                }
            }
            catch (Throwable var8_8) {
                block14: {
                    var7_9 = null;
                    try {
                        if (var5_5 != null) {
                            var5_5.close();
                        }
                    }
                    catch (Exception var9_11) {
                        if (ExternalKeyConverter.traceLogger == null || !ExternalKeyConverter.traceLogger.isLogging()) break block14;
                        ExternalKeyConverter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ExternalKeyConverter.className, String.valueOf(var2_2) + " Error closing cursor: ", var9_11);
                    }
                }
                try {
                    if (var4_4 == null) throw var8_8;
                    var4_4.close();
                    throw var8_8;
                }
                catch (Exception var9_11) {
                    if (ExternalKeyConverter.traceLogger == null) throw var8_8;
                    if (ExternalKeyConverter.traceLogger.isLogging() == false) throw var8_8;
                    ExternalKeyConverter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ExternalKeyConverter.className, String.valueOf(var2_2) + " Error closing connection: ", var9_11);
                }
                throw var8_8;
            }
            {
                var7_10 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 113->126)] { 
lbl41:
            // 1 sources

            if (var5_5 != null) {
                var5_5.close();
            }
            break block15;
lbl44:
            // 1 sources

            catch (Exception var9_12) {
                if (ExternalKeyConverter.traceLogger == null || !ExternalKeyConverter.traceLogger.isLogging()) break block15;
                ExternalKeyConverter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ExternalKeyConverter.className, String.valueOf(var2_2) + " Error closing cursor: ", var9_12);
            }
        }
        try {}
        catch (Exception var9_12) {
            if (ExternalKeyConverter.traceLogger == null) return var3_3;
            if (ExternalKeyConverter.traceLogger.isLogging() == false) return var3_3;
            ExternalKeyConverter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ExternalKeyConverter.className, String.valueOf(var2_2) + " Error closing connection: ", var9_12);
            return var3_3;
        }
        if (var4_4 == null) return var3_3;
        var4_4.close();
        return var3_3;
    }

    public static String frameKeyStorageSubsystem(String string, short s) {
        return new String(String.valueOf(ExternalKeyConverter.convertString(string)) + DELIMITER + s);
    }

    private static String convertString(String string) {
        string = string.replaceAll("\\\\", "\\\\\\\\");
        string = string.replaceAll("\\+", "\\\\+");
        return string;
    }
}

