/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.eclipse.aperi.gui.WrappingHeaderRenderer;

class ColumnGroup {
    protected TableCellRenderer renderer;
    protected Vector v;
    protected String text;
    protected int margin = 0;

    public ColumnGroup(String string) {
        this(null, string);
    }

    public ColumnGroup(TableCellRenderer tableCellRenderer, String string) {
        this.renderer = tableCellRenderer == null ? new WrappingHeaderRenderer() : tableCellRenderer;
        this.text = string;
        this.v = new Vector();
    }

    public void add(Object object) {
        if (object == null) {
            return;
        }
        this.v.addElement(object);
    }

    public Vector getColumnGroups(TableColumn tableColumn, Vector vector) {
        vector.addElement(this);
        if (this.v.contains(tableColumn)) {
            return vector;
        }
        Enumeration enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2;
            Object e = enumeration.nextElement();
            if (!(e instanceof ColumnGroup) || (vector2 = ((ColumnGroup)e).getColumnGroups(tableColumn, (Vector)vector.clone())) == null) continue;
            return vector2;
        }
        return null;
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.renderer;
    }

    public void setHeaderRenderer(TableCellRenderer tableCellRenderer) {
        if (tableCellRenderer != null) {
            this.renderer = tableCellRenderer;
        }
    }

    public Object getHeaderValue() {
        return this.text;
    }

    public Dimension getSize(JTable jTable) {
        Component component = this.renderer.getTableCellRendererComponent(jTable, this.getHeaderValue(), false, false, -1, -1);
        int n = component.getPreferredSize().height;
        int n2 = 0;
        Enumeration enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof TableColumn) {
                TableColumn tableColumn = (TableColumn)e;
                n2 += tableColumn.getWidth();
                n2 += this.margin;
                continue;
            }
            n2 += ((ColumnGroup)e).getSize((JTable)jTable).width - this.margin;
        }
        return new Dimension(n2, n);
    }

    public void setColumnMargin(int n) {
        this.margin = n;
        Enumeration enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof ColumnGroup)) continue;
            ((ColumnGroup)e).setColumnMargin(n);
        }
    }
}

