/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.eclipse.aperi.TStorm.gui.SavedReportDDI;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.PrintOptions;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.DDIremover;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.PrintComponent;
import org.eclipse.aperi.gui.PrintOutputChooser;
import org.eclipse.aperi.gui.PrintPreviewPanel;
import org.eclipse.aperi.gui.PrintPreviewable;
import org.eclipse.aperi.gui.PrintTableData;
import org.eclipse.aperi.gui.UilButtonPanelBean;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.server.guireq.UserPreferences;
import org.eclipse.aperi.xmsg.MessageLog;

public class DataDisplayInfo
implements Runnable,
ActionListener,
PrintPreviewable {
    public JComponent panel = null;
    public BaseTreeNode treeNode = null;
    private String description = MessageLog.getMessageNoID("GUI5004L");
    public String helpID = "welcome_gettingstarted";
    public boolean displayInScrollPane = true;
    public boolean displayUnsavedChangeMsg = true;
    protected PageFormat pf = null;
    protected int maxPageNumber = 1;
    protected int scale = 100;
    protected boolean imageRescaled = false;
    protected BufferedImage bi = null;
    protected Image img = null;
    protected JLabel creatorName = null;
    protected JLabel printTime = null;
    protected int pageableHeight = 0;
    protected static IGuiMain guiMain;
    private DataDisplayInfo prev = null;
    private DataDisplayInfo next = null;
    private DataDisplayInfo prevLRU = null;
    private DataDisplayInfo nextLRU = null;
    private boolean onDDIchain = false;
    private static DataDisplayInfo ddiRoot;
    private static DataDisplayInfo ddiCurr;
    private static int ddiCount;
    private static DataDisplayInfo ddiLastLRU;
    static boolean removeWithoutShow;
    private ButtonGroup radioGroup = null;
    public JDialog subMenuDialog = null;
    public Submenu[] submenus;
    private int actionButtonCount = 0;
    Hashtable radioButtons = null;
    private static boolean focusAlreadyLost;

    static {
        ddiRoot = null;
        ddiCurr = null;
        ddiCount = 0;
        ddiLastLRU = null;
        removeWithoutShow = false;
        focusAlreadyLost = true;
    }

    public DataDisplayInfo() {
        guiMain = GuiManager.getGuiManager().getGuiMain();
    }

    public DataDisplayInfo(String string) {
        this.description = string;
    }

    public String toString() {
        return this.description;
    }

    public void reDisplay() {
        this.show();
    }

    public void losingFocus() {
    }

    public void panelToBeNulled() {
    }

    public void goingAway() {
    }

    public boolean isEditable() {
        return false;
    }

    public boolean changesPending() {
        return false;
    }

    public void saveAndClose() {
    }

    public String getHelpID() {
        return this.helpID;
    }

    /*
     * WARNING - void declaration
     */
    public void printData(Container container) {
        Component[] componentArray;
        Container container2 = null;
        MegaTable megaTable = null;
        JTabbedPane jTabbedPane = null;
        int n2 = 0;
        if (container != null) {
            container2 = container;
        } else {
            void var7_8;
            if (this.panel instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)this.panel;
                n2 = jTabbedPane.getSelectedIndex();
                jTabbedPane.getTitleAt(n2);
                jTabbedPane.getIconAt(n2);
                container2 = (Container)jTabbedPane.getComponentAt(n2);
            } else {
                container2 = this.panel;
            }
            componentArray = container2.getComponents();
            boolean n = false;
            while (var7_8 < componentArray.length) {
                if (componentArray[var7_8] instanceof MegaTable) {
                    megaTable = (MegaTable)componentArray[var7_8];
                    break;
                }
                ++var7_8;
            }
        }
        if (megaTable != null && ((BaseTableModel)megaTable.getDataSource()).getAdjuster() != null) {
            PrintTableData.printTable(this, megaTable, GuiUtil.getUserName(), this.description, this.description);
        } else {
            boolean bl;
            Object object;
            componentArray = new PrintOutputChooser();
            boolean bl2 = false;
            if (this instanceof SavedReportDDI) {
                object = (SavedReportDDI)this;
                bl = ((SavedReportDDI)object).getPdfAllowed();
            }
            if ((object = componentArray.getOptions(false, bl)) != null) {
                if (container != null) {
                    container2 = DataDisplayInfo.guiMain.getNullDDI().panel;
                }
                if (((PrintOptions)object).outputType == 1) {
                    new PrintPreviewPanel(this, this.description, true);
                    return;
                }
                PrintComponent.print((PrintOptions)object, container2, GuiUtil.getUserName(), null, this.description, true);
            }
        }
    }

    public int fitToPage(PageFormat pageFormat) {
        int n = this.panel.getWidth();
        int n2 = this.panel.getHeight();
        int n3 = (int)pageFormat.getImageableWidth();
        if (this.pageableHeight == 0) {
            this.pageableHeight = (int)pageFormat.getImageableHeight();
        }
        int n4 = this.bi.getWidth(this);
        int n5 = this.bi.getHeight(this);
        double d = Math.min((double)n3 / (double)n4, 1.0);
        double d2 = Math.min((double)this.pageableHeight / (double)n5, 1.0);
        this.scale = (int)(Math.min(d, d2) * 100.0);
        this.img = this.bi.getScaledInstance(n * this.scale / 100, n2 * this.scale / 100, 4);
        this.img.flush();
        this.imageRescaled = false;
        return this.scale;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (this.panel == null) {
            return 1;
        }
        this.pf = pageFormat;
        int n2 = this.panel.getWidth();
        int n3 = this.panel.getHeight();
        if (n2 == 0 || n3 == 0) {
            n2 = this.panel.getPreferredSize().width;
            n3 = this.panel.getPreferredSize().height;
        }
        if (this.bi == null) {
            this.bi = new BufferedImage(n2, n3, 1);
            Color color = this.panel.getBackground();
            this.panel.setBackground(Color.white);
            this.panel.paint(this.bi.createGraphics());
            this.panel.setBackground(color);
            this.img = this.bi.getScaledInstance(n2 * this.scale / 100, n3 * this.scale / 100, 4);
            this.img.flush();
            this.imageRescaled = false;
        }
        if (n >= this.maxPageNumber || this.bi == null) {
            return 1;
        }
        if (this.imageRescaled) {
            this.img = this.bi.getScaledInstance(n2 * this.scale / 100, n3 * this.scale / 100, 4);
            this.img.flush();
            this.imageRescaled = false;
        }
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        int n4 = (int)pageFormat.getImageableWidth();
        int n5 = (int)pageFormat.getImageableHeight();
        int n6 = this.img.getWidth(this);
        int n7 = this.img.getHeight(this);
        if (n6 == 0 || n7 == 0) {
            return 1;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.panel.getFont());
        int n8 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        int n9 = n8 * 2;
        this.pageableHeight = n5 - (n8 + n9 + fontMetrics.getAscent());
        int n10 = Math.max((int)Math.ceil((double)n6 / (double)n4), 1);
        int n11 = Math.max((int)Math.ceil((double)n7 / (double)this.pageableHeight), 1);
        this.maxPageNumber = n10 * n11;
        int n12 = n % n10;
        int n13 = n / n10;
        int n14 = n12 * n4;
        int n15 = n13 * this.pageableHeight;
        int n16 = Math.min(n4, n6 - n14);
        int n17 = Math.min(this.pageableHeight, n7 - n15);
        graphics.setColor(Color.black);
        if (n == 0) {
            graphics.drawString(String.valueOf(PrintPreviewable.CREATED_BY) + " " + GuiUtil.getUserName() + "     " + PrintPreviewable.PRINTED_ON + " " + Util.formatDateTime(new Date()), 0, fontMetrics.getAscent());
        }
        graphics.drawImage(this.img, 0, n9, n16, n17 + n9, n14, n15 += n9, n14 + n16, n15 + n17, this);
        graphics.drawString(Util.getString("LABEL_PAGE_X_OF_Y", Integer.toString(n + 1), Integer.toString(this.maxPageNumber)), 0, (int)(pageFormat.getImageableHeight() - (double)fontMetrics.getMaxDescent()));
        return 0;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return true;
    }

    public void run() {
    }

    public static DataDisplayInfo getCurrent() {
        return ddiCurr;
    }

    public DataDisplayInfo getPrev() {
        return this.prev;
    }

    public DataDisplayInfo getNext() {
        return this.next;
    }

    public static DataDisplayInfo getRoot() {
        return ddiRoot;
    }

    public final void loseFocus() {
        if (!focusAlreadyLost) {
            focusAlreadyLost = true;
            this.losingFocus();
        }
    }

    public void show() {
        if (this.addToChain()) {
            if (ddiCurr != null) {
                ddiCurr.loseFocus();
            }
            ddiCurr = this;
            this.makeLastLRU();
            DataDisplayInfo.makePanelsNull();
            guiMain.setView(this);
            focusAlreadyLost = false;
        } else {
            this.remove();
        }
    }

    public final void currentPanelReplaced() {
        if (ddiCurr == this) {
            guiMain.setView(this);
        } else {
            this.show();
        }
    }

    private final boolean addToChain() {
        guiMain = GuiManager.getGuiManager().getGuiMain();
        if (this.onDDIchain) {
            return true;
        }
        this.onDDIchain = true;
        DDIremover dDIremover = null;
        UserPreferences userPreferences = guiMain.getUserPrefs();
        if (userPreferences == null) {
            System.out.println("Pref is null");
        }
        if (++ddiCount > DataDisplayInfo.guiMain.getUserPrefs().maxDDIs) {
            if (ddiRoot != null && !ddiRoot.changesPending()) {
                removeWithoutShow = true;
                ddiRoot.remove();
                removeWithoutShow = false;
            } else {
                dDIremover = new DDIremover();
                if (!dDIremover.wasDDIremoved) {
                    return false;
                }
                dDIremover.dispose();
            }
        }
        if (this.treeNode == null) {
            this.treeNode = (BaseTreeNode)BaseTree.pBaseTree.getLastSelectedPathComponent();
            if (this.treeNode != null) {
                if (this instanceof CreateOrEditDDI) {
                    Object object;
                    CreateOrEditDDI createOrEditDDI = (CreateOrEditDDI)this;
                    if (!(createOrEditDDI.ID == 0 || (object = this.treeNode.getUserObject()) instanceof NameList && ((NameList)object).nlID == createOrEditDDI.ID)) {
                        this.treeNode = null;
                    }
                }
                if (this.treeNode != null && this.treeNode.ddi == null) {
                    this.treeNode.ddi = this;
                }
            }
        }
        this.prev = ddiCurr;
        if (ddiCurr != null) {
            this.next = DataDisplayInfo.ddiCurr.next;
            DataDisplayInfo.ddiCurr.next = this;
            if (this.next != null) {
                this.next.prev = this;
            }
        } else {
            this.next = null;
        }
        if (ddiRoot == null) {
            ddiRoot = this;
        }
        return true;
    }

    private final void makeLastLRU() {
        if (ddiLastLRU != this) {
            if (this.prevLRU != null) {
                this.prevLRU.nextLRU = this.nextLRU;
            }
            if (this.nextLRU != null) {
                this.nextLRU.prevLRU = this.prevLRU;
            }
            this.prevLRU = ddiLastLRU;
            if (ddiLastLRU != null) {
                DataDisplayInfo.ddiLastLRU.nextLRU = this;
            }
            this.nextLRU = null;
            ddiLastLRU = this;
        }
    }

    public final void nullOutPanel() {
        if (this.panel != null) {
            this.panelToBeNulled();
            this.panel = null;
        }
    }

    private static void makePanelsNull() {
        DataDisplayInfo dataDisplayInfo = ddiLastLRU;
        int n = 1;
        while (dataDisplayInfo != null) {
            if (n++ > DataDisplayInfo.guiMain.getUserPrefs().maxPanels) {
                dataDisplayInfo.nullOutPanel();
            }
            dataDisplayInfo = dataDisplayInfo.prevLRU;
        }
    }

    public final void remove() {
        if (this.prevLRU != null) {
            this.prevLRU.nextLRU = this.nextLRU;
        }
        if (this.nextLRU != null) {
            this.nextLRU.prevLRU = this.prevLRU;
        }
        if (ddiLastLRU == this) {
            ddiLastLRU = this.prevLRU;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        }
        if (this.prev != null) {
            this.prev.next = this.next;
        }
        if (ddiRoot == this) {
            ddiRoot = this.next;
        }
        if (this.treeNode != null && this.treeNode.ddi == this) {
            this.treeNode.ddi = null;
        }
        --ddiCount;
        if (ddiCurr == this) {
            this.loseFocus();
            DataDisplayInfo dataDisplayInfo = ddiCurr = this.prev != null ? this.prev : this.next;
            if (!removeWithoutShow) {
                if (ddiCurr == null) {
                    guiMain.showNull();
                } else {
                    ddiCurr.reDisplay();
                }
            }
        } else if (!removeWithoutShow) {
            guiMain.setPrevNext();
        }
        this.goingAway();
        this.onDDIchain = false;
    }

    public final boolean fileClose() {
        boolean bl = true;
        if (this.displayUnsavedChangeMsg && guiMain.isProperAdmin() && this.changesPending()) {
            String string = MessageLog.getMessageNoID("GUI5017L");
            int n = JOptionPane.showConfirmDialog(guiMain.getFrame(), string, this.description, 1);
            switch (n) {
                case 1: {
                    break;
                }
                case 0: {
                    this.saveAndClose();
                }
                default: {
                    bl = false;
                }
            }
        }
        if (bl) {
            this.remove();
        }
        return bl;
    }

    public static void removeAllWithoutChanges() {
        DataDisplayInfo dataDisplayInfo = ddiRoot;
        removeWithoutShow = true;
        while (dataDisplayInfo != null) {
            DataDisplayInfo dataDisplayInfo2 = dataDisplayInfo.next;
            if (!dataDisplayInfo.changesPending()) {
                dataDisplayInfo.remove();
            }
            dataDisplayInfo = dataDisplayInfo2;
        }
        removeWithoutShow = false;
    }

    public void createAndShowButtonSubMenu() {
        if (this.submenus[0] != null) {
            String string = null;
            JMenuItem jMenuItem = null;
            JRadioButton jRadioButton = null;
            this.radioGroup = new ButtonGroup();
            this.subMenuDialog = new JDialog(guiMain.getFrame(), true);
            GuiUtil.centerDialog(this.subMenuDialog);
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new GridLayout());
            JPanel jPanel3 = new JPanel(new FlowLayout());
            Container container = this.subMenuDialog.getContentPane();
            this.radioButtons = new Hashtable();
            JMenu jMenu = this.submenus[0].menu;
            JPopupMenu jPopupMenu = jMenu.getPopupMenu();
            int n = jPopupMenu.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz;
                jMenuItem = (JMenuItem)jPopupMenu.getComponent(n2);
                string = jMenuItem.getName();
                jRadioButton = n2 == 0 ? new JRadioButton(string, true) : new JRadioButton(string, false);
                jRadioButton.setActionCommand(jMenuItem.getActionCommand());
                try {
                    clazz = Class.forName("java.awt.event.ActionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                ActionListener[] actionListenerArray = (ActionListener[])jMenuItem.getListeners(clazz);
                if (actionListenerArray.length > 0) {
                    this.radioButtons.put(jMenuItem.getActionCommand(), actionListenerArray[0]);
                }
                this.radioGroup.add(jRadioButton);
                jPanel2.add(jRadioButton);
                ++n2;
            }
            jPanel.add((Component)jPanel2, "Center");
            JButton jButton = new JButton(Util.getString("LABEL_OK"));
            jButton.addActionListener(this);
            jPanel3.add(jButton);
            jButton = new JButton(Util.getString("LABEL_CANCEL"));
            jButton.addActionListener(this);
            jPanel3.add(jButton);
            jPanel.add((Component)jPanel3, "South");
            container.add(jPanel);
            this.subMenuDialog.pack();
            this.subMenuDialog.setVisible(true);
        }
    }

    public JPanel getButtonPanel(JPopupMenu jPopupMenu) {
        UilButtonPanelBean uilButtonPanelBean = new UilButtonPanelBean();
        uilButtonPanelBean.setSpacerSize(4);
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.setBorder(new CompoundBorder(new EmptyBorder(4, 2, 6, 2), GuiUtil.getBorder()));
        jPanel.add(uilButtonPanelBean);
        JButton jButton = null;
        String string = null;
        Component component = null;
        int n = jPopupMenu.getComponentCount();
        n = 0;
        int n2 = 0;
        while (n2 < n) {
            component = jPopupMenu.getComponent(n2);
            jButton = new JButton();
            jButton.setToolTipText(((JMenuItem)component).getToolTipText());
            string = component.getName();
            if (component.isEnabled()) {
                Object object;
                if (component instanceof JMenu) {
                    jButton.setText(String.valueOf(string) + "...");
                    jButton.addActionListener(this);
                    if (this.submenus == null) {
                        this.submenus = new Submenu[1];
                    }
                    object = new Submenu();
                    object.name = jButton.getText();
                    object.menu = (JMenu)component;
                    this.submenus[0] = object;
                } else {
                    Class<?> clazz;
                    jButton.setText(string);
                    jButton.setActionCommand(((JMenuItem)component).getActionCommand());
                    try {
                        clazz = Class.forName("java.awt.event.ActionListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    object = (ActionListener[])component.getListeners(clazz);
                    int n3 = 0;
                    while (n3 < ((ActionListener[])object).length) {
                        jButton.addActionListener(object[n3]);
                        ++n3;
                    }
                }
                uilButtonPanelBean.add(jButton);
                ++this.actionButtonCount;
            }
            ++n2;
        }
        return jPanel;
    }

    public int getActionButtonCount() {
        return this.actionButtonCount;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(Util.getString("LABEL_CANCEL"))) {
            if (this.subMenuDialog != null) {
                this.subMenuDialog.dispose();
            }
        } else if (actionEvent.getActionCommand().equals(Util.getString("LABEL_OK"))) {
            if (this.subMenuDialog != null) {
                this.subMenuDialog.dispose();
            }
            ButtonModel buttonModel = this.radioGroup.getSelection();
            String string = buttonModel.getActionCommand();
            ActionListener actionListener = (ActionListener)this.radioButtons.get(string);
            JRadioButton jRadioButton = new JRadioButton();
            jRadioButton.addActionListener(actionListener);
            jRadioButton.setActionCommand(string);
            jRadioButton.doClick();
        } else if (actionEvent.getActionCommand().equals(Util.getString("LABEL_SAVE"))) {
            if (this.subMenuDialog != null) {
                this.subMenuDialog.dispose();
            }
        } else {
            this.createAndShowButtonSubMenu();
        }
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
        this.imageRescaled = true;
    }

    public BufferedImage getBufferedImage() {
        return this.bi;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        this.bi = bufferedImage;
    }

    public int getNumberOfPages() {
        return this.maxPageNumber;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.pf;
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    public String getDescription() {
        return Util.getTranslatedName(this.description);
    }

    public String getTrueDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public class Submenu {
        public String name;
        public JMenu menu;
    }
}

