/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiUtil;

public class SpinBox
extends GridBagPanel {
    private int startValue;
    private int minimumValue;
    private int maximumValue;
    private int incrementerValue;
    private FormattedTextField textField;
    private JButton up = new JButton();
    private JButton down = new JButton();
    private JPanel buttonPanel = new JPanel();
    private boolean minuteFormat = false;
    private ArrayList listeners = new ArrayList();

    public SpinBox() {
        this(0, 0, 100, 1);
    }

    public SpinBox(int n, int n2) {
        this(n, n, n2, 1);
    }

    public SpinBox(int n, int n2, int n3) {
        this(n, n2, n3, 1);
    }

    public SpinBox(int n, int n2, int n3, int n4) {
        super(new Insets(0, 0, 0, 0));
        if (n2 < 0 || n3 < n2 || n < n2 || n > n3 || n4 > n3) {
            throw new IllegalArgumentException("Invalid initial parameters for SpinBox");
        }
        this.startValue = n;
        this.minimumValue = n2;
        this.maximumValue = n3;
        this.incrementerValue = n4;
        this.setDefaultAnchor(21);
        this.setup();
    }

    private void setup() {
        this.textField = new FormattedTextField();
        this.setBorder(this.textField.getBorder());
        this.textField.setBorder(null);
        this.up.setBorder(null);
        this.down.setBorder(null);
        this.up.setIcon(GuiUtil.createImageIcon("SpinBoxButtonUp.gif"));
        this.down.setIcon(GuiUtil.createImageIcon("SpinBoxButtonDown.gif"));
        this.up.setPreferredSize(new Dimension(9, this.textField.getPreferredSize().height / 2));
        this.down.setPreferredSize(new Dimension(9, this.textField.getPreferredSize().height / 2));
        this.up.setFocusPainted(false);
        this.down.setFocusPainted(false);
        this.up.setBackground(this.textField.getBackground());
        this.down.setBackground(this.textField.getBackground());
        this.up.addMouseListener(new MouseListener(){
            Timer timer = new Timer(50, new ActionListener(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (1.access$0(this.this$1).isEnabled()) {
                        SpinBox.access$3(1.access$0(this.this$1));
                    }
                }
            });

            public void mousePressed(MouseEvent mouseEvent) {
                this.timer.setInitialDelay(500);
                this.timer.start();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.timer.stop();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SpinBox.this.isEnabled()) {
                    SpinBox.this.increment();
                }
            }

            static /* synthetic */ SpinBox access$0(1 var0) {
                return var0.SpinBox.this;
            }
        });
        this.down.addMouseListener(new MouseListener(){
            Timer timer2 = new Timer(50, new ActionListener(this){
                final /* synthetic */ 3 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (3.access$0(this.this$1).isEnabled()) {
                        SpinBox.access$4(3.access$0(this.this$1));
                    }
                }
            });

            public void mousePressed(MouseEvent mouseEvent) {
                this.timer2.setInitialDelay(500);
                this.timer2.start();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.timer2.stop();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SpinBox.this.isEnabled()) {
                    SpinBox.this.decrement();
                }
            }

            static /* synthetic */ SpinBox access$0(3 var0) {
                return var0.SpinBox.this;
            }
        });
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38) {
                    SpinBox.this.increment();
                } else if (keyEvent.getKeyCode() == 40) {
                    SpinBox.this.decrement();
                }
            }
        });
        this.textField.addFocusListener(new FocusListener(){
            boolean time = true;

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                if (!SpinBox.this.isValid(SpinBox.this.textField.getText())) {
                    SpinBox.this.setToStartValue();
                }
            }
        });
        this.add(this.textField);
        this.buttonPanel.setLayout(new BorderLayout());
        this.buttonPanel.add((Component)this.up, "North");
        this.buttonPanel.add((Component)this.down, "South");
        this.add((JComponent)this.buttonPanel, 0);
        this.setBackground(this.textField.getBackground());
        this.textField.setText(Integer.toString(this.maximumValue));
        JComboBox jComboBox = new JComboBox();
        this.textField.setPreferredSize(new Dimension(this.textField.getPreferredSize().width, jComboBox.getPreferredSize().height - 4));
        this.textField.setMinimumSize(this.textField.getPreferredSize());
        this.textField.setText(Integer.toString(this.startValue));
    }

    protected void fireActionEvent() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, "SpinBoxAction");
        int n = 0;
        while (n < this.listeners.size()) {
            ((ActionListener)this.listeners.get(n)).actionPerformed(actionEvent);
            ++n;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    public void setLeadingZero(boolean bl) {
        this.minuteFormat = bl;
        this.textField.setText(this.textField.getText());
    }

    public void setToStartValue() {
        this.textField.setText(new Integer(this.startValue).toString());
    }

    public void setColumns(int n) {
        this.textField.setColumns(n);
    }

    private void increment() {
        String string = this.textField.getText();
        int n = Integer.parseInt(string) + this.incrementerValue;
        if (this.isValid(n)) {
            this.textField.setText(new Integer(n).toString());
        }
        this.fireActionEvent();
    }

    private void decrement() {
        String string = this.textField.getText();
        int n = Integer.parseInt(string) - this.incrementerValue;
        if (this.isValid(n)) {
            this.textField.setText(Integer.toString(n));
        }
        this.fireActionEvent();
    }

    public boolean isValid(int n) {
        try {
            return n >= this.minimumValue && n <= this.maximumValue;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isValid(String string) {
        try {
            return this.isValid(Integer.parseInt(string));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isValid() {
        try {
            return this.isValid(this.textField.getText());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setMin(int n) {
        this.minimumValue = n;
    }

    public void setMax(int n) {
        this.maximumValue = n;
    }

    public int getMin() {
        return this.minimumValue;
    }

    public int getMax() {
        return this.maximumValue;
    }

    public int getIncrementer() {
        return this.incrementerValue;
    }

    public void setIncrementer(int n) {
        this.incrementerValue = n;
    }

    public int getValue() {
        String string = this.textField.getText();
        return Integer.parseInt(string);
    }

    public String getText() {
        String string = this.textField.getText();
        return string;
    }

    public void setValue(int n) {
        this.textField.setText(Integer.toString(n));
    }

    public void setEnabled(boolean bl) {
        this.up.setEnabled(bl);
        this.down.setEnabled(bl);
        this.textField.setEnabled(bl);
        super.setEnabled(bl);
        this.up.setBackground(this.textField.getBackground());
        this.down.setBackground(this.textField.getBackground());
    }

    public class FormattedTextField
    extends JTextField {
        protected Document createDefaultModel() {
            return new RangeValidatorDocument();
        }

        public void setText(String string) {
            if (SpinBox.this.minuteFormat) {
                int n = Integer.parseInt(string);
                if (n >= 0 && n <= 9) {
                    super.setText("0" + string);
                } else {
                    super.setText(string);
                }
            } else {
                super.setText(string);
            }
        }

        class RangeValidatorDocument
        extends PlainDocument {
            private boolean first = true;
            private Timer checker;
            private Thread checkThread;

            RangeValidatorDocument() {
            }

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (this.first) {
                    this.first = false;
                    super.insertString(n, string, attributeSet);
                    return;
                }
                if (string == null) {
                    return;
                }
                try {
                    Integer.parseInt(string);
                }
                catch (Exception exception) {
                    this.handleProblem();
                    return;
                }
                if (this.getLength() + string.length() > new Integer(SpinBox.this.maximumValue).toString().length()) {
                    this.handleProblem();
                    return;
                }
                if (Integer.parseInt(String.valueOf(SpinBox.this.textField.getText(0, this.getLength())) + string) > SpinBox.this.maximumValue) {
                    this.handleProblem();
                    return;
                }
                super.insertString(n, string, attributeSet);
            }

            private void handleProblem() {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

