/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.admin.agent.AgentListDDI;
import org.eclipse.aperi.gui.admin.agent.CimomAgentListPanel;
import org.eclipse.aperi.gui.common.CIMOMMgmtAgentTreeLabel;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.common.CIMOMMgmtUpdateCIMOMReq;

public class CIMOMMgmtAddCIMOMDialog
extends JDialog
implements ActionListener,
DocumentListener,
GuiRequestor {
    private static final String CANCEL_ACTION = Util.getString("LABEL_CANCEL");
    private static final String SAVE_ACTION = Util.getString("LABEL_SAVE");
    protected static final String IP = Util.getString("LABEL_CIMOM_HOSTNAME");
    protected static final String PORT = Util.getString("LABEL_CIMOM_PORT");
    protected static final String USER_ID = Util.getString("CIMOM_MGMT_USER_ID_LABEL");
    protected static final String PASSWORD = Util.getString("CIMOM_MGMT_PASSWORD_LABEL");
    protected static final String PASSWORD_CONFIRM = Util.getString("CIMOM_MGMT_PASSWORD_CONFIRM_LABEL");
    protected static final String INTEROP_SCHEMA_NAMESPACE = Util.getString("CIMOM_MGMT_INTEROP_SCHEMA_NAMESPACE_LABEL");
    protected static final String PROTOCOL = Util.getString("CIMOM_MGMT_PROTOCOL_LABEL");
    protected static final String TRUSTSTORE_LOCATION = Util.getString("CIMOM_MGMT_TRUSTSTORE_LOCATION_LABEL");
    protected static final String TRUSTSTORE_PASSPHRASE = Util.getString("CIMOM_MGMT_TRUSTSTORE_PASSPHRASE_LABEL");
    protected static final String DISPLAY_NAME = Util.getString("CIMOM_MGMT_DISPLAY_NAME_LABEL");
    protected static final String DESCRIPTION = Util.getString("CIMOM_MGMT_DESCRIPTION_LABEL");
    protected static final String CHECKBOX_LABEL = Util.getString("CIMOM_MGT_TESTBEFORE_ADD_LABEL");
    private static final int DEFAULT_COLUMN_WIDTH = 20;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String[] PROTOCOL_CHOICES = new String[]{"https", "http"};
    private static final String FIELD = "CIMOM_FIELD";
    private static final String DEFAULT_PORT = "5989";
    private static final int LOWEST_PORT = 0;
    private static final int HIGHEST_PORT = Integer.MAX_VALUE;
    private static final String DEFAULT_NAMESPACE = "/root/ibm";
    private static final String DEFAULT_PORT_HTTPS = "5989";
    private static final String DEFAULT_PORT_HTTP = "5988";
    private boolean portHasBeenModifiedByUser = false;
    HashMap model = new HashMap();
    JButton saveButton;
    JButton cancelButton;
    CIMOMMgmtAgentTreeLabel treeNode;
    AgentListDDI ddi;

    public CIMOMMgmtAddCIMOMDialog(Frame frame, String string, CIMOMMgmtAgentTreeLabel cIMOMMgmtAgentTreeLabel) throws HeadlessException {
        super(frame, string);
        this.treeNode = cIMOMMgmtAgentTreeLabel;
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.buildPanel(this.getContentPane());
        this.validateAndEnable(null);
        this.pack();
        GuiUtil.centerDialog(this);
        this.configureHelp();
        this.portHasBeenModifiedByUser = false;
        this.equalizeFieldsSize();
        this.setVisible(true);
    }

    public CIMOMMgmtAddCIMOMDialog(Frame frame, String string, AgentListDDI agentListDDI) throws HeadlessException {
        super(frame, string);
        this.ddi = agentListDDI;
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.buildPanel(this.getContentPane());
        this.validateAndEnable(null);
        this.pack();
        GuiUtil.centerDialog(this);
        this.configureHelp();
        this.portHasBeenModifiedByUser = false;
        this.equalizeFieldsSize();
        this.setVisible(true);
    }

    private void buildPanel(Container container) {
        container.add((Component)this.buildCimomPanel(), "North");
        container.add((Component)this.buildButtonPanel(), "South");
    }

    private JPanel buildCimomPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(this.buildGridBag(), "Before");
        return jPanel;
    }

    private Component buildGridBag() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        this.buildTextRow(gridBagPanel, IP, true);
        this.buildTextRow(gridBagPanel, PORT, "5989", false);
        this.buildTextRow(gridBagPanel, USER_ID, false);
        this.buildPasswordRow(gridBagPanel, PASSWORD, false);
        this.buildPasswordRow(gridBagPanel, PASSWORD_CONFIRM, false);
        this.buildTextRow(gridBagPanel, INTEROP_SCHEMA_NAMESPACE, DEFAULT_NAMESPACE, true);
        this.buildComboboxRow(gridBagPanel, PROTOCOL, PROTOCOL_CHOICES);
        this.buildTextRow(gridBagPanel, TRUSTSTORE_LOCATION, false);
        this.buildPasswordRow(gridBagPanel, TRUSTSTORE_PASSPHRASE, false);
        this.buildTextRow(gridBagPanel, DISPLAY_NAME, false);
        this.buildTextRow(gridBagPanel, DESCRIPTION, false);
        this.buildCheckboxRow(gridBagPanel, CHECKBOX_LABEL, true);
        gridBagPanel.createStretchBox();
        return gridBagPanel;
    }

    protected void buildTextRow(GridBagPanel gridBagPanel, String string, boolean bl) {
        this.buildTextRow(gridBagPanel, string, null, bl);
    }

    protected void buildTextRow(GridBagPanel gridBagPanel, String string, String string2, boolean bl) {
        JTextField jTextField = new JTextField(string2);
        this.buildRowWithTextField(gridBagPanel, string, jTextField, bl);
    }

    protected void buildPasswordRow(GridBagPanel gridBagPanel, String string, boolean bl) {
        JPasswordField jPasswordField = new JPasswordField();
        this.buildRowWithTextField(gridBagPanel, string, jPasswordField, bl);
    }

    private void buildRowWithTextField(GridBagPanel gridBagPanel, String string, JTextField jTextField, boolean bl) {
        gridBagPanel.add(bl ? new BoldLabel(string) : new JLabel(string));
        jTextField.setColumns(20);
        this.addEditListeners(string, jTextField);
        gridBagPanel.add(jTextField);
        this.model.put(string, jTextField);
        gridBagPanel.newRow();
    }

    private void buildComboboxRow(GridBagPanel gridBagPanel, String string, String[] stringArray) {
        gridBagPanel.add(new JLabel(string));
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setPreferredSize(new Dimension(50, 20));
        jComboBox.setEditable(false);
        jComboBox.setActionCommand(string);
        jComboBox.addActionListener(this);
        gridBagPanel.add(jComboBox);
        this.model.put(string, jComboBox);
        gridBagPanel.newRow();
    }

    private void buildCheckboxRow(GridBagPanel gridBagPanel, String string, boolean bl) {
        gridBagPanel.add(new JLabel(string));
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(bl);
        jCheckBox.setActionCommand(string);
        jCheckBox.addActionListener(this);
        gridBagPanel.add(jCheckBox);
        this.model.put(string, jCheckBox);
        gridBagPanel.newRow();
    }

    private void addEditListeners(String string, JTextField jTextField) {
        jTextField.setActionCommand(string);
        jTextField.addActionListener(this);
        jTextField.getDocument().addDocumentListener(this);
        jTextField.getDocument().putProperty(FIELD, string);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.validateAndEnable((String)documentEvent.getDocument().getProperty(FIELD));
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateAndEnable((String)documentEvent.getDocument().getProperty(FIELD));
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.validateAndEnable((String)documentEvent.getDocument().getProperty(FIELD));
    }

    public void handleResponse(short s, Response response) {
        if (s <= 4) {
            this.setVisible(false);
            if (this.treeNode != null) {
                this.treeNode.buildCIMOMList((CIMOM[])response.responseData);
            } else if (this.ddi != null && this.ddi.panel != null) {
                ((CimomAgentListPanel)this.ddi.panel).getTableModel().refreshCimoms(s, response, true, this.ddi);
            }
            this.dispose();
        } else {
            this.enableSaveAndCancelButtons(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(CANCEL_ACTION)) {
            this.setVisible(false);
            this.dispose();
        } else if (actionEvent.getActionCommand().equals(SAVE_ACTION)) {
            Request request = GuiUtil.newGUIDeviceRequest("org.eclipse.aperi.server.handler.gui.cimom.CIMOMMgmtAddCIMOMsHandler");
            request.requestData = this.getCIMOMFromPanel();
            this.enableSaveAndCancelButtons(false);
            GuiClient.doRequest(this, request);
        } else {
            this.validateAndEnable(actionEvent.getActionCommand());
        }
    }

    private CIMOMMgmtUpdateCIMOMReq getCIMOMFromPanel() {
        CIMOM cIMOM = new CIMOM();
        cIMOM.setServiceUrl(this.getServiceUrl());
        cIMOM.setUserId(this.getTextFromField(USER_ID));
        cIMOM.setPassword(this.getTextFromField(PASSWORD));
        cIMOM.setProtocol(this.getTextFromCombo(PROTOCOL));
        cIMOM.setDisplayName(this.getTextFromField(DISPLAY_NAME));
        cIMOM.setDescription(this.getTextFromField(DESCRIPTION));
        cIMOM.setInteropSchemaNamespace(this.getTextFromField(INTEROP_SCHEMA_NAMESPACE));
        if (cIMOM.getProtocol().equals(HTTPS)) {
            cIMOM.setTrustStoreLocation(this.getTextFromField(TRUSTSTORE_LOCATION));
            cIMOM.setTrustStoreLocation(this.getTextFromField(TRUSTSTORE_PASSPHRASE));
        }
        return new CIMOMMgmtUpdateCIMOMReq(cIMOM, this.getStateFromCheckBox(CHECKBOX_LABEL));
    }

    private String getServiceUrl() {
        StringBuffer stringBuffer = new StringBuffer(this.getTextFromCombo(PROTOCOL));
        stringBuffer.append("://").append(this.getTextFromField(IP));
        String string = this.getTextFromField(PORT);
        if (string != null && string.length() != 0) {
            stringBuffer.append(":").append(string);
        }
        return stringBuffer.toString();
    }

    private String getTextFromCombo(String string) {
        return (String)((JComboBox)this.model.get(string)).getSelectedItem();
    }

    private boolean getStateFromCheckBox(String string) {
        return ((JCheckBox)this.model.get(string)).isSelected();
    }

    private String getTextFromField(String string) {
        String string2 = this.getTextField(string).getText();
        return string2 != null ? string2.trim() : null;
    }

    private JTextField getTextField(String string) {
        return (JTextField)this.model.get(string);
    }

    private void validateAndEnable(String string) {
        JTextField jTextField;
        String string2;
        if (PORT.equals(string)) {
            this.portHasBeenModifiedByUser = true;
        } else if (PROTOCOL.equals(string) && !this.portHasBeenModifiedByUser) {
            if (this.getTextFromCombo(PROTOCOL).equals(HTTPS)) {
                this.getTextField(PORT).setText("5989");
            } else {
                this.getTextField(PORT).setText(DEFAULT_PORT_HTTP);
            }
            this.portHasBeenModifiedByUser = false;
        }
        boolean bl = this.validString(this.getTextFromField(IP)) && this.validString(this.getTextFromField(INTEROP_SCHEMA_NAMESPACE));
        if (!this.validPort(this.getTextFromField(PORT))) {
            bl = false;
            this.getTextField(PORT).setBorder(BorderFactory.createBevelBorder(1, Color.RED, Color.BLACK));
        } else {
            this.getTextField(PORT).setBorder(BorderFactory.createBevelBorder(1));
        }
        boolean bl2 = this.getTextFromCombo(PROTOCOL).equals(HTTPS);
        this.getTextField(TRUSTSTORE_LOCATION).setEditable(bl2);
        this.getTextField(TRUSTSTORE_PASSPHRASE).setEditable(bl2);
        JTextField jTextField2 = this.getTextField(PASSWORD);
        String string3 = jTextField2.getText();
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = (jTextField = this.getTextField(PASSWORD_CONFIRM)).getText()) == null) {
            string2 = "";
        }
        if (!string3.equals(string2)) {
            jTextField2.setBorder(BorderFactory.createBevelBorder(1, Color.RED, Color.BLACK));
            jTextField.setBorder(BorderFactory.createBevelBorder(1, Color.RED, Color.BLACK));
            bl = false;
        } else {
            jTextField2.setBorder(BorderFactory.createBevelBorder(1));
            jTextField.setBorder(BorderFactory.createBevelBorder(1));
        }
        this.saveButton.setEnabled(bl);
    }

    private boolean validPort(String string) {
        return string == null || string.trim().length() == 0 || this.isNumber(string.trim());
    }

    private boolean validString(String string) {
        return string != null & string.trim().length() != 0;
    }

    private boolean isNumber(String string) {
        boolean bl = false;
        try {
            int n = Integer.parseInt(string);
            bl = n >= 0 && n <= Integer.MAX_VALUE;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout());
        this.saveButton = new JButton(SAVE_ACTION);
        jPanel.add(this.buildButton(this.saveButton));
        this.saveButton.setEnabled(false);
        this.cancelButton = new JButton(CANCEL_ACTION);
        jPanel.add(this.buildButton(this.cancelButton));
        this.cancelButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_CANCEL"));
        this.saveButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_SAVE"));
        return jPanel;
    }

    private JButton buildButton(JButton jButton) {
        jButton.setActionCommand(jButton.getName());
        jButton.addActionListener(this);
        jButton.setEnabled(true);
        return jButton;
    }

    public String getHelpID() {
        return "adm_agnts_add_cimom";
    }

    private void configureHelp() {
        String string = this.getHelpID();
        Help.setHelpID(this.getRootPane(), string);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
    }

    private void enableSaveAndCancelButtons(boolean bl) {
        if (bl) {
            this.validateAndEnable(null);
            this.cancelButton.setEnabled(true);
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.saveButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private void equalizeFieldsSize() {
        int n = 0;
        Font font = null;
        int n2 = 0;
        while (n2 < 2) {
            Iterator iterator = this.model.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = this.model.get(string);
                if (!(v instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)v;
                if (n2 == 0) {
                    n = Math.max(n, (int)jComponent.getSize().getWidth());
                    if (font != null || !(jComponent instanceof JTextField) || jComponent instanceof JPasswordField) continue;
                    font = jComponent.getFont();
                    continue;
                }
                jComponent.setFont(font);
                FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
                int n3 = Math.max(fontMetrics.getHeight() + 2, 20);
                jComponent.setPreferredSize(new Dimension(n, n3));
                jComponent.setMinimumSize(new Dimension(n, n3));
            }
            ++n2;
        }
    }
}

