/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TCloseTabPane;
import org.eclipse.aperi.gui.TabCloseListener;
import org.eclipse.aperi.gui.config.ConfigDDI;
import org.eclipse.aperi.gui.config.common.ConfigTab;
import org.eclipse.aperi.gui.config.data.DataConfigTab;
import org.eclipse.aperi.gui.config.disk.DiskConfigTab;
import org.eclipse.aperi.gui.config.fabric.FabricConfigTab;
import org.eclipse.aperi.gui.config.service.ServiceConfigTab;
import org.eclipse.aperi.gui.config.tape.TapeConfigTab;

public class ConfigPanel
extends JPanel
implements FocusListener,
ChangeListener,
ComponentListener,
TabCloseListener {
    public TCloseTabPane tabs = null;
    private ConfigDDI theDDI = null;
    public static ConfigPanel self = null;

    public ConfigPanel(ConfigDDI configDDI) {
        this.theDDI = configDDI;
        self = this;
    }

    public JComponent getComponent() {
        Capabilities capabilities = GuiManager.getGuiManager().getGuiMain().getCapabilities();
        this.setLayout(new BorderLayout());
        if (this.tabs == null) {
            this.tabs = new TCloseTabPane(1);
            this.tabs.setFont(BaseTree.boldFont);
            this.tabs.addFocusListener(this);
            this.tabs.addChangeListener(this);
            this.tabs.addTab(GuiUtil.getString("CONFIG_SERVICE_TITLE"), new ServiceConfigTab(), GuiUtil.getString("CONFIG_SERVICE_TITLE"), false);
            if (capabilities.isDataOp()) {
                this.tabs.addTab(GuiUtil.getString("CONFIG_DATA_TITLE"), new DataConfigTab(), GuiUtil.getString("CONFIG_DATA_TITLE"), false);
            }
            if (capabilities.isDiskOp()) {
                this.tabs.addTab(GuiUtil.getString("CONFIG_DISK_TITLE"), new DiskConfigTab(), GuiUtil.getString("CONFIG_DISK_TITLE"), false);
            }
            if (capabilities.isFabricOp()) {
                this.tabs.addTab(GuiUtil.getString("CONFIG_FABRIC_TITLE"), new FabricConfigTab(), GuiUtil.getString("CONFIG_FABRIC_TITLE"), false);
            }
            if (capabilities.isTapeOp()) {
                this.tabs.addTab(GuiUtil.getString("CONFIG_TAPE_TITLE"), new TapeConfigTab(), GuiUtil.getString("CONFIG_TAPE_TITLE"), false);
            }
            this.add((Component)this.tabs, "Center");
            this.tabs.setSelectedIndex(ConfigDDI.currentTab);
            ((ConfigTab)this.tabs.getSelectedComponent()).refresh(false);
        }
        return this;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.tabs) {
            ConfigTab configTab = (ConfigTab)this.tabs.getSelectedComponent();
            ConfigDDI.currentTab = this.tabs.getSelectedIndex();
            configTab.refresh(false);
            this.componentResized(focusEvent);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.tabs) {
            ConfigTab configTab = (ConfigTab)this.tabs.getSelectedComponent();
            if (ConfigDDI.currentTab != this.tabs.getSelectedIndex()) {
                configTab.refresh(false);
                ConfigDDI.currentTab = this.tabs.getSelectedIndex();
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public boolean closeTab(int n) {
        return true;
    }

    public void componentResized(ComponentEvent componentEvent) {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.awt.event.ComponentListener");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ComponentListener[] componentListenerArray = (ComponentListener[])this.getListeners(clazz);
        int n = 0;
        while (componentListenerArray != null && n < componentListenerArray.length) {
            ComponentListener componentListener = componentListenerArray[n];
            componentListener.componentResized(componentEvent);
            ++n;
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }
}

