/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.TUpDownListSelector;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;

public abstract class BaseSelectSubsystemPortsStep
extends WizardPage {
    private JLabel titleLabel = null;
    private JLabel descLabel = null;
    private JLabel desc2Label = null;
    private TUpDownListSelector portList = null;
    protected HashMap portWWPN = new HashMap();
    private HashMap ssportData = null;
    protected HashMap portData = null;
    protected DefaultListModel srcModel = new DefaultListModel();
    protected DefaultListModel selModel = new DefaultListModel();
    private JList sourceList = null;
    private JList selectedList = null;
    private JButton nextButton = null;
    protected boolean isHelpSet = false;
    private boolean getData = false;
    private boolean skipStep = false;
    private String subSystemID = null;
    private int portsPerView = -1;
    private JDialog wizardDialog = null;
    private GUIStorageSubsystem subSystem = null;
    private DiskDataAccessor diskAccessor = DiskDataAccessor.getInstance();
    public static String SUBSYSTEM_DATA = "Subsystem Ports";

    public BaseSelectSubsystemPortsStep(int n, GUIStorageSubsystem gUIStorageSubsystem) {
        super(n);
        this.setName(this.getClass().getName());
        this.subSystemID = gUIStorageSubsystem.getId();
        this.subSystem = gUIStorageSubsystem;
        this.portsPerView = this.subSystem.getCapabilityData().getPortsPerView();
        this.getFinishButton().setEnabled(false);
        this.nextButton = this.getNextButton();
        Container container = this.getContentPane();
        container.add(this.create());
    }

    public JPanel create() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.titleLabel = new JLabel(Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_LABEL"));
        this.titleLabel.setAlignmentX(0.0f);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel2.add(this.titleLabel);
        jPanel2.add(Box.createHorizontalGlue());
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.descLabel = new JLabel(Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_DESC_LABEL"));
        this.descLabel.setAlignmentX(0.0f);
        this.descLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel3.add(this.descLabel);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.desc2Label = this.portsPerView == 2 ? new JLabel(Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_DESC_SINGLE_PORT_LABEL")) : new JLabel(Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_DESC_MULTIPLE_PORT_LABEL"));
        this.desc2Label.setAlignmentX(0.0f);
        this.desc2Label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel4.add(this.desc2Label);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel.add(jPanel4);
        if (this.portsPerView == 2) {
            this.sourceList = new JList(this.srcModel);
            this.selectedList = new JList(this.selModel);
        } else {
            this.sourceList = new JList(this.selModel);
            this.selectedList = new JList(this.srcModel);
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        this.portList = new TUpDownListSelector(this.sourceList, this.selectedList, Util.getString("DISK_VOLUME_HOST_PORT_SRC_LABEL"), Util.getString("DISK_VOLUME_HOST_PORT_SEL_LABEL"), true);
        jPanel5.add(this.portList);
        jPanel5.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel.add(jPanel5);
        return jPanel;
    }

    public void addData(Vector vector) {
    }

    public JDialog getWizardDialog() {
        return null;
    }

    public boolean skipSubsystemStep() {
        return this.skipStep;
    }

    public void fillData() {
        GUIPort gUIPort = null;
        String string = new String();
        if (!this.getData) {
            this.getData = true;
            this.getPortsFromSystem();
            if (this.portData == null) {
                this.getData = false;
                return;
            }
            Vector vector = new Vector(this.portData.values());
            GUIEntityUtil.sort(vector);
            Iterator iterator = vector.iterator();
            new DefaultListModel();
            this.ssportData = new HashMap();
            this.selModel.removeAllElements();
            this.srcModel.removeAllElements();
            while (iterator.hasNext()) {
                gUIPort = (GUIPort)iterator.next();
                string = String.valueOf(gUIPort.getWwpn()) + "( " + gUIPort.getHostName() + " )";
                this.srcModel.addElement(string);
                this.ssportData.put(string, gUIPort);
                this.portWWPN.put(gUIPort.getWwpn(), string);
            }
            if (this.portsPerView == 2) {
                this.selModel.add(0, this.srcModel.get(0));
                this.srcModel.remove(0);
                this.sourceList = new JList(this.srcModel);
                this.selectedList = new JList(this.selModel);
                this.sourceList.setSelectedIndex(0);
                this.portList.invalidate();
            } else {
                this.sourceList = new JList(this.selModel);
                this.selectedList = new JList(this.srcModel);
            }
        }
    }

    public void getPortsFromSystem() {
    }

    public void skip() {
        this.skipStep = true;
    }

    public boolean nextBegin() {
        boolean bl = true;
        ArrayList arrayList = this.portList.getSelList();
        String string = null;
        GUIPort gUIPort = null;
        Vector<GUIPort> vector = new Vector<GUIPort>();
        if (this.portsPerView == 2 && arrayList.size() > 1) {
            JOptionPane.showMessageDialog(this, Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_DESC_SINGLE_PORT_LABEL"), Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_LABEL"), 0);
            bl = false;
        }
        if (arrayList == null && bl) {
            int n = JOptionPane.showConfirmDialog(this, Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_CONFIRMATION"), Util.getString("DISK_SUBSYSTEMPORTS_LABEL"), 2);
            switch (n) {
                case 0: {
                    bl = false;
                    break;
                }
                case 2: {
                    bl = false;
                }
            }
        } else {
            Iterator iterator = arrayList.listIterator();
            while (iterator.hasNext()) {
                string = iterator.next().toString();
                gUIPort = (GUIPort)this.ssportData.get(string);
                vector.add(gUIPort);
            }
        }
        this.addData(vector);
        return bl;
    }

    public boolean previousBegin() {
        return true;
    }
}

