/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.details;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.details.BaseDetailsPanel;
import org.eclipse.aperi.gui.fabric.details.ComputerDetailsPanel;
import org.eclipse.aperi.gui.fabric.details.EndpointDetailsPanel;
import org.eclipse.aperi.gui.fabric.details.LabeledDetailsPanel;
import org.eclipse.aperi.gui.fabric.details.PortDetailsPanel;
import org.eclipse.aperi.gui.fabric.details.SwitchDetailsPanel;

public class DetailsDDI
extends DataDisplayInfo {
    protected String entityType;
    protected String entityID;
    protected BaseDetailsPanel bdp = null;
    private boolean dbg = false;

    public DetailsDDI(String string, String string2) {
        this.entityType = string;
        this.entityID = string2;
        if (this.dbg) {
            System.out.println("DetailsDDI [" + string + "]  [" + string2 + "]");
        }
        this.makePanel();
        this.setDescription(FabricGuiUtil.getString("FabricDetails_DetailsTwistie"));
        if (this.bdp != null) {
            this.bdp.queryData();
        }
    }

    public static void setDDIDescription(JPanel jPanel, String string) {
        DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getRoot();
        while (dataDisplayInfo != null) {
            if (dataDisplayInfo instanceof DetailsDDI) {
                DetailsDDI detailsDDI = (DetailsDDI)dataDisplayInfo;
                if (detailsDDI.bdp == jPanel) {
                    detailsDDI.setDescription(string);
                }
            }
            dataDisplayInfo = dataDisplayInfo.getNext();
        }
    }

    void makePanel() {
        this.panel = this.entityType.equals("server") ? new ComputerDetailsPanel(this.entityType, this.entityID) : (this.entityType.equals("pe") ? new EndpointDetailsPanel(this.entityType, this.entityID) : (this.entityType.equals("fabric") || this.entityType.equals("phys_infrastructure") ? new LabeledDetailsPanel(this.entityType, this.entityID) : (this.entityType.equals("port") || this.entityType.equals("node") ? new PortDetailsPanel(this.entityType, this.entityID) : (this.entityType.equals("switch") ? new SwitchDetailsPanel(this.entityType, this.entityID) : new BaseDetailsPanel(this.entityType, this.entityID)))));
        this.bdp = (BaseDetailsPanel)this.panel;
        this.bdp.addButtonListener(new DDIButtonListener());
    }

    public void reDisplay() {
        if (this.dbg) {
            System.out.println("reDisplay " + this);
        }
        if (this.bdp == null) {
            this.makePanel();
            this.bdp.queryData();
        }
        this.bdp.hookMenu();
        this.panel = this.bdp;
        this.show();
    }

    public void show() {
        super.show();
        if (this.bdp != null) {
            this.bdp.hookMenu();
        }
    }

    public void losingFocus() {
        if (this.dbg) {
            System.out.println("losingFocus " + this);
        }
        if (this.bdp != null) {
            this.bdp.unhookMenu();
        }
    }

    public void panelToBeNulled() {
        if (this.dbg) {
            System.out.println("panelToBeNulled " + this);
        }
        if (this.bdp != null) {
            this.bdp.unhookMenu();
        }
        this.saveAndClose();
    }

    public void goingAway() {
        if (this.dbg) {
            System.out.println("goingAway " + this);
        }
        if (this.bdp != null) {
            this.bdp.unhookMenu();
        }
    }

    public boolean isEditable() {
        if (this.bdp != null) {
            return this.bdp.isEditable();
        }
        return false;
    }

    public boolean changesPending() {
        if (this.bdp != null) {
            return this.bdp.changesPending();
        }
        return false;
    }

    public void saveAndClose() {
        if (this.dbg) {
            System.out.println("saveAndClose " + this);
        }
        if (this.bdp != null) {
            this.bdp.unhookMenu();
        }
        if (this.bdp != null && this.changesPending()) {
            this.bdp.saveDataFromPanel();
        }
    }

    public String getHelpID() {
        if (this.dbg) {
            System.out.println("getHelpID:" + this.entityType);
        }
        if (this.entityType.equals("server")) {
            return "bta_entity_computer_details";
        }
        if (this.entityType.equals("pe")) {
            return "bta_entity_pe_details";
        }
        if (this.entityType.equals("fabric") || this.entityType.equals("phys_infrastructure")) {
            return "bta_entity_fabric_details";
        }
        if (this.entityType.equals("port")) {
            return "bta_entity_switchport_details";
        }
        if (this.entityType.equals("node")) {
            return "bta_entity_node_details";
        }
        if (this.entityType.equals("switch")) {
            return "bta_entity_switch_details";
        }
        return "welcome_gettingstarted";
    }

    private class DDIButtonListener
    implements ActionListener {
        private DDIButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() == Util.getString("LABEL_CANCEL")) {
                DetailsDDI.this.remove();
            }
            if (actionEvent.getActionCommand() == Util.getString("LABEL_OK")) {
                DetailsDDI.this.saveAndClose();
                DetailsDDI.this.remove();
            }
        }
    }
}

