/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.jobs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.gui.NameListToTreeNode;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.JobChangeListener;
import org.eclipse.aperi.gui.JobChangeManager;
import org.eclipse.aperi.gui.fabric.jobs.FabricJobsHelper;
import org.eclipse.aperi.request.Response;

public class FabricJobsNode
extends BaseTreeNode
implements ActionListener,
JobChangeListener {
    private static final String COMMAND_HISTORY = "command_history";
    private static final String COMMAND_REFRESH = "command_refresh";
    private static final String COMMAND_UPDATE = "command_update";
    private FabricJobsHelper jobsHelper;
    private JPopupMenu menu;

    public FabricJobsNode() {
        this.setUserObject(Util.getString("FabricMonitorNode_Jobs"));
        this.expandBranch = 1;
        this.jobsHelper = new FabricJobsHelper(this, Util.getString("Fabric100"), 114);
        JobChangeManager.addListener(this, (short)108);
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        this.menu = this.getPopupMenu();
        this.showPopupMenu(this.menu, mouseEvent);
    }

    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        this.menu.addPopupMenuListener(this);
        this.addMenuItem(this.menu, "", COMMAND_REFRESH, true, "REFRESH_JOB_LIST");
        this.addMenuItem(this.menu, "GUI0165L", COMMAND_UPDATE, true, "UPDATE_JOB_STATUS");
        this.addMenuItem(this.menu, "GUI0052L", COMMAND_HISTORY, true, null);
        return this.menu;
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
        if (this.getChildCount() == 0 || treeExpansionEvent != null || BaseTree.pBaseTree.isExpanded(new TreePath(this.getPath()))) {
            this.jobsHelper.sendRequest();
        }
    }

    public void refresh(Response response, NameListToTreeNode nameListToTreeNode) {
        MutableInteger mutableInteger;
        BaseTreeNode baseTreeNode;
        NameList nameList = GuiUtil.sortNameList((NameList)response.responseData);
        int n = Integer.MIN_VALUE;
        TreePath treePath = BaseTree.pBaseTree.getSelectionPath();
        BaseTreeNode baseTreeNode2 = treePath != null ? (BaseTreeNode)treePath.getLastPathComponent() : null;
        HashMap<MutableInteger, DataDisplayInfo> hashMap = new HashMap<MutableInteger, DataDisplayInfo>();
        BaseTreeNode[] baseTreeNodeArray = new BaseTreeNode[this.getChildCount()];
        int n2 = 0;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            baseTreeNode = (BaseTreeNode)enumeration.nextElement();
            NameList nameList2 = (NameList)baseTreeNode.getUserObject();
            nameList2.nlName = Util.getTranslatedName(nameList2.nlName);
            mutableInteger = new MutableInteger(nameListToTreeNode.getKey(nameList2));
            hashMap.put(mutableInteger, baseTreeNode.ddi);
            if (baseTreeNode == baseTreeNode2) {
                n = mutableInteger.value;
            }
            baseTreeNodeArray[n2] = baseTreeNode;
            ++n2;
        }
        n2 = 0;
        while (n2 < baseTreeNodeArray.length) {
            BaseTree.MyTree.removeNodeFromParent(baseTreeNodeArray[n2]);
            ++n2;
        }
        baseTreeNode2 = null;
        mutableInteger = new MutableInteger();
        n2 = 0;
        while (nameList != null) {
            DataDisplayInfo dataDisplayInfo;
            nameList.nlName = Util.getTranslatedName(nameList.nlName);
            baseTreeNode = nameListToTreeNode.makeChild(nameList);
            mutableInteger.value = nameListToTreeNode.getKey(nameList);
            if (mutableInteger.value == n) {
                baseTreeNode2 = baseTreeNode;
            }
            if ((dataDisplayInfo = (DataDisplayInfo)hashMap.get(mutableInteger)) != null) {
                baseTreeNode.ddi = dataDisplayInfo;
                dataDisplayInfo.treeNode = baseTreeNode;
            }
            BaseTree.MyTree.insertNodeInto(baseTreeNode, this, n2);
            ++n2;
            nameList = nameList.nlNext;
        }
        if (baseTreeNode2 != null) {
            BaseTree.pBaseTree.reselect(baseTreeNode2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(COMMAND_REFRESH)) {
            this.jobsHelper.sendRequest();
        } else if (string.equals(COMMAND_UPDATE)) {
            this.jobsHelper.sendUpdateRequest();
        } else if (string.equals(COMMAND_HISTORY)) {
            this.jobsHelper.makeRunDDI();
        }
        guiMain.getBaseTree().requestFocus();
    }

    private void addMenuItem(JPopupMenu jPopupMenu, String string, String string2, boolean bl, String string3) {
        String string4 = string3 == null ? Util.getString(string) : Util.getString(string3);
        JMenuItem jMenuItem = new JMenuItem(string4);
        jMenuItem.setName(string4);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(bl);
        jPopupMenu.add(jMenuItem);
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        BaseTree.pBaseTree.setSelectionPath(BaseTree.selectedPath);
        BaseTree.pBaseTree.requestFocus();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        BaseTree.pBaseTree.setSelectionPath(BaseTree.selectedPath);
        BaseTree.pBaseTree.requestFocus();
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void jobChangeOccurred(int n, NameList nameList) {
        this.expand(null);
    }
}

