/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphAssociation;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneMember;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBase;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroup;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoIcon;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoLine;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoPin;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoUnit;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.ControllerView;
import org.eclipse.aperi.gui.topo.widget.ITopoAssociationModel;
import org.eclipse.aperi.gui.topo.widget.ITopoPinContainerWidget;
import org.eclipse.aperi.gui.topo.widget.JTopoApp;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasOverview;
import org.eclipse.aperi.gui.topo.widget.JTopoPinComputer;
import org.eclipse.aperi.gui.topo.widget.JTopoPinOther;
import org.eclipse.aperi.gui.topo.widget.JTopoPinSubsystem;
import org.eclipse.aperi.gui.topo.widget.JTopoPinSwitch;
import org.eclipse.aperi.gui.topo.widget.JTopoPinTapeLibrary;
import org.eclipse.aperi.gui.topo.widget.JTopoPrint;
import org.eclipse.aperi.gui.topo.widget.PinList;
import org.eclipse.aperi.gui.topo.widget.TopoConstant;
import org.eclipse.aperi.gui.topo.widget.TopoEventSource;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.gui.topo.widget.TopoUtilities;
import org.eclipse.aperi.gui.topo.widget.WidgetPool;

public abstract class AbstractJTopoCanvas
extends AbstractJTopoBase {
    protected ControllerView controllerView;
    protected TopoSetting setting;
    protected GraphModel dataModel;
    protected JViewport viewport;
    protected CanvasPanelContainer canvasPanelContainer;
    protected CanvasPanel canvasPanel;
    protected ML_Click ml_click;
    protected ML_Drag ml_viewportDrag;
    protected ArrangeRecord arrangeRecord;
    protected JTopoPrint print;
    protected Action_CloseView actionCloseView;
    protected Action_CloseAllViews actionCloseAllViews;
    protected Action_RefreshView actionRefreshView;
    protected Action_RefreshAllViews actionRefreshAllViews;
    protected Action_ClearHighlights actionClearHighlights;
    protected Action_GlobalSetting actionGlobalSetting;
    protected Action_RefreshSetting actionRefreshSetting;
    protected Action_Print actionPrint;
    protected Action_PrintPreview actionPrintPreview;
    protected Hashtable widgetH;

    protected AbstractJTopoCanvas() {
        this.setBackground(TopoResource.COLOR_BACKGROUND);
        this.setLayout(new BorderLayout());
        this.viewport = new JViewport();
        this.viewport.setBackground(TopoResource.COLOR_BACKGROUND);
        this.add((Component)this.viewport, "Center");
        this.canvasPanelContainer = new CanvasPanelContainer();
        this.canvasPanelContainer.setPanelLabel(this.getViewName());
        this.viewport.setView(this.canvasPanelContainer);
        this.canvasPanel = new CanvasPanel();
        this.canvasPanel.setLayout(this.createDefaultLayout());
        this.canvasPanelContainer.add(this.canvasPanel);
        this.ml_click = new ML_Click();
        this.viewport.addMouseListener(this.ml_click);
        this.ml_viewportDrag = new ML_Drag();
        this.viewport.addMouseListener(this.ml_viewportDrag);
        this.viewport.addMouseMotionListener(this.ml_viewportDrag);
        this.print = new JTopoPrint(this);
        this.arrangeRecord = new ArrangeRecord();
        ActionMap actionMap = this.getActionMap();
        this.actionCloseView = new Action_CloseView();
        actionMap.put(this.actionCloseView.getValue("Name"), this.actionCloseView);
        this.actionCloseAllViews = new Action_CloseAllViews();
        actionMap.put(this.actionCloseAllViews.getValue("Name"), this.actionCloseAllViews);
        this.actionRefreshView = new Action_RefreshView();
        actionMap.put(this.actionRefreshView.getValue("Name"), this.actionRefreshView);
        this.actionRefreshAllViews = new Action_RefreshAllViews();
        actionMap.put(this.actionRefreshAllViews.getValue("Name"), this.actionRefreshAllViews);
        this.actionClearHighlights = new Action_ClearHighlights();
        actionMap.put(this.actionClearHighlights.getValue("Name"), this.actionClearHighlights);
        this.actionGlobalSetting = new Action_GlobalSetting();
        actionMap.put(this.actionGlobalSetting.getValue("Name"), this.actionGlobalSetting);
        this.actionRefreshSetting = new Action_RefreshSetting();
        actionMap.put(this.actionRefreshSetting.getValue("Name"), this.actionRefreshSetting);
        this.actionPrint = new Action_Print();
        actionMap.put(this.actionPrint.getValue("Name"), this.actionPrint);
        this.actionPrintPreview = new Action_PrintPreview();
        actionMap.put(this.actionPrintPreview.getValue("Name"), this.actionPrintPreview);
        this.widgetH = new Hashtable();
        this.initState();
    }

    public abstract String getViewName();

    private void initState() {
        this.controllerView = null;
        this.setting = null;
        this.dataModel = null;
        this.viewport.setViewPosition(new Point(0, 0));
        this.arrangeRecord.setProp(TopoConstant.ARRANGE_DISPLAYNAME);
        this.arrangeRecord.setAsc(true);
        WidgetPool.getInstance();
        Enumeration enumeration = this.widgetH.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            hashtable.clear();
        }
    }

    public void resetState() {
        WidgetPool widgetPool = WidgetPool.getInstance();
        Enumeration enumeration = this.widgetH.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                AbstractJTopoBase abstractJTopoBase = (AbstractJTopoBase)enumeration2.nextElement();
                widgetPool.recycleWidget(abstractJTopoBase);
            }
        }
        this.initState();
    }

    public ControllerView getControllerView() {
        return this.controllerView;
    }

    public void setSessionModel(ControllerView controllerView) {
        this.controllerView = controllerView;
        this.setting = controllerView.getControllerApp().getTopoSetting();
    }

    public GraphModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(GraphModel graphModel) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("AbstractJTopoCanvas, setDataModel()");
        }
        if (graphModel == null) {
            if (GraphDebug.isErrorVisible()) {
                GraphDebug.error("AbstractJTopoCanvas.setModel(), dataModel=null");
            }
            return;
        }
        this.dataModel = graphModel;
        this.updateContainer();
    }

    public void updateContainer() {
        this.reattach();
        this.postProcessing();
        this.revalidate();
        this.repaint();
    }

    protected void postProcessing() {
        this.canvasPanelContainer.setFilteringLevel(this.setting.getFilteringLevel());
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public CanvasPanelContainer getCanvasPanelContainer() {
        return this.canvasPanelContainer;
    }

    public CanvasPanel getCanvasPanel() {
        return this.canvasPanel;
    }

    public void setShowConnectionEnabled(boolean bl) {
        this.clearAllLines();
        if (bl) {
            boolean bl2 = false;
            HashSet hashSet = this.controllerView.getSelection();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                GraphEntity.ID iD = (GraphEntity.ID)iterator.next();
                Vector vector = this.getWidgets(iD);
                int n = 0;
                while (n < vector.size()) {
                    AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)vector.elementAt(n);
                    this.addLine(abstractJTopoEntity, bl2);
                    ++n;
                }
            }
        }
    }

    public void setShowZoneEnabled(boolean bl) {
    }

    public void setOverlayHealthEnabled(boolean bl) {
        Enumeration enumeration = this.widgetH.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)enumeration2.nextElement();
                abstractJTopoEntity.setOverlayHealthEnabled(bl);
            }
        }
    }

    public void setOverlayPerfEnabled(boolean bl) {
        Enumeration enumeration = this.widgetH.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)enumeration2.nextElement();
                abstractJTopoEntity.setOverlayPerfEnabled(bl);
            }
        }
    }

    public void setFilteringLevel(int n) {
        this.updateContainer();
        if (n != 0) {
            ControllerView.SelectionDelta selectionDelta = new ControllerView.SelectionDelta(this.controllerView.getSelection());
            selectionDelta.setFromCanvas(true);
            Iterator iterator = selectionDelta.iteratorSrc();
            while (iterator.hasNext()) {
                GraphEntity.ID iD = (GraphEntity.ID)iterator.next();
                GraphEntity graphEntity = this.dataModel.get(iD);
                if (!Boolean.TRUE.equals(graphEntity.getIsFilterable())) continue;
                selectionDelta.remove(iD);
            }
            this.controllerView.updateSelection(selectionDelta);
        }
        this.setShowConnectionEnabled(this.setting.isShowConnectionEnabled());
    }

    public void setPinList(PinList pinList) {
        Object object;
        int n;
        Object object2;
        Object object3;
        Enumeration enumeration;
        Cloneable cloneable;
        Enumeration enumeration2 = this.widgetH.elements();
        while (enumeration2.hasMoreElements()) {
            cloneable = (Hashtable)enumeration2.nextElement();
            Enumeration enumeration3 = ((Hashtable)cloneable).elements();
            while (enumeration3.hasMoreElements()) {
                enumeration = (AbstractJTopoEntity)enumeration3.nextElement();
                ((AbstractJTopoUnit)((Object)enumeration)).setChecked(false);
                if (!(enumeration instanceof ITopoPinContainerWidget)) continue;
                object3 = (ITopoPinContainerWidget)((Object)enumeration);
                object2 = object3.getPinWidgets();
                n = 0;
                while (n < ((Vector)object2).size()) {
                    object = (AbstractJTopoPin)((Vector)object2).elementAt(n);
                    ((AbstractJTopoUnit)object).setChecked(false);
                    ++n;
                }
            }
        }
        cloneable = pinList.getPins();
        int n2 = 0;
        while (n2 < ((Vector)cloneable).size()) {
            enumeration = (GraphEntity.ID)((Vector)cloneable).elementAt(n2);
            object3 = this.getWidgets((GraphEntity.ID)((Object)enumeration));
            int n3 = 0;
            while (n3 < ((Vector)object3).size()) {
                AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)((Vector)object3).elementAt(n3);
                abstractJTopoEntity.setPinned(true);
                abstractJTopoEntity.pinChanged();
                abstractJTopoEntity.setChecked(true);
                ++n3;
            }
            object2 = this.getPinContainers((GraphEntity.ID)((Object)enumeration));
            n = 0;
            while (n < ((Vector)object2).size()) {
                object = (ITopoPinContainerWidget)((Vector)object2).elementAt(n);
                AbstractJTopoPin abstractJTopoPin = object.getPinWidget((GraphEntity.ID)((Object)enumeration));
                if (abstractJTopoPin == null) {
                    abstractJTopoPin = this.setPinList_createPin((GraphEntity.ID)((Object)enumeration));
                    abstractJTopoPin.setSessionModel(this, pinList);
                    object.addPinWidget(abstractJTopoPin);
                }
                abstractJTopoPin.setDataModel((GraphEntity.ID)((Object)enumeration));
                abstractJTopoPin.setChecked(true);
                ++n;
            }
            ++n2;
        }
        enumeration2 = this.widgetH.elements();
        while (enumeration2.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration2.nextElement();
            enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                AbstractJTopoPin abstractJTopoPin;
                object3 = (AbstractJTopoEntity)enumeration.nextElement();
                if (!((AbstractJTopoUnit)object3).isChecked()) {
                    ((AbstractJTopoEntity)object3).setPinned(false);
                    ((AbstractJTopoUnit)object3).pinChanged();
                }
                if (!(object3 instanceof ITopoPinContainerWidget)) continue;
                object2 = (ITopoPinContainerWidget)object3;
                Vector<AbstractJTopoPin> vector = new Vector<AbstractJTopoPin>();
                object = object2.getPinWidgets();
                int n4 = 0;
                while (n4 < ((Vector)object).size()) {
                    abstractJTopoPin = (AbstractJTopoPin)((Vector)object).elementAt(n4);
                    if (!abstractJTopoPin.isChecked()) {
                        vector.add(abstractJTopoPin);
                    }
                    abstractJTopoPin.setChecked(false);
                    ++n4;
                }
                n4 = 0;
                while (n4 < vector.size()) {
                    abstractJTopoPin = (AbstractJTopoPin)vector.elementAt(n4);
                    object2.removePinWidget(abstractJTopoPin);
                    ++n4;
                }
            }
        }
        enumeration2 = this.widgetH.elements();
        while (enumeration2.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration2.nextElement();
            enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                object3 = (AbstractJTopoEntity)enumeration.nextElement();
                if (!(object3 instanceof ITopoPinContainerWidget)) continue;
                object2 = (ITopoPinContainerWidget)object3;
                object2.updatePinPanel();
            }
        }
    }

    protected AbstractJTopoPin setPinList_createPin(GraphEntity.ID iD) {
        WidgetPool widgetPool = WidgetPool.getInstance();
        AbstractJTopoPin abstractJTopoPin = null;
        if (iD instanceof GraphComputer.ID) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoPinComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoPin = (JTopoPinComputer)widgetPool.getWidget(clazz);
        } else if (iD instanceof GraphSwitch.ID) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoPinSwitch");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoPin = (JTopoPinSwitch)widgetPool.getWidget(clazz);
        } else if (iD instanceof GraphSubsystem.ID) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoPinSubsystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoPin = (JTopoPinSubsystem)widgetPool.getWidget(clazz);
        } else if (iD instanceof GraphTapeLibrary.ID) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoPinTapeLibrary");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoPin = (JTopoPinTapeLibrary)widgetPool.getWidget(clazz);
        } else if (iD instanceof GraphOther.ID) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoPinOther");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoPin = (JTopoPinOther)widgetPool.getWidget(clazz);
        }
        return abstractJTopoPin;
    }

    public Hashtable getWidgetTable(AbstractJTopoEntity abstractJTopoEntity) {
        Hashtable hashtable = null;
        if (abstractJTopoEntity != null) {
            Enumeration enumeration = this.widgetH.elements();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable2 = (Hashtable)enumeration.nextElement();
                Enumeration enumeration2 = hashtable2.elements();
                boolean bl = true;
                while (enumeration2.hasMoreElements()) {
                    AbstractJTopoEntity abstractJTopoEntity2 = (AbstractJTopoEntity)enumeration2.nextElement();
                    if (bl) {
                        if (!abstractJTopoEntity2.getClass().equals(abstractJTopoEntity.getClass())) break;
                        bl = false;
                    }
                    if (!abstractJTopoEntity2.equals(abstractJTopoEntity)) continue;
                    hashtable = hashtable2;
                    break;
                }
                if (hashtable != null) break;
            }
        }
        return hashtable;
    }

    public Vector getWidgets(GraphEntity.ID iD) {
        Vector<AbstractJTopoEntity> vector = new Vector<AbstractJTopoEntity>();
        if (iD != null) {
            Enumeration enumeration = this.widgetH.elements();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable = (Hashtable)enumeration.nextElement();
                AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)hashtable.get(iD);
                if (abstractJTopoEntity == null) continue;
                vector.add(abstractJTopoEntity);
            }
        }
        return vector;
    }

    public Vector getPinContainers(GraphEntity.ID iD) {
        Vector<AbstractJTopoEntity> vector = new Vector<AbstractJTopoEntity>();
        Vector vector2 = this.getWidgets(iD);
        int n = 0;
        while (n < vector2.size()) {
            AbstractJTopoEntity abstractJTopoEntity;
            AbstractJTopoEntity abstractJTopoEntity2 = abstractJTopoEntity = (AbstractJTopoEntity)vector2.elementAt(n);
            while (abstractJTopoEntity2 != null) {
                if (abstractJTopoEntity2 instanceof ITopoPinContainerWidget) {
                    vector.add(abstractJTopoEntity2);
                }
                abstractJTopoEntity2 = abstractJTopoEntity2.getLogicalParent();
            }
            ++n;
        }
        return vector;
    }

    public Vector getPins(GraphEntity.ID iD) {
        Vector<AbstractJTopoPin> vector = new Vector<AbstractJTopoPin>();
        Vector vector2 = this.getPinContainers(iD);
        int n = 0;
        while (n < vector2.size()) {
            ITopoPinContainerWidget iTopoPinContainerWidget = (ITopoPinContainerWidget)vector2.elementAt(n);
            AbstractJTopoPin abstractJTopoPin = iTopoPinContainerWidget.getPinWidget(iD);
            if (abstractJTopoPin != null) {
                vector.add(abstractJTopoPin);
            }
            ++n;
        }
        return vector;
    }

    protected void handleMouseClick(MouseEvent mouseEvent) {
        boolean bl = true;
        TopoEventSource topoEventSource = (TopoEventSource)mouseEvent.getSource();
        topoEventSource.setHandler(this);
        this.handleUnitClick(mouseEvent, bl);
    }

    protected void handleUnitClick(MouseEvent mouseEvent, boolean bl) {
        TopoEventSource topoEventSource;
        Object object;
        if (mouseEvent.getClickCount() == 1) {
            ControllerView.SelectionDelta selectionDelta = new ControllerView.SelectionDelta(this.controllerView.getSelection());
            selectionDelta.setAltDown(mouseEvent.isAltDown());
            selectionDelta.setFromCanvas(true);
            TopoEventSource topoEventSource2 = (TopoEventSource)mouseEvent.getSource();
            Object object2 = topoEventSource2.getHandler();
            selectionDelta.setClickedWidget(object2);
            if (object2 instanceof AbstractJTopoCanvas) {
                if (!mouseEvent.isMetaDown()) {
                    this.clearAllSelections(selectionDelta);
                }
            } else if (object2 instanceof AbstractJTopoEntity) {
                AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)object2;
                GraphEntity.ID iD = abstractJTopoEntity.getFocusEntityID();
                selectionDelta.setClickedEntityID(iD);
                if (mouseEvent.isMetaDown()) {
                    if (!selectionDelta.isInSrc(iD)) {
                        this.clearAllSelections(selectionDelta);
                        this.addSelection(selectionDelta, abstractJTopoEntity, bl);
                    }
                } else if (!mouseEvent.isShiftDown()) {
                    if (mouseEvent.isControlDown()) {
                        if (selectionDelta.isInSrc(iD)) {
                            this.removeSelection(selectionDelta, abstractJTopoEntity, bl);
                        } else {
                            this.addSelection(selectionDelta, abstractJTopoEntity, bl);
                        }
                    } else {
                        this.clearAllSelections(selectionDelta);
                        this.addSelection(selectionDelta, abstractJTopoEntity, bl);
                    }
                }
            }
            this.controllerView.updateSelection(selectionDelta);
            if (mouseEvent.isMetaDown()) {
                this.handleUnitRightClick(mouseEvent);
            }
        } else if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2 && (object = (topoEventSource = (TopoEventSource)mouseEvent.getSource()).getHandler()) instanceof AbstractJTopoEntity) {
            AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)object;
            this.openView(abstractJTopoEntity);
        }
    }

    protected void clearAllSelections(ControllerView.SelectionDelta selectionDelta) {
        selectionDelta.removeAll();
    }

    protected void addSelection(ControllerView.SelectionDelta selectionDelta, AbstractJTopoEntity abstractJTopoEntity, boolean bl) {
        selectionDelta.add(abstractJTopoEntity.getFocusEntityID());
        if (bl && abstractJTopoEntity instanceof AbstractJTopoGroup) {
            AbstractJTopoGroup abstractJTopoGroup = (AbstractJTopoGroup)abstractJTopoEntity;
            Vector vector = abstractJTopoGroup.getLogicalChilds();
            int n = 0;
            while (n < vector.size()) {
                AbstractJTopoEntity abstractJTopoEntity2 = (AbstractJTopoEntity)vector.elementAt(n);
                this.addSelection(selectionDelta, abstractJTopoEntity2, bl);
                ++n;
            }
        }
    }

    protected void removeSelection(ControllerView.SelectionDelta selectionDelta, AbstractJTopoEntity abstractJTopoEntity, boolean bl) {
        selectionDelta.remove(abstractJTopoEntity.getFocusEntityID());
        if (bl && abstractJTopoEntity instanceof AbstractJTopoGroup) {
            AbstractJTopoGroup abstractJTopoGroup = (AbstractJTopoGroup)abstractJTopoEntity;
            Vector vector = abstractJTopoGroup.getLogicalChilds();
            int n = 0;
            while (n < vector.size()) {
                AbstractJTopoEntity abstractJTopoEntity2 = (AbstractJTopoEntity)vector.elementAt(n);
                this.removeSelection(selectionDelta, abstractJTopoEntity2, bl);
                ++n;
            }
        }
    }

    public void applySelection(ControllerView.SelectionDelta selectionDelta) {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        AbstractCollection abstractCollection;
        Iterator iterator = selectionDelta.iteratorRemove();
        while (iterator.hasNext()) {
            GraphEntity.ID iD = (GraphEntity.ID)iterator.next();
            abstractCollection = this.getWidgets(iD);
            int n = 0;
            while (n < ((Vector)abstractCollection).size()) {
                AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)((Vector)abstractCollection).elementAt(n);
                abstractJTopoEntity.setSelected(false);
                abstractJTopoEntity.selectionChanged();
                if (this.setting.isShowConnectionEnabled()) {
                    this.removeLine(abstractJTopoEntity);
                }
                ++n;
            }
            serializable3 = this.getPins(iD);
            int n2 = 0;
            while (n2 < ((Vector)serializable3).size()) {
                serializable2 = (AbstractJTopoPin)((Vector)serializable3).elementAt(n2);
                ((AbstractJTopoEntity)serializable2).setSelected(false);
                ((AbstractJTopoIcon)serializable2).selectionChanged();
                ++n2;
            }
        }
        boolean bl = selectionDelta.isAltDown();
        abstractCollection = new HashSet();
        iterator = selectionDelta.iteratorAdd();
        while (iterator.hasNext()) {
            serializable3 = (GraphEntity.ID)iterator.next();
            Vector vector = this.getWidgets((GraphEntity.ID)serializable3);
            int n = 0;
            while (n < vector.size()) {
                AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)vector.elementAt(n);
                abstractJTopoEntity.setSelected(true);
                abstractJTopoEntity.selectionChanged();
                if (this.setting.isShowConnectionEnabled()) {
                    serializable = this.addLine(abstractJTopoEntity, bl);
                    abstractCollection.addAll(serializable);
                }
                ++n;
            }
            serializable2 = this.getPins((GraphEntity.ID)serializable3);
            int n3 = 0;
            while (n3 < ((Vector)serializable2).size()) {
                serializable = (AbstractJTopoPin)((Vector)serializable2).elementAt(n3);
                ((AbstractJTopoEntity)serializable).setSelected(true);
                ((AbstractJTopoIcon)serializable).selectionChanged();
                ++n3;
            }
        }
        if (this.setting.isShowConnectionEnabled() && bl) {
            serializable3 = new HashSet();
            Iterator iterator2 = ((HashSet)abstractCollection).iterator();
            while (iterator2.hasNext()) {
                serializable2 = (AbstractJTopoEntity)iterator2.next();
                AbstractJTopoEntity abstractJTopoEntity = ((AbstractJTopoUnit)serializable2).getLogicalParent();
                if (!(abstractJTopoEntity instanceof AbstractJTopoGroup)) continue;
                ((HashSet)serializable3).add(abstractJTopoEntity);
            }
            serializable2 = new HashSet();
            Iterator iterator3 = ((HashSet)serializable3).iterator();
            while (iterator3.hasNext()) {
                serializable = (AbstractJTopoGroup)iterator3.next();
                Hashtable hashtable = this.getWidgetTable((AbstractJTopoEntity)serializable);
                if (((HashSet)serializable2).contains(hashtable)) continue;
                ((HashSet)serializable2).add(hashtable);
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    AbstractJTopoGroup abstractJTopoGroup = (AbstractJTopoGroup)enumeration.nextElement();
                    if (((HashSet)serializable3).contains(abstractJTopoGroup) || !abstractJTopoGroup.isExpanded()) continue;
                    abstractJTopoGroup.setExpanded(false);
                    abstractJTopoGroup.revalidate();
                    abstractJTopoGroup.repaint();
                }
            }
        }
        if (!selectionDelta.isFromCanvas()) {
            serializable3 = selectionDelta.getClickedEntityID();
            Vector vector = this.getWidgets((GraphEntity.ID)serializable3);
            int n = 0;
            while (n < vector.size()) {
                AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)vector.elementAt(n);
                boolean bl2 = TopoUtilities.expand(abstractJTopoEntity);
                if (bl2) {
                    SwingUtilities.invokeLater(new DelayFocus(abstractJTopoEntity, this));
                } else {
                    TopoUtilities.focus(abstractJTopoEntity, this);
                }
                ++n;
            }
        }
    }

    protected abstract void clearAllLines();

    protected void clearAllLines_helper(String string) {
        Hashtable hashtable = (Hashtable)this.widgetH.get(string);
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            AbstractJTopoLine abstractJTopoLine = (AbstractJTopoLine)enumeration.nextElement();
            this.canvasPanel.remove(abstractJTopoLine);
            WidgetPool.getInstance().recycleWidget(abstractJTopoLine);
        }
        hashtable.clear();
    }

    protected abstract HashSet addLine(AbstractJTopoEntity var1, boolean var2);

    protected HashSet addLine_helper(AbstractJTopoEntity abstractJTopoEntity, GraphEntity.Type type, String string, Class clazz, String string2, boolean bl) {
        HashSet<AbstractJTopoEntity> hashSet = new HashSet<AbstractJTopoEntity>();
        GraphEntity.ID iD = abstractJTopoEntity.getFocusEntityID();
        Enumeration enumeration = this.dataModel.reference(type, iD);
        while (enumeration.hasMoreElements()) {
            AbstractJTopoLine abstractJTopoLine;
            Hashtable hashtable;
            AbstractJTopoEntity abstractJTopoEntity2;
            GraphAssociation graphAssociation = (GraphAssociation)enumeration.nextElement();
            GraphEntity.ID iD2 = graphAssociation.getEntityID();
            GraphEntity.ID iD3 = graphAssociation.getFromID();
            if (iD3.equals(iD)) {
                iD3 = graphAssociation.getToID();
            }
            if ((abstractJTopoEntity2 = (AbstractJTopoEntity)(hashtable = (Hashtable)this.widgetH.get(string2)).get(iD3)) == null) continue;
            hashSet.add(abstractJTopoEntity2);
            if (bl) {
                TopoUtilities.expand(abstractJTopoEntity2);
            }
            if ((abstractJTopoLine = (AbstractJTopoLine)(hashtable = (Hashtable)this.widgetH.get(string)).get(iD2)) == null) {
                abstractJTopoLine = (AbstractJTopoLine)WidgetPool.getInstance().getWidget(clazz);
                abstractJTopoLine.setSessionModel(this, GraphModelConstant.SCOPE_NULL);
                ITopoAssociationModel iTopoAssociationModel = (ITopoAssociationModel)abstractJTopoLine.getWidgetModel();
                iTopoAssociationModel.setFromWidget(abstractJTopoEntity);
                iTopoAssociationModel.setToWidget(abstractJTopoEntity2);
                hashtable.put(iD2, abstractJTopoLine);
                this.canvasPanel.add((Component)abstractJTopoLine, 0);
            }
            abstractJTopoLine.setDataModel(graphAssociation);
        }
        return hashSet;
    }

    protected HashSet addLine_helper_fromFCP(AbstractJTopoEntity abstractJTopoEntity, GraphEntity.Type type, Class clazz, String string, Class clazz2, String string2, boolean bl) {
        HashSet<AbstractJTopoEntity> hashSet = new HashSet<AbstractJTopoEntity>();
        GraphEntity.ID iD = abstractJTopoEntity.getFocusEntityID();
        GraphFCPort.ID iD2 = (GraphFCPort.ID)iD;
        Enumeration enumeration = this.dataModel.reference(GraphFCPort2FCPort.TYPE, iD2);
        while (enumeration.hasMoreElements()) {
            GraphFCPort2FCPort graphFCPort2FCPort = (GraphFCPort2FCPort)enumeration.nextElement();
            GraphFCPort2FCPort.ID iD3 = (GraphFCPort2FCPort.ID)graphFCPort2FCPort.getEntityID();
            GraphEntity.ID iD4 = graphFCPort2FCPort.getFromID();
            if (iD4.equals(iD2)) {
                iD4 = graphFCPort2FCPort.getToID();
            }
            Enumeration enumeration2 = this.dataModel.associatorID(type, iD4);
            while (enumeration2.hasMoreElements()) {
                GraphEntity.ID iD5 = (GraphEntity.ID)enumeration2.nextElement();
                Hashtable hashtable = (Hashtable)this.widgetH.get(string2);
                AbstractJTopoEntity abstractJTopoEntity2 = (AbstractJTopoEntity)hashtable.get(iD5);
                if (abstractJTopoEntity2 == null) continue;
                hashSet.add(abstractJTopoEntity2);
                if (bl) {
                    TopoUtilities.expand(abstractJTopoEntity2);
                }
                GraphAssociation graphAssociation = null;
                try {
                    graphAssociation = (GraphAssociation)clazz.newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                graphAssociation.getEntityID().setID(iD.getID() + "+" + iD5.getID());
                graphAssociation.setFromID(iD);
                graphAssociation.setToID(iD5);
                graphAssociation.setHealthStatus(graphFCPort2FCPort.getHealthStatus());
                hashtable = (Hashtable)this.widgetH.get(string);
                AbstractJTopoLine abstractJTopoLine = (AbstractJTopoLine)hashtable.get(iD3);
                if (abstractJTopoLine == null) {
                    abstractJTopoLine = (AbstractJTopoLine)WidgetPool.getInstance().getWidget(clazz2);
                    abstractJTopoLine.setSessionModel(this, GraphModelConstant.SCOPE_NULL);
                    ITopoAssociationModel iTopoAssociationModel = (ITopoAssociationModel)abstractJTopoLine.getWidgetModel();
                    iTopoAssociationModel.setFromWidget(abstractJTopoEntity);
                    iTopoAssociationModel.setToWidget(abstractJTopoEntity2);
                    hashtable.put(iD3, abstractJTopoLine);
                    this.canvasPanel.add((Component)abstractJTopoLine, 0);
                }
                abstractJTopoLine.setDataModel(graphAssociation);
            }
        }
        return hashSet;
    }

    protected HashSet addLine_helper_toFCP(AbstractJTopoEntity abstractJTopoEntity, GraphEntity.Type type, Class clazz, String string, Class clazz2, String string2, boolean bl) {
        HashSet<AbstractJTopoEntity> hashSet = new HashSet<AbstractJTopoEntity>();
        GraphEntity.ID iD = abstractJTopoEntity.getFocusEntityID();
        Enumeration enumeration = this.dataModel.associatorID(type, iD);
        while (enumeration.hasMoreElements()) {
            GraphFCPort.ID iD2 = (GraphFCPort.ID)enumeration.nextElement();
            Enumeration enumeration2 = this.dataModel.reference(GraphFCPort2FCPort.TYPE, iD2);
            while (enumeration2.hasMoreElements()) {
                GraphFCPort2FCPort graphFCPort2FCPort = (GraphFCPort2FCPort)enumeration2.nextElement();
                GraphFCPort2FCPort.ID iD3 = (GraphFCPort2FCPort.ID)graphFCPort2FCPort.getEntityID();
                GraphEntity.ID iD4 = graphFCPort2FCPort.getFromID();
                if (iD4.equals(iD2)) {
                    iD4 = graphFCPort2FCPort.getToID();
                }
                GraphEntity.ID iD5 = iD4;
                Hashtable hashtable = (Hashtable)this.widgetH.get(string2);
                AbstractJTopoEntity abstractJTopoEntity2 = (AbstractJTopoEntity)hashtable.get(iD5);
                if (abstractJTopoEntity2 == null) continue;
                hashSet.add(abstractJTopoEntity2);
                if (bl) {
                    TopoUtilities.expand(abstractJTopoEntity2);
                }
                GraphAssociation graphAssociation = null;
                try {
                    graphAssociation = (GraphAssociation)clazz.newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                graphAssociation.getEntityID().setID(iD.getID() + "+" + iD4.getID());
                graphAssociation.setFromID(iD);
                graphAssociation.setToID(iD5);
                graphAssociation.setHealthStatus(graphFCPort2FCPort.getHealthStatus());
                hashtable = (Hashtable)this.widgetH.get(string);
                AbstractJTopoLine abstractJTopoLine = (AbstractJTopoLine)hashtable.get(iD3);
                if (abstractJTopoLine == null) {
                    abstractJTopoLine = (AbstractJTopoLine)WidgetPool.getInstance().getWidget(clazz2);
                    abstractJTopoLine.setSessionModel(this, GraphModelConstant.SCOPE_NULL);
                    ITopoAssociationModel iTopoAssociationModel = (ITopoAssociationModel)abstractJTopoLine.getWidgetModel();
                    iTopoAssociationModel.setFromWidget(abstractJTopoEntity);
                    iTopoAssociationModel.setToWidget(abstractJTopoEntity2);
                    hashtable.put(iD3, abstractJTopoLine);
                    this.canvasPanel.add((Component)abstractJTopoLine, 0);
                }
                abstractJTopoLine.setDataModel(graphAssociation);
            }
        }
        return hashSet;
    }

    protected abstract void removeLine(AbstractJTopoEntity var1);

    protected void removeLine_helper(GraphEntity.ID iD, GraphEntity.Type type, String string) {
        Enumeration enumeration = this.dataModel.referenceID(type, iD);
        while (enumeration.hasMoreElements()) {
            GraphEntity.ID iD2 = (GraphEntity.ID)enumeration.nextElement();
            Hashtable hashtable = (Hashtable)this.widgetH.get(string);
            AbstractJTopoLine abstractJTopoLine = (AbstractJTopoLine)hashtable.remove(iD2);
            if (abstractJTopoLine == null) continue;
            this.canvasPanel.remove(abstractJTopoLine);
            WidgetPool.getInstance().recycleWidget(abstractJTopoLine);
        }
    }

    protected void removeLine_helper_fromFCP(GraphEntity.ID iD, String string) {
        Enumeration enumeration = this.dataModel.reference(GraphFCPort2FCPort.TYPE, iD);
        while (enumeration.hasMoreElements()) {
            GraphFCPort2FCPort graphFCPort2FCPort = (GraphFCPort2FCPort)enumeration.nextElement();
            GraphFCPort2FCPort.ID iD2 = (GraphFCPort2FCPort.ID)graphFCPort2FCPort.getEntityID();
            Hashtable hashtable = (Hashtable)this.widgetH.get(string);
            AbstractJTopoLine abstractJTopoLine = (AbstractJTopoLine)hashtable.remove(iD2);
            if (abstractJTopoLine == null) continue;
            this.canvasPanel.remove(abstractJTopoLine);
            WidgetPool.getInstance().recycleWidget(abstractJTopoLine);
        }
    }

    protected void removeLine_helper_toFCP(GraphEntity.ID iD, GraphEntity.Type type, String string) {
        Enumeration enumeration = this.dataModel.associatorID(type, iD);
        while (enumeration.hasMoreElements()) {
            GraphFCPort.ID iD2 = (GraphFCPort.ID)enumeration.nextElement();
            Enumeration enumeration2 = this.dataModel.reference(GraphFCPort2FCPort.TYPE, iD2);
            while (enumeration2.hasMoreElements()) {
                GraphFCPort2FCPort graphFCPort2FCPort = (GraphFCPort2FCPort)enumeration2.nextElement();
                GraphFCPort2FCPort.ID iD3 = (GraphFCPort2FCPort.ID)graphFCPort2FCPort.getEntityID();
                Hashtable hashtable = (Hashtable)this.widgetH.get(string);
                AbstractJTopoLine abstractJTopoLine = (AbstractJTopoLine)hashtable.remove(iD3);
                if (abstractJTopoLine == null) continue;
                this.canvasPanel.remove(abstractJTopoLine);
                WidgetPool.getInstance().recycleWidget(abstractJTopoLine);
            }
        }
    }

    public void applyHighlight(ControllerView.HighlightDelta highlightDelta) {
        Serializable serializable;
        int n;
        Serializable serializable2;
        GraphEntity.ID iD;
        this.controllerView.getControllerApp();
        Iterator iterator = highlightDelta.iteratorRemove();
        while (iterator.hasNext()) {
            iD = (GraphEntity.ID)iterator.next();
            serializable2 = this.getWidgets(iD);
            n = 0;
            while (n < ((Vector)serializable2).size()) {
                serializable = (AbstractJTopoEntity)((Vector)serializable2).elementAt(n);
                ((AbstractJTopoEntity)serializable).setHighlighted(false);
                ((AbstractJTopoUnit)serializable).highlightChanged();
                ++n;
            }
        }
        iterator = highlightDelta.iteratorAdd();
        while (iterator.hasNext()) {
            iD = (GraphEntity.ID)iterator.next();
            serializable2 = this.getWidgets(iD);
            n = 0;
            while (n < ((Vector)serializable2).size()) {
                serializable = (AbstractJTopoEntity)((Vector)serializable2).elementAt(n);
                ((AbstractJTopoEntity)serializable).setHighlighted(true);
                ((AbstractJTopoUnit)serializable).highlightChanged();
                ++n;
            }
        }
        iD = (GraphZoneMember.ID)highlightDelta.getClickedEntityID();
        if (iD != null) {
            serializable2 = (GraphZoneMember)this.dataModel.get(iD);
            GraphFCPort.ID iD2 = ((GraphZoneMember)serializable2).getFCPortID();
            serializable = this.getWidgets(iD2);
            if (((Vector)serializable).size() == 0) {
                GraphEntity.ID iD3 = ((GraphZoneMember)serializable2).getParentID();
                serializable = this.getWidgets(iD3);
            }
            int n2 = 0;
            while (n2 < ((Vector)serializable).size()) {
                AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)((Vector)serializable).elementAt(n2);
                boolean bl = TopoUtilities.expand(abstractJTopoEntity);
                if (bl) {
                    SwingUtilities.invokeLater(new DelayFocus(abstractJTopoEntity, this));
                } else {
                    TopoUtilities.focus(abstractJTopoEntity, this);
                }
                ++n2;
            }
        }
    }

    public void applyLocate(ControllerView.LocateDelta locateDelta) {
        AbstractJTopoEntity abstractJTopoEntity;
        int n;
        Vector vector;
        GraphEntity.ID iD;
        this.controllerView.getControllerApp();
        Iterator iterator = locateDelta.iteratorRemove();
        while (iterator.hasNext()) {
            iD = (GraphEntity.ID)iterator.next();
            vector = this.getWidgets(iD);
            n = 0;
            while (n < vector.size()) {
                abstractJTopoEntity = (AbstractJTopoEntity)vector.elementAt(n);
                abstractJTopoEntity.setHighlighted(false);
                abstractJTopoEntity.highlightChanged();
                ++n;
            }
        }
        iterator = locateDelta.iteratorAdd();
        while (iterator.hasNext()) {
            iD = (GraphEntity.ID)iterator.next();
            vector = this.getWidgets(iD);
            n = 0;
            while (n < vector.size()) {
                abstractJTopoEntity = (AbstractJTopoEntity)vector.elementAt(n);
                abstractJTopoEntity.setHighlighted(true);
                abstractJTopoEntity.highlightChanged();
                ++n;
            }
        }
        iD = locateDelta.getClickedEntityID();
        vector = this.getWidgets(iD);
        n = 0;
        while (n < vector.size()) {
            abstractJTopoEntity = (AbstractJTopoEntity)vector.elementAt(n);
            boolean bl = TopoUtilities.expand(abstractJTopoEntity);
            if (bl) {
                SwingUtilities.invokeLater(new DelayFocus(abstractJTopoEntity, this));
            } else {
                TopoUtilities.focus(abstractJTopoEntity, this);
            }
            ++n;
        }
    }

    protected void expandGroup(AbstractJTopoGroup abstractJTopoGroup, boolean bl, boolean bl2) {
        if (abstractJTopoGroup.isExpansible()) {
            abstractJTopoGroup.setExpanded(bl);
            if (bl2) {
                Vector vector = abstractJTopoGroup.getLogicalChilds();
                int n = 0;
                while (n < vector.size()) {
                    AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)vector.elementAt(n);
                    if (abstractJTopoEntity instanceof AbstractJTopoGroup) {
                        this.expandGroup((AbstractJTopoGroup)abstractJTopoEntity, bl, bl2);
                    }
                    ++n;
                }
            }
        }
    }

    protected abstract Vector getFirstLevelGroup();

    protected void handleUnitRightClick(MouseEvent mouseEvent) {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        JPopupMenu jPopupMenu = new JPopupMenu();
        boolean bl = false;
        TopoEventSource topoEventSource = (TopoEventSource)mouseEvent.getSource();
        Object object2 = topoEventSource.getHandler();
        if (object2 != null) {
            if (object2 instanceof AbstractJTopoIcon) {
                Serializable serializable3;
                Serializable serializable4;
                Serializable serializable5;
                object = new Vector();
                Serializable serializable6 = this.controllerView.getSelection();
                serializable2 = ((HashSet)serializable6).iterator();
                while (serializable2.hasNext()) {
                    serializable5 = (GraphEntity.ID)serializable2.next();
                    serializable4 = this.getWidgets((GraphEntity.ID)serializable5);
                    if (serializable4.size() > 0) {
                        serializable = (AbstractJTopoEntity)serializable4.elementAt(0);
                        if (!(serializable instanceof AbstractJTopoIcon)) continue;
                        ((Vector)object).add(serializable);
                        continue;
                    }
                    serializable = this.getPins((GraphEntity.ID)serializable5);
                    if (((Vector)serializable).size() <= 0) continue;
                    serializable3 = (AbstractJTopoPin)((Vector)serializable).elementAt(0);
                    ((Vector)object).add(serializable3);
                }
                if (((Vector)object).size() == 1) {
                    serializable6 = (AbstractJTopoIcon)((Vector)object).elementAt(0);
                    serializable2 = ((AbstractJTopoUnit)serializable6).getFocusEntity();
                    serializable5 = ((GraphEntity)serializable2).getEntityID();
                    if (serializable2 instanceof GraphSwitch || serializable2 instanceof GraphSubsystem || serializable2 instanceof GraphTapeLibrary || serializable2 instanceof GraphComputer || serializable2 instanceof GraphOther) {
                        serializable4 = new JMenuItem(new Action_OpenDetailView((AbstractJTopoEntity)serializable6));
                        jPopupMenu.add((JMenuItem)serializable4);
                        jPopupMenu.addSeparator();
                    }
                    if (serializable2 instanceof GraphSwitch || serializable2 instanceof GraphSubsystem || serializable2 instanceof GraphTapeLibrary || serializable2 instanceof GraphComputer || serializable2 instanceof GraphOther) {
                        serializable4 = new JMenuItem(new Action_LaunchDetailPanel((GraphEntity.ID)serializable5));
                        jPopupMenu.add((JMenuItem)serializable4);
                        jPopupMenu.addSeparator();
                    }
                    if (serializable2 instanceof GraphSwitch || serializable2 instanceof GraphSubsystem || serializable2 instanceof GraphTapeLibrary) {
                        serializable4 = new JMenuItem(new Action_LaunchElementManager((GraphEntity)serializable2));
                        jPopupMenu.add((JMenuItem)serializable4);
                        jPopupMenu.addSeparator();
                    }
                }
                if (((Vector)object).size() > 0) {
                    boolean bl2 = true;
                    boolean bl3 = true;
                    serializable5 = new Vector();
                    int n = 0;
                    while (n < ((Vector)object).size()) {
                        serializable = (AbstractJTopoIcon)((Vector)object).elementAt(n);
                        serializable3 = ((AbstractJTopoUnit)serializable).getFocusEntity();
                        GraphEntity.ID iD = ((GraphEntity)serializable3).getEntityID();
                        if (!(serializable3 instanceof GraphSwitch || serializable3 instanceof GraphSubsystem || serializable3 instanceof GraphTapeLibrary || serializable3 instanceof GraphComputer || serializable3 instanceof GraphOther)) {
                            bl3 = false;
                            break;
                        }
                        ((Vector)serializable5).add(iD);
                        if (((AbstractJTopoEntity)serializable).isPinned()) {
                            bl2 = false;
                        }
                        ++n;
                    }
                    if (bl3 && ((Vector)serializable5).size() > 0) {
                        JMenuItem jMenuItem = new JMenuItem(new Action_Pin((Vector)serializable5, bl2));
                        jPopupMenu.add(jMenuItem);
                        jPopupMenu.addSeparator();
                    }
                    bl2 = true;
                    serializable2 = new Vector<Serializable>();
                    int n2 = 0;
                    while (n2 < ((Vector)object).size()) {
                        AbstractJTopoIcon abstractJTopoIcon = (AbstractJTopoIcon)((Vector)object).elementAt(n2);
                        serializable = abstractJTopoIcon.getFocusEntity();
                        if (!((serializable instanceof GraphSwitch || serializable instanceof GraphSubsystem || serializable instanceof GraphTapeLibrary || serializable instanceof GraphComputer || serializable instanceof GraphOther) && GraphModelConstant.STATUS_MISSING.equals(((GraphEntity)serializable).getHealthStatus()))) {
                            bl2 = false;
                            break;
                        }
                        ((Vector)serializable2).add(serializable);
                        ++n2;
                    }
                    if (bl2 && ((Vector)serializable2).size() > 0) {
                        JMenuItem jMenuItem = new JMenuItem(new Action_RemoveMissingEntity((Vector)serializable2));
                        jPopupMenu.add(jMenuItem);
                        jPopupMenu.addSeparator();
                    }
                }
            } else if (object2 instanceof AbstractJTopoGroup) {
                Serializable serializable7;
                Serializable serializable8;
                object = new Vector();
                Serializable serializable9 = this.controllerView.getSelection();
                serializable2 = ((HashSet)serializable9).iterator();
                while (serializable2.hasNext()) {
                    AbstractJTopoGroup abstractJTopoGroup;
                    serializable8 = (GraphEntity.ID)serializable2.next();
                    serializable7 = this.getWidgets((GraphEntity.ID)serializable8);
                    if (((Vector)serializable7).size() <= 0 || !((serializable = (AbstractJTopoEntity)((Vector)serializable7).elementAt(0)) instanceof AbstractJTopoGroup)) continue;
                    AbstractJTopoEntity abstractJTopoEntity = ((AbstractJTopoUnit)serializable).getLogicalParent();
                    if (abstractJTopoEntity == null) {
                        ((Vector)object).add(serializable);
                        continue;
                    }
                    if (!(abstractJTopoEntity instanceof AbstractJTopoGroup) || !(abstractJTopoGroup = (AbstractJTopoGroup)abstractJTopoEntity).isExpanded()) continue;
                    ((Vector)object).add(serializable);
                }
                if (((Vector)object).size() == 1) {
                    serializable9 = (AbstractJTopoGroup)((Vector)object).elementAt(0);
                    serializable2 = ((AbstractJTopoUnit)serializable9).getFocusEntity();
                    serializable8 = ((GraphEntity)serializable2).getEntityID();
                    if (this instanceof JTopoCanvasOverview || serializable2 instanceof GraphFabric || serializable2 instanceof GraphComputerGroup || serializable2 instanceof GraphSwitchGroup || serializable2 instanceof GraphSubsystemGroup || serializable2 instanceof GraphTapeLibraryGroup || serializable2 instanceof GraphOtherGroup) {
                        serializable7 = new JMenuItem(new Action_OpenDetailView((AbstractJTopoEntity)serializable9));
                        jPopupMenu.add((JMenuItem)serializable7);
                        jPopupMenu.addSeparator();
                    }
                    if (serializable2 instanceof GraphFabric) {
                        serializable7 = new JMenuItem(new Action_LaunchDetailPanel((GraphEntity.ID)serializable8));
                        jPopupMenu.add((JMenuItem)serializable7);
                        jPopupMenu.addSeparator();
                    }
                }
                if (((Vector)object).size() > 0) {
                    int n = -1;
                    int n3 = 0;
                    while (n3 < ((Vector)object).size()) {
                        serializable8 = (AbstractJTopoGroup)((Vector)object).elementAt(n3);
                        if (((AbstractJTopoGroup)serializable8).isExpansible()) {
                            if (((AbstractJTopoGroup)serializable8).isExpanded()) {
                                if (n == 1) {
                                    n = 2;
                                    break;
                                }
                                n = 0;
                            } else {
                                if (n == 0) {
                                    n = 2;
                                    break;
                                }
                                n = 1;
                            }
                        }
                        ++n3;
                    }
                    if (n != -1) {
                        n3 = 0;
                        if (n == 1) {
                            n3 = 1;
                        }
                        boolean bl4 = false;
                        serializable7 = new JMenuItem(new Action_GroupExpandCollapse((Vector)object, n3 != 0, bl4));
                        jPopupMenu.add((JMenuItem)serializable7);
                    }
                    n3 = 1;
                    JComponent jComponent = new JMenuItem(new Action_GroupExpandCollapse((Vector)object, true, n3 != 0));
                    jPopupMenu.add((JMenuItem)jComponent);
                    serializable7 = new JMenuItem(new Action_GroupExpandCollapse((Vector)object, false, n3 != 0));
                    jPopupMenu.add((JMenuItem)serializable7);
                    jPopupMenu.addSeparator();
                    bl = true;
                    HashSet<Serializable> hashSet = new HashSet<Serializable>();
                    n3 = 0;
                    while (n3 < ((Vector)object).size()) {
                        jComponent = (AbstractJTopoGroup)((Vector)object).elementAt(n3);
                        if (((AbstractJTopoGroup)jComponent).isGroupByEnabled() && (serializable = this.dataModel.getGroupByCapabilities((GraphScopedType)(serializable7 = ((AbstractJTopoUnit)jComponent).getScopedID().getScopedType()))) != null) {
                            hashSet.add(serializable7);
                        }
                        ++n3;
                    }
                    if (hashSet.size() > 0) {
                        JMenuItem jMenuItem = new JMenuItem(new Action_GroupBy(hashSet));
                        jPopupMenu.add(jMenuItem);
                    }
                    boolean bl5 = true;
                    serializable2 = new Vector();
                    int n4 = 0;
                    while (n4 < ((Vector)object).size()) {
                        serializable7 = (AbstractJTopoGroup)((Vector)object).elementAt(n4);
                        serializable = ((AbstractJTopoUnit)serializable7).getFocusEntity();
                        if (!(serializable instanceof GraphFabric) || !GraphModelConstant.STATUS_MISSING.equals(((GraphEntity)serializable).getHealthStatus())) {
                            bl5 = false;
                            break;
                        }
                        ((Vector)serializable2).add(serializable);
                        ++n4;
                    }
                    if (bl5 && ((Vector)serializable2).size() > 0) {
                        JMenuItem jMenuItem = new JMenuItem(new Action_RemoveMissingEntity((Vector)serializable2));
                        jPopupMenu.add(jMenuItem);
                        jPopupMenu.addSeparator();
                    }
                }
            }
        }
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.addSeparator();
        }
        if (!bl && ((Vector)(object = this.getFirstLevelGroup())).size() > 0) {
            boolean bl6 = true;
            serializable2 = new JMenuItem(new Action_GroupExpandCollapse((Vector)object, true, bl6));
            jPopupMenu.add((JMenuItem)serializable2);
            JMenuItem jMenuItem = new JMenuItem(new Action_GroupExpandCollapse((Vector)object, false, bl6));
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
        }
        object = new JMenuItem(this.actionCloseView);
        jPopupMenu.add((JMenuItem)object);
        if (this instanceof JTopoCanvasOverview) {
            ((JMenuItem)object).setEnabled(false);
        } else {
            ((JMenuItem)object).setEnabled(true);
        }
        Serializable serializable10 = new JMenuItem(this.actionCloseAllViews);
        jPopupMenu.add((JMenuItem)serializable10);
        serializable2 = this.controllerView.getControllerApp().getTopoApp().getTopoViewGroup();
        if (((JTabbedPane)serializable2).getTabCount() == 1) {
            ((JMenuItem)serializable10).setEnabled(false);
        } else {
            ((JMenuItem)serializable10).setEnabled(true);
        }
        object = new JMenuItem(this.actionRefreshView);
        jPopupMenu.add((JMenuItem)object);
        serializable10 = new JMenuItem(this.actionRefreshAllViews);
        jPopupMenu.add((JMenuItem)serializable10);
        jPopupMenu.addSeparator();
        object = new JMenu(GuiUtil.getString("TOPO_LABEL_MENU_CONTAINER_ARRANGEBY"));
        jPopupMenu.add((JMenuItem)object);
        jPopupMenu.addSeparator();
        serializable10 = new ButtonGroup();
        serializable2 = new JRadioButtonMenuItem(new Action_ArrangeBy(TopoConstant.ARRANGE_DISPLAYNAME, true));
        ((ButtonGroup)serializable10).add((AbstractButton)serializable2);
        ((JMenu)object).add((JMenuItem)serializable2);
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new Action_ArrangeBy(TopoConstant.ARRANGE_DISPLAYNAME, false));
        ((ButtonGroup)serializable10).add(jRadioButtonMenuItem);
        ((JMenu)object).add(jRadioButtonMenuItem);
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(new Action_ArrangeBy(TopoConstant.ARRANGE_STATUS, true));
        ((ButtonGroup)serializable10).add(jRadioButtonMenuItem2);
        ((JMenu)object).add(jRadioButtonMenuItem2);
        serializable = new JRadioButtonMenuItem(new Action_ArrangeBy(TopoConstant.ARRANGE_STATUS, false));
        ((ButtonGroup)serializable10).add((AbstractButton)serializable);
        ((JMenu)object).add((JMenuItem)serializable);
        if (this.arrangeRecord != null) {
            if (TopoConstant.ARRANGE_DISPLAYNAME.equals(this.arrangeRecord.getProp())) {
                if (this.arrangeRecord.isAsc()) {
                    ((AbstractButton)serializable2).setSelected(true);
                } else {
                    jRadioButtonMenuItem.setSelected(true);
                }
            } else if (TopoConstant.ARRANGE_STATUS.equals(this.arrangeRecord.getProp())) {
                if (this.arrangeRecord.isAsc()) {
                    jRadioButtonMenuItem2.setSelected(true);
                } else {
                    ((AbstractButton)serializable).setSelected(true);
                }
            }
        }
        object = new JMenuItem(this.actionClearHighlights);
        jPopupMenu.add((JMenuItem)object);
        serializable10 = this.controllerView.getHighlight();
        serializable2 = this.controllerView.getLocate();
        boolean bl7 = ((HashSet)serializable10).size() > 0 || ((HashSet)serializable2).size() > 0;
        ((JMenuItem)object).setEnabled(bl7);
        jPopupMenu.addSeparator();
        object = new JMenuItem(this.actionGlobalSetting);
        jPopupMenu.add((JMenuItem)object);
        serializable10 = new JMenuItem(this.actionRefreshSetting);
        jPopupMenu.add((JMenuItem)serializable10);
        jPopupMenu.addSeparator();
        object = new JMenuItem(this.actionPrint);
        jPopupMenu.add((JMenuItem)object);
        serializable10 = new JMenuItem(this.actionPrintPreview);
        jPopupMenu.add((JMenuItem)serializable10);
        object = topoEventSource.getSource();
        jPopupMenu.show((Component)object, mouseEvent.getX(), mouseEvent.getY());
    }

    public Point getViewPosition() {
        return this.viewport == null ? null : this.viewport.getViewPosition();
    }

    public void setViewPosition(Point point) {
        if (this.viewport != null) {
            this.viewport.setViewPosition(point);
            this.repaint();
            this.controllerView.viewportPositionChanged();
        }
    }

    protected void handleUnitMouseDrag(Point point) {
        Point point2 = this.viewport.getViewPosition();
        Point point3 = new Point(point2.x - point.x, point2.y - point.y);
        this.setViewPosition(point3);
    }

    public void openView(AbstractJTopoEntity abstractJTopoEntity) {
        GraphEntity graphEntity = abstractJTopoEntity.getFocusEntity();
        Vector<GraphEntity.ID> vector = null;
        if (abstractJTopoEntity instanceof AbstractJTopoGroup) {
            Vector vector2 = ((AbstractJTopoGroup)abstractJTopoEntity).getLogicalChilds();
            vector = new Vector<GraphEntity.ID>();
            int n = 0;
            while (n < vector2.size()) {
                AbstractJTopoEntity abstractJTopoEntity2 = (AbstractJTopoEntity)vector2.elementAt(n);
                GraphEntity.ID iD = abstractJTopoEntity2.getFocusEntityID();
                vector.add(iD);
                ++n;
            }
        }
        this.controllerView.getControllerApp().openView(graphEntity, vector);
    }

    public void arrange() {
        Enumeration enumeration = this.widgetH.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                Object v = enumeration2.nextElement();
                if (!(v instanceof AbstractJTopoGroup)) continue;
                AbstractJTopoGroup abstractJTopoGroup = (AbstractJTopoGroup)v;
                abstractJTopoGroup.setArrange(this.arrangeRecord);
            }
        }
    }

    public void printCanvas() {
        this.print.print();
    }

    protected void revalidateLine_helper(String string) {
        Enumeration enumeration = ((Hashtable)this.widgetH.get(string)).elements();
        while (enumeration.hasMoreElements()) {
            AbstractJTopoLine abstractJTopoLine = (AbstractJTopoLine)enumeration.nextElement();
            abstractJTopoLine.setFirstPassOfLayout(false);
            abstractJTopoLine.revalidate();
        }
    }

    protected void adjustLine_helper(String string) {
        LineAggregator lineAggregator = new LineAggregator();
        Enumeration enumeration = ((Hashtable)this.widgetH.get(string)).elements();
        while (enumeration.hasMoreElements()) {
            AbstractJTopoLine abstractJTopoLine = (AbstractJTopoLine)enumeration.nextElement();
            abstractJTopoLine.setFirstPassOfLayout(true);
            ITopoAssociationModel iTopoAssociationModel = (ITopoAssociationModel)abstractJTopoLine.getWidgetModel();
            AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)iTopoAssociationModel.getFromWidget().getLastVisibleUnit();
            AbstractJTopoEntity abstractJTopoEntity2 = (AbstractJTopoEntity)iTopoAssociationModel.getToWidget().getLastVisibleUnit();
            if (abstractJTopoEntity == abstractJTopoEntity2) {
                abstractJTopoLine.setVisible(false);
                continue;
            }
            abstractJTopoLine.setVisible(true);
            lineAggregator.add(abstractJTopoEntity, abstractJTopoEntity2, abstractJTopoLine);
        }
        lineAggregator.overwriteColorAndVisible();
    }

    protected abstract LayoutManager createDefaultLayout();

    protected class ML_Click
    extends MouseAdapter {
        protected ML_Click() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            mouseEvent.setSource(new TopoEventSource(mouseEvent));
            AbstractJTopoCanvas.this.handleMouseClick(mouseEvent);
        }
    }

    private class DelayFocus
    implements Runnable {
        private AbstractJTopoEntity widget;
        private AbstractJTopoCanvas canvas;

        public DelayFocus(AbstractJTopoEntity abstractJTopoEntity, AbstractJTopoCanvas abstractJTopoCanvas2) {
            this.widget = abstractJTopoEntity;
            this.canvas = abstractJTopoCanvas2;
        }

        public void run() {
            TopoUtilities.focus(this.widget, this.canvas);
        }
    }

    protected class ML_Drag
    extends MouseAdapter
    implements MouseMotionListener {
        protected Point last;
        protected boolean isCursorSet;

        protected ML_Drag() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isAltDown()) {
                this.last = mouseEvent.getPoint();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.isAltDown()) {
                if (!this.isCursorSet) {
                    AbstractJTopoCanvas.this.setCursor(Cursor.getPredefinedCursor(13));
                    this.isCursorSet = true;
                }
                Point point = mouseEvent.getPoint();
                Point point2 = new Point(point.x - this.last.x, point.y - this.last.y);
                this.last.setLocation(point);
                JViewport jViewport = (JViewport)mouseEvent.getSource();
                if (jViewport.contains(point)) {
                    Point point3 = jViewport.getViewPosition();
                    Point point4 = new Point(point3.x - point2.x, point3.y - point2.y);
                    AbstractJTopoCanvas.this.setViewPosition(point4);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.last = null;
            if (this.isCursorSet) {
                AbstractJTopoCanvas.this.setCursor(Cursor.getPredefinedCursor(0));
                this.isCursorSet = false;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    protected class Action_RefreshView
    extends AbstractAction {
        public Action_RefreshView() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_REFRESHTHISVIEW"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphModel.ID iD = AbstractJTopoCanvas.this.dataModel.getModelID();
            ControllerApp controllerApp = AbstractJTopoCanvas.this.controllerView.getControllerApp();
            controllerApp.refreshView(iD);
        }
    }

    protected class Action_RefreshAllViews
    extends AbstractAction {
        public Action_RefreshAllViews() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_REFRESHALLVIEWS"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControllerApp controllerApp = AbstractJTopoCanvas.this.controllerView.getControllerApp();
            controllerApp.refreshAllViews();
        }
    }

    protected class Action_CloseView
    extends AbstractAction {
        public Action_CloseView() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_CLOSETHISVIEW"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphModel.ID iD = AbstractJTopoCanvas.this.dataModel.getModelID();
            ControllerApp controllerApp = AbstractJTopoCanvas.this.controllerView.getControllerApp();
            controllerApp.closeView(iD);
        }
    }

    protected class Action_CloseAllViews
    extends AbstractAction {
        public Action_CloseAllViews() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_CLOSEALLVIEWS"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControllerApp controllerApp = AbstractJTopoCanvas.this.controllerView.getControllerApp();
            controllerApp.closeAllViews();
        }
    }

    protected class Action_ClearHighlights
    extends AbstractAction {
        public Action_ClearHighlights() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_CLEARHIGHLIGHTS"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControllerView.HighlightDelta highlightDelta = new ControllerView.HighlightDelta(AbstractJTopoCanvas.this.controllerView.getHighlight());
            highlightDelta.removeAll();
            AbstractJTopoCanvas.this.controllerView.updateHighlight(highlightDelta);
            ControllerView.LocateDelta locateDelta = new ControllerView.LocateDelta(null, AbstractJTopoCanvas.this.controllerView.getLocate());
            locateDelta.removeAll();
            AbstractJTopoCanvas.this.controllerView.updateLocate(locateDelta);
        }
    }

    protected class Action_GlobalSetting
    extends AbstractAction {
        public Action_GlobalSetting() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_GLOBALSETTINGS"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTopoApp jTopoApp = AbstractJTopoCanvas.this.controllerView.getControllerApp().getTopoApp();
            jTopoApp.showGlobalSettingDialog();
        }
    }

    protected class Action_RefreshSetting
    extends AbstractAction {
        public Action_RefreshSetting() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_REFRESHSETTINGS"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTopoApp jTopoApp = AbstractJTopoCanvas.this.controllerView.getControllerApp().getTopoApp();
            jTopoApp.showRefreshSettingDialog();
        }
    }

    protected class Action_Print
    extends AbstractAction {
        public Action_Print() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_PRINT"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractJTopoCanvas.this.printCanvas();
        }
    }

    protected class Action_PrintPreview
    extends AbstractAction {
        public Action_PrintPreview() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_PRINTPREVIEW"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractJTopoCanvas.this.print.preview();
        }
    }

    protected class Action_GroupExpandCollapse
    extends AbstractAction {
        private Vector groupWidgetV;
        private boolean toBeExpanded;
        private boolean recursive;

        public Action_GroupExpandCollapse(Vector vector, boolean bl, boolean bl2) {
            this.groupWidgetV = vector;
            this.toBeExpanded = bl;
            this.recursive = bl2;
            if (bl2) {
                if (bl) {
                    this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_EXPANDALL"));
                } else {
                    this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_COLLAPSEALL"));
                }
            } else if (bl) {
                this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CONTAINER_EXPAND"));
            } else {
                this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CONTAINER_COLLAPSE"));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            while (n < this.groupWidgetV.size()) {
                AbstractJTopoGroup abstractJTopoGroup = (AbstractJTopoGroup)this.groupWidgetV.elementAt(n);
                AbstractJTopoCanvas.this.expandGroup(abstractJTopoGroup, this.toBeExpanded, this.recursive);
                ++n;
            }
        }
    }

    protected class Action_OpenDetailView
    extends AbstractAction {
        private AbstractJTopoEntity unit;

        public Action_OpenDetailView(AbstractJTopoEntity abstractJTopoEntity) {
            this.unit = abstractJTopoEntity;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_OPEN"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractJTopoCanvas.this.openView(this.unit);
        }
    }

    protected class Action_Pin
    extends AbstractAction {
        private Vector entityIDV;
        private boolean doPin;

        public Action_Pin(Vector vector, boolean bl) {
            this.entityIDV = vector;
            this.doPin = bl;
            if (bl) {
                this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_PINNED"));
            } else {
                this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_UNPINNED"));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControllerApp controllerApp = AbstractJTopoCanvas.this.controllerView.getControllerApp();
            PinList pinList = controllerApp.getPinList();
            if (this.doPin) {
                pinList.addPins(this.entityIDV);
            } else {
                pinList.removePins(this.entityIDV);
            }
        }
    }

    protected class Action_LaunchDetailPanel
    extends AbstractAction {
        private GraphEntity.ID entityID;

        public Action_LaunchDetailPanel(GraphEntity.ID iD) {
            this.entityID = iD;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_DETAIL"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControllerApp controllerApp = AbstractJTopoCanvas.this.controllerView.getControllerApp();
            controllerApp.launchDetailPanel(this.entityID);
        }
    }

    protected class Action_LaunchElementManager
    extends AbstractAction {
        private GraphEntity entity;

        public Action_LaunchElementManager(GraphEntity graphEntity) {
            this.entity = graphEntity;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_ELEMENTMANAGER"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControllerApp controllerApp = AbstractJTopoCanvas.this.controllerView.getControllerApp();
            controllerApp.launchElementManager(this.entity);
        }
    }

    protected class Action_RemoveMissingEntity
    extends AbstractAction {
        private Vector entityV;

        public Action_RemoveMissingEntity(Vector vector) {
            this.entityV = vector;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_REMOVE"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControllerApp controllerApp = AbstractJTopoCanvas.this.controllerView.getControllerApp();
            controllerApp.removeMissingEntity(this.entityV);
        }
    }

    protected class Action_ArrangeBy
    extends AbstractAction {
        private Integer prop;
        private boolean asc;

        public Action_ArrangeBy(Integer n, boolean bl) {
            this.prop = n;
            this.asc = bl;
            if (TopoConstant.ARRANGE_DISPLAYNAME.equals(n)) {
                if (bl) {
                    this.putValue("Name", String.valueOf(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_LABEL")) + " (" + GuiUtil.getString("TOPO_LABEL_COMMON_ASCEND") + ")");
                } else {
                    this.putValue("Name", String.valueOf(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_LABEL")) + " (" + GuiUtil.getString("TOPO_LABEL_COMMON_DESCEND") + ")");
                }
            } else if (TopoConstant.ARRANGE_STATUS.equals(n)) {
                if (bl) {
                    this.putValue("Name", String.valueOf(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH")) + " (" + GuiUtil.getString("TOPO_LABEL_COMMON_ASCEND") + ")");
                } else {
                    this.putValue("Name", String.valueOf(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH")) + " (" + GuiUtil.getString("TOPO_LABEL_COMMON_DESCEND") + ")");
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractJTopoCanvas.this.arrangeRecord.setProp(this.prop);
            AbstractJTopoCanvas.this.arrangeRecord.setAsc(this.asc);
            AbstractJTopoCanvas.this.arrange();
        }
    }

    protected class Action_GroupBy
    extends AbstractAction {
        private HashSet scopedTypeHS;

        public Action_GroupBy(HashSet hashSet) {
            this.scopedTypeHS = hashSet;
            this.putValue("Name", String.valueOf(GuiUtil.getString("TOPO_LABEL_MENU_CONTAINER_GROUPBY")) + "...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractJTopoCanvas.this.controllerView.getControllerApp().getTopoApp().showGroupingDialog(AbstractJTopoCanvas.this.controllerView, this.scopedTypeHS);
        }
    }

    protected class ArrangeRecord {
        private Integer prop;
        private boolean asc;

        public ArrangeRecord() {
        }

        public ArrangeRecord(Integer n, boolean bl) {
            this.prop = n;
            this.asc = bl;
        }

        public boolean isAsc() {
            return this.asc;
        }

        public void setAsc(boolean bl) {
            this.asc = bl;
        }

        public Integer getProp() {
            return this.prop;
        }

        public void setProp(Integer n) {
            this.prop = n;
        }
    }

    public class LineAggregator {
        private Hashtable h = new Hashtable();

        public void add(AbstractJTopoEntity abstractJTopoEntity, AbstractJTopoEntity abstractJTopoEntity2, AbstractJTopoLine abstractJTopoLine) {
            LineRecord lineRecord = new LineRecord(abstractJTopoEntity, abstractJTopoEntity2);
            Vector<AbstractJTopoLine> vector = (Vector<AbstractJTopoLine>)this.h.get(lineRecord);
            if (vector == null) {
                vector = new Vector<AbstractJTopoLine>();
                this.h.put(lineRecord, vector);
            }
            vector.add(abstractJTopoLine);
        }

        public void overwriteColorAndVisible() {
            Enumeration enumeration = this.h.elements();
            while (enumeration.hasMoreElements()) {
                Vector<GraphEntity> vector = new Vector<GraphEntity>();
                Vector vector2 = (Vector)enumeration.nextElement();
                int n = 0;
                while (n < vector2.size()) {
                    AbstractJTopoLine abstractJTopoLine = (AbstractJTopoLine)vector2.elementAt(n);
                    vector.add(abstractJTopoLine.getFocusEntity());
                    ++n;
                }
                Integer n2 = GraphModelUtilities.aggregateHealthStatus(vector);
                boolean bl = vector2.size() > 1;
                int n3 = 0;
                while (n3 < vector2.size()) {
                    AbstractJTopoLine abstractJTopoLine = (AbstractJTopoLine)vector2.elementAt(n3);
                    if (n3 == 0) {
                        abstractJTopoLine.setVisible(true);
                        ITopoAssociationModel iTopoAssociationModel = (ITopoAssociationModel)abstractJTopoLine.getWidgetModel();
                        iTopoAssociationModel.setHealth(n2);
                        iTopoAssociationModel.setThick(bl);
                    } else {
                        abstractJTopoLine.setVisible(false);
                    }
                    ++n3;
                }
            }
        }

        public class LineRecord {
            private AbstractJTopoEntity from;
            private AbstractJTopoEntity to;

            public LineRecord(AbstractJTopoEntity abstractJTopoEntity, AbstractJTopoEntity abstractJTopoEntity2) {
                this.from = abstractJTopoEntity;
                this.to = abstractJTopoEntity2;
            }

            public AbstractJTopoEntity getFrom() {
                return this.from;
            }

            public AbstractJTopoEntity getTo() {
                return this.to;
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object == this) {
                    return true;
                }
                if (!(object instanceof LineRecord)) {
                    return false;
                }
                LineRecord lineRecord = (LineRecord)object;
                if (this.from != lineRecord.from) {
                    return false;
                }
                return this.to == lineRecord.to;
            }

            public int hashCode() {
                return this.from.hashCode() + this.to.hashCode();
            }
        }
    }

    protected class CanvasPanel
    extends JPanel {
        public CanvasPanel() {
            this.setOpaque(false);
            this.setBorder(TopoResource.BORDER_CANVAS);
            this.setLayout(null);
        }
    }

    protected class CanvasPanelContainer
    extends JPanel {
        private String panelLabel = "";
        private String filteringLabel = "";

        public CanvasPanelContainer() {
            this.setBorder(new EmptyBorder(0, 0, 2000, 2000));
            this.setBackground(TopoResource.COLOR_BACKGROUND);
            this.setLayout(new FlowLayout(0));
        }

        public void setPanelLabel(String string) {
            this.panelLabel = string;
        }

        public void setFilteringLevel(int n) {
            this.filteringLabel = n == 0 ? "" : " (" + GuiUtil.getString("TOPO_LABEL_COMMON_FILTERED") + ")";
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(TopoResource.COLOR_CANVAS_BACKGROUNDTEXT);
            graphics2D.setFont(TopoResource.FONT_CANVASPANELCONTAINER);
            graphics2D.drawString(String.valueOf(this.panelLabel) + this.filteringLabel, 0, 70);
        }
    }
}

