/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.CollationKey;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnStatus;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.plaf.basic.BasicCustomRendererTableUI;

public class JCustomRendererTable
extends JTable {
    protected CustomTableCellRenderer cellRenderer;
    protected CustomTableCellEditor cellEditor;
    protected CustomTableHeaderRenderer headerRenderer;

    public JCustomRendererTable() {
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setUpdateTableInRealTime(true);
        jTableHeader.setReorderingAllowed(true);
        this.headerRenderer = new CustomTableHeaderRenderer();
        this.cellRenderer = new CustomTableCellRenderer();
        this.cellEditor = new CustomTableCellEditor();
        BasicCustomRendererTableUI basicCustomRendererTableUI = new BasicCustomRendererTableUI();
        this.setUI(basicCustomRendererTableUI);
    }

    protected JTableHeader createDefaultTableHeader() {
        CustomJTableHeader customJTableHeader = new CustomJTableHeader(this.getColumnModel());
        return customJTableHeader;
    }

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = 0;
        while (n < tableColumnModel.getColumnCount()) {
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            tableColumn.setCellRenderer(this.cellRenderer);
            tableColumn.setCellEditor(this.cellEditor);
            tableColumn.setHeaderRenderer(this.headerRenderer);
            CustomHeader customHeader = new CustomHeader(tableColumn.getHeaderValue());
            if (tableColumn instanceof DefaultTopoTableColumnStatus) {
                customHeader.setIcon(((DefaultTopoTableColumnStatus)tableColumn).getIcon());
            }
            tableColumn.setHeaderValue(customHeader);
            ++n;
        }
    }

    protected static class CustomCell
    implements Comparable {
        protected Object value;
        protected Comparable sorting;
        protected ImageIcon icon;
        protected String str;
        protected Object aux;
        protected boolean isHighlighted;

        public CustomCell(Object object, Comparable comparable, ImageIcon imageIcon) {
            this.value = object;
            this.sorting = comparable;
            this.icon = imageIcon;
            this.str = object != null ? (object instanceof String ? (String)object : object.toString()) : "";
            this.isHighlighted = false;
        }

        public String toString() {
            return this.str;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public Comparable getSorting() {
            return this.sorting;
        }

        public void setSorting(Comparable comparable) {
            this.sorting = comparable;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public void setIcon(ImageIcon imageIcon) {
            this.icon = imageIcon;
        }

        public Object getAux() {
            return this.aux;
        }

        public void setAux(Object object) {
            this.aux = object;
        }

        public boolean isHighlighted() {
            return this.isHighlighted;
        }

        public void setHighlighted(boolean bl) {
            this.isHighlighted = bl;
        }

        public int compareTo(Object object) {
            Object object2;
            block12: {
                CustomCell customCell;
                block10: {
                    Comparable comparable;
                    block11: {
                        if (!(object instanceof CustomCell)) {
                            throw new ClassCastException();
                        }
                        customCell = (CustomCell)object;
                        try {
                            comparable = customCell.sorting;
                            if (this.sorting != null && comparable != null) {
                                if (this.sorting.getClass().equals(comparable.getClass())) {
                                    return this.sorting.compareTo(comparable);
                                }
                                break block10;
                            }
                            if (this.sorting == null) break block11;
                            return -1;
                        }
                        catch (RuntimeException runtimeException) {
                            runtimeException.printStackTrace();
                            return 0;
                        }
                    }
                    if (comparable == null) break block10;
                    return 1;
                }
                object2 = customCell.value;
                if (this.value != null && object2 != null) {
                    String string = this.value.toString();
                    String string2 = object2.toString();
                    return string.compareTo(string2);
                }
                if (this.value == null) break block12;
                return -1;
            }
            if (object2 != null) {
                return 1;
            }
            return 0;
        }
    }

    protected static class ComparableCell
    extends CustomCell {
        public ComparableCell(Comparable comparable) {
            super(comparable, comparable, null);
        }
    }

    protected static class FormatedStringCell
    extends CustomCell {
        public FormatedStringCell(String string, Comparable comparable) {
            super(string, comparable, null);
        }
    }

    protected static class StatusCell
    extends CustomCell {
        public StatusCell(String string, Integer n, ImageIcon imageIcon) {
            super(string, n, imageIcon);
        }
    }

    protected static class CollatorCell
    extends CustomCell {
        protected CollationKey collationKey;

        public CollatorCell(String string, CollationKey collationKey) {
            this(string, null, collationKey);
        }

        public CollatorCell(String string, Comparable comparable, CollationKey collationKey) {
            super(string, comparable, null);
            this.collationKey = collationKey;
        }

        public int compareTo(Object object) {
            Object object2;
            block16: {
                CollatorCell collatorCell;
                block15: {
                    CollationKey collationKey;
                    block14: {
                        block13: {
                            Comparable comparable;
                            block12: {
                                if (!(object instanceof CollatorCell)) {
                                    return super.compareTo(object);
                                }
                                collatorCell = (CollatorCell)object;
                                try {
                                    comparable = collatorCell.sorting;
                                    if (this.sorting != null && comparable != null) {
                                        return this.sorting.compareTo(comparable);
                                    }
                                    if (this.sorting == null) break block12;
                                    return -1;
                                }
                                catch (RuntimeException runtimeException) {
                                    return 0;
                                }
                            }
                            if (comparable == null) break block13;
                            return 1;
                        }
                        collationKey = collatorCell.collationKey;
                        if (this.collationKey != null && collationKey != null) {
                            return this.collationKey.compareTo(collationKey);
                        }
                        if (this.collationKey == null) break block14;
                        return -1;
                    }
                    if (collationKey == null) break block15;
                    return 1;
                }
                object2 = collatorCell.value;
                if (this.value != null && object2 != null) {
                    String string = this.value.toString();
                    String string2 = object2.toString();
                    return string.compareTo(string2);
                }
                if (this.value == null) break block16;
                return -1;
            }
            if (object2 != null) {
                return 1;
            }
            return 0;
        }
    }

    protected static class GroupLabelCell
    extends CollatorCell {
        protected DefaultTopoTableModel.GroupNode group;
        protected ImageIcon adjustedMinusIcon;
        protected ImageIcon adjustedPlusIcon;
        protected int iconPosStart;
        protected int iconPosEnd;

        public GroupLabelCell(String string, Comparable comparable, CollationKey collationKey, DefaultTopoTableModel.GroupNode groupNode) {
            super(string, comparable, collationKey);
            this.group = groupNode;
            this.adjustIcon();
        }

        public DefaultTopoTableModel.GroupNode getGroupNode() {
            return this.group;
        }

        public int getIconPosStart() {
            return this.iconPosStart;
        }

        public int getIconPosEnd() {
            return this.iconPosEnd;
        }

        public ImageIcon getIcon() {
            if (this.group.isCollapsed) {
                return this.adjustedPlusIcon;
            }
            return this.adjustedMinusIcon;
        }

        protected void adjustIcon() {
            int n = this.group.getLevel();
            ImageIcon imageIcon = TopoResource.ICON_BOX_EMPTY;
            int n2 = imageIcon.getIconWidth();
            int n3 = imageIcon.getIconHeight();
            this.iconPosStart = n2 * (n - 1);
            this.iconPosEnd = n2 * n;
            ImageIcon imageIcon2 = TopoResource.ICON_BOX_MINUS;
            BufferedImage bufferedImage = new BufferedImage(n2 * n, n3, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(imageIcon2.getImage(), n2 * (n - 1), 0, null);
            graphics2D.dispose();
            this.adjustedMinusIcon = new ImageIcon(bufferedImage);
            ImageIcon imageIcon3 = TopoResource.ICON_BOX_PLUS;
            bufferedImage = new BufferedImage(n2 * n, n3, 2);
            graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(imageIcon3.getImage(), n2 * (n - 1), 0, null);
            graphics2D.dispose();
            this.adjustedPlusIcon = new ImageIcon(bufferedImage);
        }
    }

    protected static class MemberGroupLabelCell
    extends ComparableCell {
        protected DefaultTopoTableModel.GroupNode group;

        public MemberGroupLabelCell(String string, DefaultTopoTableModel.GroupNode groupNode) {
            super((Comparable)((Object)string));
            this.group = groupNode;
            this.adjustIcon();
        }

        public DefaultTopoTableModel.GroupNode getGroupNode() {
            return this.group;
        }

        protected void adjustIcon() {
            ImageIcon imageIcon;
            int n = this.group.getLevel();
            ImageIcon imageIcon2 = TopoResource.ICON_BOX_EMPTY;
            int n2 = imageIcon2.getIconWidth();
            int n3 = imageIcon2.getIconHeight();
            BufferedImage bufferedImage = new BufferedImage(n2 * n, n3, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(imageIcon2.getImage(), n2 * (n - 1), 0, null);
            graphics2D.dispose();
            this.icon = imageIcon = new ImageIcon(bufferedImage);
        }

        public int compareTo(Object object) {
            return 0;
        }
    }

    protected class CustomTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected JTextField textField = new JTextField();
        protected Object value;

        public CustomTableCellEditor() {
            this.textField.setEditable(false);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.value = object;
            if (object instanceof CustomCell) {
                CustomCell customCell = (CustomCell)object;
                this.textField.setText(customCell.toString());
                if (customCell.isHighlighted()) {
                    JCustomRendererTable.this.setBorder(TopoResource.BORDER_TABLECELL_HIGHLIGHTED);
                } else {
                    JCustomRendererTable.this.setBorder(null);
                }
                if (customCell instanceof GroupLabelCell) {
                    JCustomRendererTable.this.setFont(TopoResource.FONT_BOLD);
                } else {
                    JCustomRendererTable.this.setFont(TopoResource.FONT_PLAIN);
                }
            } else {
                this.textField.setText(object == null ? null : object.toString());
            }
            return this.textField;
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() >= 2;
            }
            return true;
        }
    }

    protected class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        public CustomTableCellRenderer() {
            this.setHorizontalAlignment(2);
        }

        public void setValue(Object object) {
            if (object instanceof CustomCell) {
                CustomCell customCell = (CustomCell)object;
                this.setIcon(customCell.getIcon());
                super.setValue(customCell.toString());
                if (customCell.isHighlighted()) {
                    this.setBorder(TopoResource.BORDER_TABLECELL_HIGHLIGHTED);
                } else {
                    this.setBorder(null);
                }
                if (customCell instanceof GroupLabelCell) {
                    this.setFont(TopoResource.FONT_BOLD);
                } else {
                    this.setFont(TopoResource.FONT_PLAIN);
                }
            } else {
                this.setIcon(null);
                super.setValue(object);
            }
        }
    }

    protected class CustomJTableHeader
    extends JTableHeader {
        public CustomJTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.columnModel.getColumnIndexAtX(point.x);
            String string = null;
            if (n != -1) {
                string = this.columnModel.getColumn(n).getHeaderValue().toString();
            }
            return string;
        }
    }

    protected class CustomTableHeaderRenderer
    extends DefaultTableCellRenderer {
        public CustomTableHeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            if (jTable != null && (object2 = jTable.getTableHeader()) != null) {
                this.setForeground(((Component)object2).getForeground());
                this.setBackground(((Component)object2).getBackground());
                this.setFont(((Component)object2).getFont());
            }
            if (object instanceof CustomHeader) {
                object2 = (CustomHeader)object;
                this.setText(((CustomHeader)object2).toString());
                this.setIcon(((CustomHeader)object2).getIcon());
            } else {
                this.setText(object == null ? "" : object.toString());
                this.setIcon(null);
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    protected static class CustomHeader {
        private Object value;
        private ImageIcon icon;

        public CustomHeader(Object object) {
            this.value = object;
            this.icon = null;
        }

        public String toString() {
            return this.value == null ? "" : this.value.toString();
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public void setIcon(ImageIcon imageIcon) {
            this.icon = imageIcon;
        }
    }
}

