/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.objects.Identifier;
import org.eclipse.aperi.infrastructure.database.sql.SqlIdentifier;
import org.eclipse.aperi.sanmgmt.Variables;

public class AutoIdentifier {
    public static final int RESOURCE_ID = 1;
    public static final int RUN_NUMBER_ID = 2;
    public static final int SCHEDULE_ID = 3;
    public static final int JOB_ID = 4;
    public static final int CALENDAR_ID = 5;
    public static final int ALERT_LOG_ID = 6;
    public static final int DEVICE_SERVER_RUN_ID = 7;
    public static final int TOKEN_ID = 8;
    public static final int SNAPSHOT_ID = 9;
    public static final int SNMP_ID = 10;
    public static final int PM_TIME_ID = 11;
    public static final int PM_RECORD_ID = 12;
    public static final int VENDOR_ID = 13;
    public static final int MODEL_ID = 14;
    public static final int CLASSNAME_ID = 15;
    public static final int SWITCHTYPE_ID = 16;
    public static List idList = null;
    private static final int ALLOC_LEN = 1000;
    private static final int MIN_LEN = 100;
    public static String baseDir = null;
    public static final String cacheFile = "idList";

    public static void initialize() {
        try {
            baseDir = Variables.getBaseDirectory();
            baseDir = String.valueOf(baseDir) + File.separator;
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(String.valueOf(baseDir) + cacheFile));
            int n = objectInputStream.readInt();
            idList = Collections.synchronizedList(new LinkedList());
            int n2 = 0;
            while (n2 < n) {
                int n3 = objectInputStream.readInt();
                int n4 = objectInputStream.readInt();
                int n5 = objectInputStream.readInt();
                idList.add(new idElement(n3, n4, n5));
                ++n2;
            }
            objectInputStream.close();
            File file = new File(String.valueOf(baseDir) + cacheFile);
            file.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void shutdown() {
        try {
            if (idList != null) {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(String.valueOf(baseDir) + cacheFile));
                objectOutputStream.writeInt(idList.size());
                ListIterator listIterator = idList.listIterator();
                while (listIterator.hasNext()) {
                    idElement idElement2 = (idElement)listIterator.next();
                    objectOutputStream.writeInt(idElement2.start);
                    objectOutputStream.writeInt(idElement2.count);
                    objectOutputStream.writeInt(idElement2.idType);
                }
                objectOutputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static synchronized int getIdentifier(int n, int n2) throws SQLException {
        idElement idElement2;
        int n3 = 0;
        int n4 = 0;
        if (idList != null) {
            ListIterator listIterator = idList.listIterator();
            while (listIterator.hasNext()) {
                idElement2 = (idElement)listIterator.next();
                if (idElement2.idType != n) continue;
                n3 += idElement2.count;
                if (idElement2.count <= n4) continue;
                n4 = idElement2.count;
            }
        }
        if (n3 < 100) {
            int n5 = AutoIdentifier.getIdentifierFromDB(n, 1000);
            if (idList == null) {
                idList = Collections.synchronizedList(new LinkedList());
            }
            idElement2 = new idElement(n5, 1000, n);
            idList.add(idElement2);
            n3 += 1000;
            if (1000 > n4) {
                n4 = 1000;
            }
        }
        if (n2 > n4) {
            int n6 = AutoIdentifier.getIdentifierFromDB(n, n2);
            return n6;
        }
        int n7 = -1;
        idElement2 = null;
        ListIterator listIterator = idList.listIterator();
        while (listIterator.hasNext()) {
            idElement idElement3 = (idElement)listIterator.next();
            if (idElement3.idType != n || n2 > idElement3.count) continue;
            n7 = idElement3.start;
            idElement3.start += n2;
            idElement3.count -= n2;
            idElement2 = idElement3;
            break;
        }
        if (idElement2.count == 0) {
            idList.remove(idElement2);
        }
        return n7;
    }

    private static int getIdentifierFromDB(int n, int n2) throws SQLException {
        DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
        DBConnection dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
        Connection connection = dBConnection.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        databaseMetaData.getDatabaseProductName();
        int n3 = 3;
        int n4 = -1;
        try {
            while (true) {
                try {
                    Identifier identifier = new Identifier();
                    Vector<ColumnInfo> vector = new Vector<ColumnInfo>();
                    Vector<String> vector2 = new Vector<String>();
                    vector.add(Identifier.getColumnInfo("IDENTIFIER"));
                    vector2.add(String.valueOf(n2));
                    vector.add(Identifier.getColumnInfo("ID_TYPE"));
                    vector2.add(String.valueOf(n));
                    Hashtable hashtable = ComplexQuery.generateHashtable(vector, vector2);
                    int n5 = SqlIdentifier.sqlUpdate(dBConnection, SqlIdentifier.updateIdentifierIndex, hashtable);
                    if (n5 <= 0) {
                        throw new SQLException("No rows were updated in the identifier table for ID type " + n + " and ID count " + n2);
                    }
                    identifier.setIdType(n);
                    identifier.retrieve(dBConnection);
                    int n6 = identifier.getIdentifier();
                    dBConnection.commit();
                    n4 = n6 - n2;
                }
                catch (SQLException sQLException) {
                    block11: {
                        if (SQLExceptionHelper.isDeadlock(dBConnection, sQLException) && --n3 >= 0) {
                            try {
                                Thread.sleep(2000L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {}
                            break block11;
                            continue;
                        }
                    }
                    throw sQLException;
                }
                break;
            }
        }
        catch (Throwable throwable) {}
        if (dBConnection != null) {
            dBConnection.close();
        }
        return n4;
    }

    private static class idElement
    implements Serializable {
        int start;
        int count;
        int idType;

        public idElement(int n, int n2, int n3) {
            this.start = n;
            this.count = n2;
            this.idType = n3;
        }
    }
}

